/*!
	SimpleQueueTemplate.h

	Queue ev[g
	f[^CSimpleArrayTemplateɊi[
	ǉE擾͊{IɍAL[TCYɂ͔ɎԂ邽߁A炩߃TCYݒ肵ėpB
*/
#pragma once
#include "SimpleArrayTemplate.h"


/*!
	Queue ev[g
*/
template< class _TYPE, class _ARG_TYPE = _TYPE&, class _CONSTRUCTOR = CSimpleArrayTemplateItmeConstructor<_TYPE>, int INIT_ALLOC = 5>
class CSimpleQueueTemplate
{
protected:
	//	qNXŎgpł悤
	typedef	_TYPE			TYPE;
	typedef	_ARG_TYPE		ARG_TYPE;
	typedef	_CONSTRUCTOR	CONSTRUCTOR;

public:
	CSimpleQueueTemplate(void)
	{
		InitInternal();
		SetMinQueueSize(INIT_ALLOC);
	}

	virtual ~CSimpleQueueTemplate(void)
	{
		Close();
	}

	//////////////////////////////////////////////////////////////
	//	A
	//////////////////////////////////////////////////////////////
	/*!
		i[TCYݒ
	*/
	virtual void SetMinQueueSize(int size)
	{
		int oldSize = m_array.GetCount();
		if(oldSize < size)
		{
			//	
			m_array.SetSize(size);

			//	ړ
			Relocation(oldSize, size);
		}
	}

	/*!
		i[̃TCY擾
	*/
	virtual int GetCount()
	{
		return m_usingSize;
	}

	/*!
		SNA
	*/
	virtual void RemoveAll()
	{
		Close();
	}

	//////////////////////////////////////////////////////////////
	//	ǉA擾
	//////////////////////////////////////////////////////////////
	/*!
		ǉ
	*/
	virtual void AddTail(ARG_TYPE item)
	{
		Grow(1);

		//	ۑ
		m_array[m_writePoint] = item;
		m_usingSize++;
		ASSERT(m_usingSize <= m_array.GetCount());

		//	݃|C^ړ
		m_writePoint++;
		if(m_writePoint == m_array.GetCount())
			m_writePoint = 0; 

		ASSERT(	(m_writePoint == m_readPoint && (m_usingSize == 0 || m_usingSize ==  m_array.GetCount())) ||
				(m_writePoint > m_readPoint && m_writePoint - m_readPoint == m_usingSize) || 
				(m_writePoint < m_readPoint && m_array.GetCount() - (m_readPoint - m_writePoint)  == m_usingSize));
	}

	/*!
		擾
	*/
	virtual ARG_TYPE RemoveHead()
	{
		ASSERT(m_usingSize > 0);

		//	擾
		ARG_TYPE ret = m_array[m_readPoint];
		m_usingSize--;

		//	ǂݍ݃|C^ړ
		m_readPoint++;
		if(m_readPoint == m_array.GetCount())
			m_readPoint = 0; 

		ASSERT(	(m_writePoint == m_readPoint && (m_usingSize == 0 || m_usingSize ==  m_array.GetCount())) ||
				(m_writePoint > m_readPoint && m_writePoint - m_readPoint == m_usingSize) || 
				(m_writePoint < m_readPoint && m_array.GetCount() - (m_readPoint - m_writePoint)  == m_usingSize));

		return	ret;
	}

	/*!
		擾
	*/
	virtual ARG_TYPE GetHead()
	{
		ASSERT(m_usingSize > 0);

		//	擾
		ARG_TYPE ret = m_array[m_readPoint];

		ASSERT(	(m_writePoint == m_readPoint && (m_usingSize == 0 || m_usingSize ==  m_array.GetCount())) ||
				(m_writePoint > m_readPoint && m_writePoint - m_readPoint == m_usingSize) || 
				(m_writePoint < m_readPoint && m_array.GetCount() - (m_readPoint - m_writePoint)  == m_usingSize));

		return	ret;
	}

protected:
	//////////////////////////////////////////////////////////////
	//	⏕
	//////////////////////////////////////////////////////////////
	//!	ϐ
	virtual void InitInternal()
	{
		m_readPoint = 0;
		m_writePoint = 0;
		m_usingSize = 0;
	}

	//!	Sf[^
	virtual void Close()
	{
		m_array.RemoveAll();
		InitInternal();
	}

	//!	KvȂ瑝
	virtual void Grow(int wantSize)
	{
		while(m_array.GetCount() < wantSize + m_usingSize)
			SetMinQueueSize(m_array.GetCount() * 2 + 1);	//	2{
	}

	//!	Ĕzu
	virtual void Relocation(int oldSize, int newSize)
	{
		if(m_readPoint <= m_readPoint)
		{
			//	啪
			int grew = newSize - oldSize;

			//	ړ
			if(m_writePoint < grew)
			{
				//	ֈړ
				for(int i=0;i<m_writePoint;i++)
					m_array[oldSize + i] = m_array[i];
				m_writePoint = oldSize + m_writePoint;
			}
			else
			{
				//	ֈړ
				for(int i=0;i<grew;i++)
					m_array[oldSize + i] = m_array[i];

				//	c擪ֈړ
				int left = m_writePoint - grew;
				for(int i=0;i<left;i++)
					m_array[i] = m_array[i + grew];
				m_writePoint = left;
			}
		}
	}

public:
	//////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////
	//!	obt@
	CSimpleArrayTemplate<TYPE, ARG_TYPE, CONSTRUCTOR, INIT_ALLOC>	m_array;

	//!	ǂݍ݈ʒu
	int						m_readPoint;

	//!	݈ʒu
	int						m_writePoint;

	//!	gpTCY
	int						m_usingSize;
};



/*!
	|C^p Queue ev[g
*/
template< class _TYPE, int INIT_ALLOC = 10>
class CPtrQueueTemplate : public CSimpleArrayTemplate<_TYPE, _TYPE, CSimpleArrayTemplateItmeConstructor<_TYPE>, INIT_ALLOC>
{
protected:
	//	qNXŎgpł悤
	typedef	_TYPE			TYPE;
};

