#pragma once
#include "types/UTF8Types.h"

//!	RA
class CUTF8StringData;

/*!
	UTF8^NX
*/
class CUTF8String
{
public:
	////////////////////////////////////////////////////////////////////////////////
	//	RXgN^
	////////////////////////////////////////////////////////////////////////////////
	//!	RXgN^
	CUTF8String(void);

	//!	RXgN^(CUTF8String)
	CUTF8String(const CUTF8String &other);

	//!	RXgN^(LPCU8STR)
	CUTF8String(LPCU8STR other);

	//!	RXgN^(LPCWSTR)
	CUTF8String(LPCWSTR other);

	//!	fXgN^
	~CUTF8String(void);

	////////////////////////////////////////////////////////////////////////////////
	//	̑̑
	////////////////////////////////////////////////////////////////////////////////
	//!	ۂɂ
	void Empty();

	//!	ۂmF
	int IsEmpty() const { return(GetLength() == 0); };

	////////////////////////////////////////////////////////////////////////////////
	//	
	////////////////////////////////////////////////////////////////////////////////
	//!	̐ݒ
	void SetString(LPCU8STR toSet, int length = -1);

	//!	Rs[(UFT8)
	void Copy(LPCU8STR copyFrom, int u8Length = -1, int safetyCheck = TRUE);

	//!	Rs[(UFT16)
	void CopyUTF16(LPCWSTR copyFrom, int u16Length = -1);

	//!	Rs[(MBCS)
	void CopyMBCS(LPCSTR copyFrom, int mbLength = -1);


	//!	CUTF8StringRs[
	CUTF8String& operator=(const CUTF8String &other);

	//!	LPCU8STRRs[
	CUTF8String& operator=(LPCU8STR other);

	//!	LPCWSTRRs[
	CUTF8String& operator=(LPCWSTR other);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	擾
	int GetLength() const;

	//!	̎擾
	LPCU8STR GetString() const;

	//!	LPCSTR
	operator LPCU8STR() const;

	//!	[]
	utf8_char operator[](int index) const;

	//////////////////////////////////////////////////////////////////////////////////////////
	//	r
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	LPCU8STR
	int operator==(LPCU8STR other);

	//!	LPCWSTR
	int operator==(LPCWSTR other);


	//!	LPCU8STR
	int operator!=(LPCU8STR other) { return !(*this == other); }

	//!	LPCWSTR
	int operator!=(LPCWSTR other) { return !(*this == other); }


	//!	ʂɔr
	int Compare(LPCU8STR other);

	//!	ʂɔr
	int Compare(LPCWSTR other);

	//!	啶Ŕr
	int CompareNoCase(LPCU8STR other);

	//!	啶Ŕr
	int CompareNoCase(LPCWSTR other);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	ǉ
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	LPCU8STR
	void operator+=(LPCU8STR other);

	//!	LPCWSTR
	void operator+=(LPCWSTR other);

	//!	utf8_char
	void operator+=(const utf8_char other);

	//!	ǉ
	void Append(LPCU8STR other);

	//!	ǉ
	void Append(LPCSTR other);

	//!	ǉ
	void Append(LPCWSTR other);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	폜
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	폜
	CUTF8String &Delete(int index, int count = 1);

	//!	E폜
	CUTF8String &TrimRight();

	//!	폜
	CUTF8String &TrimLeft();

	//!	󔒂폜
	CUTF8String &Trim();

	//////////////////////////////////////////////////////////////////////////////////////////
	//	Left, Right, Mid
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	E폜
	CUTF8String Right(int count);

	//!	폜
	CUTF8String Left(int count);

	//!	wʒu擾
	CUTF8String Mid(int index, int count = -1);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	Eu
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	
	int Find(LPCU8STR find, int start = 0);

	//!	
	int Find(LPCWSTR find, int start = 0);

	//!	΂T
	int ReverseFind(utf8_char ch);

	//!	u
	int Replace(LPCU8STR oldTok, LPCU8STR newTok);

	//!	u
	int Replace(LPCWSTR oldTok, LPCWSTR newTok);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	ϊ
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	g֕ϊ
	CUTF8String &MakeLower();

	//!	g啶֕ϊ
	CUTF8String &MakeUpper();

	//////////////////////////////////////////////////////////////////////////////////////////
	//	Format
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	Format
	CUTF8String &Format(LPCU8STR format, ...);

	//!	Format
	CUTF8String &Format(LPCWSTR format, ...);

	//!	Format
	CUTF8String &FormatV(LPCU8STR format, va_list argptr);

	//!	Format
	CUTF8String &FormatV(LPCWSTR format, va_list argptr);

	//!	Format(ڎ擾)
	static CUTF8String GetFormat(LPCU8STR format, ...);

	//!	Format(ڎ擾)
	static CUTF8String GetFormat(LPCWSTR format, ...);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	}l[W
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	O[ov[Lɂ(ł\Aɂ͂łȂ)
	static void EnableMemoryPool();

	//!	݂̎gp񐔎擾(v[ȊO܂)
	static int GetGlobalStringCount();

	//!	݂̃v[TCY擾
	static int GetMemoryPoolSize();

protected:
	////////////////////////////////////////////////////////////////////////////////
	//	obt@
	////////////////////////////////////////////////////////////////////////////////
	//!	NX擾
	CUTF8StringData *GetStringClass() const;

	//!	
	void SetStringClass(CUTF8StringData *strClass);

	////////////////////////////////////////////////////////////////////////////////
	//	⏕
	////////////////////////////////////////////////////////////////////////////////
	//!	
	void InitInternal();

	//!	KvȂ
	void FreeString();

	//!	ݗp擾
	LPU8STR GetWritableString(int length);

	////////////////////////////////////////////////////////////////////////////////
	//	ϊ
	////////////////////////////////////////////////////////////////////////////////
	//!	UUTF16ɂčĐݒ
	void CopyWithUTF16(LPCSTR mbStr, int mbLength, int charSet);

	////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	////////////////////////////////////////////////////////////////////////////////
	//!	f[^
	LPU8STR m_u8string;
};


//////////////////////////////////////////////////////////////////////////////////////////
//	ZiO[oZqƂj
//////////////////////////////////////////////////////////////////////////////////////////
//!	CUTF8String
CUTF8String operator+(const CUTF8String &arg1, const CUTF8String &arg2);

//!	LPCU8STR
CUTF8String operator+(const CUTF8String arg1, const LPCU8STR arg2);

//!	LPCWSTR
CUTF8String operator+(const CUTF8String arg1, const LPCWSTR arg2);

//!	LPCU8STR
CUTF8String operator+(const LPCU8STR arg1, const CUTF8String arg2);

//!	LPCWSTR
CUTF8String operator+(const LPCWSTR arg1, const CUTF8String arg2);

