#pragma once
#include "types/UTF8Types.h"
#include "StackAlloc.h"


/*!
	e|obt@NX

	512ByteȉȂX^bNɊm
*/
class CUTF8StringTempBuf
{
public:
	/*!
		char* 擾
	*/
	char *AllocChar(int count)
	{
		return((char *)m_stack.Alloc(count));
	}

	/*!
		utf8_char* 擾
	*/
	utf8_char *AllocUTF8(int count)
	{
		return((utf8_char*)AllocChar(count * sizeof(utf8_char)));
	}

	/*!
		wchar_t* 擾
	*/
	wchar_t *AllocUTF16(int count)
	{
		//	2{ɂĊm
		return((wchar_t*)AllocChar(count * sizeof(wchar_t)));
	}

protected:
	//!	
	CStackAlloc<512>	m_stack;
};


/*!
	UTF8String ⏕NX
*/
class CUTF8StringTool
{
public:
	////////////////////////////////////////////////////////////////////////////////
	//	⏕
	////////////////////////////////////////////////////////////////////////////////
	//!	󕶎Ԃ
	static LPCU8STR GetEmptyString();

	//!	󕶎Ԃ
	static LPCSTR GetEmptyStringMB();

	//!	󕶎Ԃ
	static LPCWSTR GetEmptyStringU16();

	//! ASCII`FbN
	__inline static int IsASCII(int ch)
	{
		return(ch < 0x80 && ch != 0);
	}

	////////////////////////////////////////////////////////////////////////////////
	//	ϊ
	////////////////////////////////////////////////////////////////////////////////
	//!	UTF8S`FbN
	static int CheckIllegalUTF8(LPCU8STR utf8, int length);

	//!	SăAXL[R[h`FbN
	static int CheckAllAscii(LPCSTR mbStr, int mbLength); 

	//!	UTF8ł\`FbN
	static int CheckIsUTF8(LPCSTR mbStr, int mbLength); 

	//!	UTF8擾(CheckAllAscii`FbNȂ)
	static LPCU8STR MBCSToUTF8(LPCSTR mbStr, int mbLength, CUTF8StringTempBuf &tempBuf);

	//!	UTF8擾
	static LPCU8STR UTF16ToUTF8(LPCWSTR u16Str, int u16Length, CUTF8StringTempBuf &tempBuf);

	//!	MBCS擾
	static LPCSTR UTF8ToMBCS(LPCU8STR u8Str, int u8Length, CUTF8StringTempBuf &tempBuf);

	//!	UTF16擾
	static LPCWSTR UTF8ToUTF16(LPCU8STR u8Str, int u8Length, CUTF8StringTempBuf &tempBuf);

	////////////////////////////////////////////////////////////////////////////////
	//	ϊ⏕
	////////////////////////////////////////////////////////////////////////////////
	//!	UTF16擾
	static LPCWSTR AnyToUTF16(LPCSTR mbStr, int mbLength, CUTF8StringTempBuf &tempBuf, int charSet);

	//!	UTF8/MBCS擾
	static LPCSTR UTF16ToAny(LPCWSTR u16Str, int u16Length, CUTF8StringTempBuf &tempBuf, int charSet);

	////////////////////////////////////////////////////////////////////////////////
	//	fobO⏕
	////////////////////////////////////////////////////////////////////////////////
	//!	SăAXL[R[h`FbNA}`oCgꍇASSSERT
	static LPU8STR CheckDirectConvertUTF8(LPCSTR mbStr); 
};

