#pragma once
#include "ExpatXmlParser.h"
#include "WorkspaceNode.h"

class CWorkspaceXMLReader :
	protected CExpatXmlParser
{
public:
	CWorkspaceXMLReader(void);
	virtual ~CWorkspaceXMLReader(void);

	//!	XMLǂݍ(throw CXMLTextParserException)
	void LoadFromFile(CWorkspaceNode *root, CUTF8String path, CUTF8String workspaceClassType = _U8("CWorkspace"));

	//!	XMLǂݍ(throw CXMLTextParserException)
	void FromString(CWorkspaceNode *root, CUTF8String str, CUTF8String workspaceClassType = _U8("CWorkspace"));

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Jn^O
	virtual void OnStartTag(LPCU8STR tag, LPCU8STR *atts, int attsCount);

	//!	I^O
	virtual void OnEndTag(LPCU8STR tag);

	//!	f[^
	virtual void OnData(const utf8_char *data, int len);

	/////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	/////////////////////////////////////////////////////////////////////////////////////
	//!	̕ or r
	int MultiMatch(LPCU8STR tag, LPCSTR str1, LPCSTR str2 = NULL, LPCSTR str3 = NULL);

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	݂̃m[h
	CWorkspaceNode *m_curNode;

	//!	L[tO
	int				m_inKeyLeaf;

	//!	f[^R[obNē˓tO
	int				m_onDataCount;

	//!	݂̃L[
	CUTF8String		m_keyName;

	//!	݂̃f[^
	CUTF8String		m_keyData;

	//!	[JE^
	CPtrArrayTemplate<CWorkspaceNode*>	m_depth;

	//!	[NXy[X
	CUTF8String		m_workspaceClassType;
};
