#pragma once
#include "IServerToolWrap.h"
#include "Context.h"
#include "SyncObject.h"
#include "Settings.h"

/*!
	ReLXg擾pC^[tF[X
*/
class IConetextGene
{
public:
	//!	ReLXg̎擾
	virtual CContext GetNewContext(LONG connectionID) = 0;

	//!	ReLXg̔j
	virtual void ReleaseContext(CContext context) = 0;
};
//!	|C^^
typedef IConetextGene* IConetextGenePtr;


/*!
	ReLXgǗpC^[tF[X
*/
class IConetextManager
{
public:
	//!	ReLXg̃Rs[
	virtual void DuplicateContext(CWorkspace &copyTo, CUTF8String copyRootPath = _U8("")) = 0;
};
//!	|C^^
typedef IConetextManager* IConetextManagerPtr;


/*!
	ReLXg}l[W
*/
class CCnotextManager : protected IConetextGene, protected IConetextManager
{
public:
	CCnotextManager(void);
	virtual ~CCnotextManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

	//!	IConetextManager擾
	IConetextManagerPtr GetIConetextManager() { return this; };

	//!	IConetextGene擾
	IConetextGenePtr GetIConetextGene() { return this; };

protected:
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	IConetextManager
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ReLXg̃Rs[
	void DuplicateContext(CWorkspace &copyTo, CUTF8String copyRootPath);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	IConetextGene
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ReLXg̎擾
	virtual CContext GetNewContext(LONG connectionID);

	//!	ReLXg̔j
	virtual void ReleaseContext(CContext context);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	c[
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	t擾
	void GetDate(CContextDate date);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter		m_init;

	//!	ݒ
	CContextManagerSetting	m_setting;

	//!	OTCY
	CInterlockCounter		m_maxConetextLog;

	//!	IDJE^
	CInterlockCounter		m_contextID;

	//!	Ɨ̈
	CWorkspace				m_contextRoot;

	//!	Ɨ̈ANZXp
	CWorkspaceAccess		m_context;

	//!	Ɨ̈ANZXp
	CWorkspaceAccess		m_contextLog;
};
