#include "StdAfx.h"
#include "FileResponse.h"
#include "DateUtility.h"
#include "TextTools.h"
#include "Dir.h"
#include "MimeTypeManager.h"

//!	W[
static TCHAR _MODULE_NAME[] = _T("FileResponse");

CFileResponse::CFileResponse(void)
{
}

CFileResponse::~CFileResponse(void)
{
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CFileResponse::Start(CIConnectionToolWrap responseContext)
{
	m_bodyIsSended = 0;
	m_file = NULL;
}


/*!
	~(OցI)
*/
void CFileResponse::Stop(CIConnectionToolWrap responseContext)
{
	//	Ă
	SAFE_CLOSE_HANDLE(m_file);
}

/*!
	X|X擾
*/
LPCTSTR CFileResponse::GetResponseName()
{
	return _MODULE_NAME;
};


/*!
	X|X

	T[oX|X́Af[^M̕sǂ
*/
void CFileResponse::BuildResponse(CIConnectionToolWrap responseContext)
{
	//	NGXg擾
	CContextRequestInfo requestInfo = responseContext.GetContxet().GetRequestInfo();

	//	^[Qbg擾
	CContextTargetInfo targetInfo = responseContext.GetContxet().GetTargetInfo();

	//	GET? or HEAD?
	if(requestInfo.GetMethod() == "GET")
		m_bodyIsSended = FALSE;
	else if(requestInfo.GetMethod() == "HEAD")
		m_bodyIsSended = TRUE;
	else
		throw CServerResponseException(405, _T("Ή̃\bhł"));

	//	H
	if(!targetInfo.GetTargetIsExist())
		throw CServerResponseException(404, _T("w肳ꂽt@C݂͑܂"));

	//	t@CH
	if(targetInfo.GetTargetIsDirectory() || targetInfo.GetTarget().Right(1) == "\\")
		throw CConnectionErrorException(_T("fBNgt@CƂĕ\悤Ƃ܂"));

	//	J
	OpenFile(targetInfo.GetTarget());

	//	ETagEt`FbN
	if(CheckUpdate(responseContext.GetContxet(), targetInfo.GetTarget()))
		throw CServerResponseException(304, _T("^[Qbg͍XVĂ܂"));

	//	W[
	CheckRange(responseContext.GetContxet());
}


/*!
	X|Xwb_擾
*/
void CFileResponse::GetResponse(CIConnectionToolWrap responseContext)
{
	CContextResponseInfo responseInfo = responseContext.GetContxet().GetResponseInfo();

	//	X|XR[hݒ
	if(m_startAt == 0)
		responseInfo.SetResponseCode(200);
	else
		responseInfo.SetResponseCode(206);

	//	X|XTCY
	if(m_bodyIsSended)
	{
		//	X|XTCYNA
		responseInfo.GetResponseOption().SetContentLength(0);
	}
	else
	{
		//	X|XTCYݒ
		responseInfo.GetResponseOption().SetContentLength(m_fileSize - m_startAt);
	}

	//	MimeType
	responseInfo.GetResponseOption().SetContentType(responseContext.GetIServerTool().GetIMimeTypeManager().
				GetMimeTypeByName(CPathTools::PathToName(responseContext.GetContxet().GetTargetInfo().GetTarget())));
}

/*!
	X|X{fB擾
*/
int CFileResponse::GetResponseBody(CIConnectionToolWrap responseContext, CBinaryData &body, int blockSize)
{
	//	Head?
	if(m_bodyIsSended)
		return 0;

	//	obt@TCYC
	body.ReSize(blockSize);

	//	ǂł݂
	DWORD	readed = 0;
	if(!::ReadFile(m_file, body.GetPtr(), body.GetSize(), &readed, NULL))
	{
		m_file = NULL;
		throw CConnectionErrorException(_T("t@C̑Ɏs܂"));
	}
	body.ReSize(readed);

	//	I
	if(readed != blockSize)
	{
		SAFE_CLOSE_HANDLE(m_file);
		m_bodyIsSended = TRUE;
	}

	//	TCYԂ
	return(readed);
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	c[֐
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	t@CJ
*/
void CFileResponse::OpenFile(CString target)
{
	//	t@CJ
	m_file = ::CreateFile(target, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
	if(m_file == INVALID_HANDLE_VALUE)
		throw CConnectionErrorException(_T("t@C̑Ɏs܂"));

	//	t@C擾
	BY_HANDLE_FILE_INFORMATION	fInfo;
	if(!::GetFileInformationByHandle(m_file, &fInfo))
		throw CConnectionErrorException(_T("t@C̑Ɏs܂"));

	//	ݒ
	m_fileSize = ((__int64)fInfo.nFileSizeHigh << 32) + (__int64)fInfo.nFileSizeLow;
	m_lastUpdate = fInfo.ftLastWriteTime;
	m_startAt = 0;
}


/*!
	W[
*/
void CFileResponse::CheckRange(CContext context)
{
	//	NGXg擾
	CContextRequestOption requestOption = context.GetRequestInfo().GetRequestOption();

	//	X|X擾
	CContextResponseOption responseOption = context.GetResponseInfo().GetResponseOption();

	//	Rangewb_́H
	CString range = requestOption.GetRange();
	if(range != "")
	{
		//	T|[gĂ̂H(bytesH)
		//	Range: bytes=xxxx-
		if(range.Left(6).CompareNoCase("bytes=")==0)
		{
			//	Jnʒu؂o
			range = range.Mid(6);
			int index = range.Find("-");
			if(index != -1)
				range = range.Left(index);

			//	Jnʒu`FbN
			__int64	start = _atoi64(range);
			if(start < 0 || start >= m_fileSize)
				throw CServerResponseException(416, _T("ȊJnʒuwł"));

			//	JnʒuύX
			m_startAt = start;
			LARGE_INTEGER	liStart;
			liStart.QuadPart = start;
			if(!SetFilePointerEx(m_file, liStart, NULL, FILE_BEGIN))
				throw CConnectionErrorException(_T("t@C̑Ɏs܂"));

			//	wb_C
			responseOption.SetAcceptRanges("bytes");
			responseOption.SetContentRange(CTextTools::GetFormat("bytes %I64d-%I64d/%I64d", m_startAt, m_fileSize, m_fileSize));
		}
	}
}


/*!
	XVmF
*/
int CFileResponse::CheckUpdate(CContext context, CString target)
{
	//	NGXg擾
	CContextRequestOption requestOption = context.GetRequestInfo().GetRequestOption();

	//	X|X擾
	CContextResponseOption responseOption = context.GetResponseInfo().GetResponseOption();


	//	Last-Modifiedݒ
	responseOption.SetLastModified(CDateUtility::GetGMTString(m_lastUpdate));

	//	ETag
	CString	etag = GetETag(target);

	//	ETagݒ
	responseOption.SetETag(etag);

	//	r
	CTime ifModif = CDateUtility::StringToCTime(requestOption.GetIfModifiedSince());
	if(ifModif != 0 && m_lastUpdate <= ifModif)
		return(TRUE);

	//	ETagr
	if(requestOption.GetIfNoneMatch() == etag)
		return(TRUE);

	return(FALSE);
}

/*!
	ETag擾
*/
CString	CFileResponse::GetETag(CString target)
{
	//	^[QbgpX
	target = target.MakeUpper();

	//	t@C
	int	calc=0;
	for(int i=0;i<target.GetLength();i++)
		calc += (int)target[i];

	//	쐬
	CString str;
	str.Format("\"%I64x-%I64x:%04d\"",m_fileSize, m_lastUpdate.GetTime(), calc);

	return(str);
}
