#include "StdAfx.h"
#include "ServerStatusManager.h"
#include "Dir.h"
#include "TextTools.h"
#include "DateUtility.h"

#define	MAX_SYSTEM_LOG		200
#define	MAX_NOTIFY			200
#define	MAX_STATUS			200
#define	CLASS_NAME			"StatusManager"


CServerStatusManager::CServerStatusManager(void)
{
	m_serverStatus = m_statusRoot.GetAccess("ServerStatus");
}

CServerStatusManager::~CServerStatusManager(void)
{
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CServerStatusManager::Start(CIServerToolWrap serverTool)
{
	ASSERT(!m_init);
	m_init = TRUE;

	//	VXeO
	m_systemLog.Start(serverTool.GetIServerTool());
}

/*!
	~
*/
void CServerStatusManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;

	//	~
	m_systemLog.Stop();

	m_init = FALSE;
}

/*!
	Oo
*/
void CServerStatusManager::WriteSystemLog(CString callerName, int logType, CString logString)
{
	//	[NXy[XbN
	WORKSPACE_LOCK(m_serverStatus);

	//	Ŝ
	logString.Replace("\r", "_");
	logString.Replace("\n", "_");

	//	ŐVACe擾
	CServerSystemLog systemLog = m_serverStatus.GetSystemLog().GetNewItem();
	systemLog.SetCaller(callerName);
	systemLog.SetLogType(logType);
	systemLog.SetLogString(logString);
	systemLog.SetTime(CDateUtility::GetTimeString(CTime::GetCurrentTime()));

	//	ACemF
	if(m_serverStatus.GetSystemLog().GetItemCount() > MAX_SYSTEM_LOG)
		m_serverStatus.GetSystemLog().DeleteItem(0);

	TRACE("<%s> %s\n", callerName, logString);

	//	KvȂ烍Ot@C
	if(logType <= SYSTEM_LOG_INFO_LOG)
		m_systemLog.WriteSystemLog(callerName, logString);

	//	KvȂʒm
	if(logType <= SYSTEM_LOG_WARNING)
	{
		if(logType <= SYSTEM_LOG_ERROR)
			NotifyServerMessage("SystemLogErrorNotify", "G[܂: " + logString, SYSTEM_MESSAGE_ERROR);
		else
			NotifyServerMessage("SystemLogWarningNotify", "x܂: " + logString, SYSTEM_MESSAGE_WARNING, 60 * 60);	//	1ԂŎ
	}
};


/*!
	T[oXe[^X̕ύX
*/
void CServerStatusManager::SetServerStatus(CString statusName, CString status, CString statusInfo, CString statusType)
{
	//	[NXy[XbN
	WORKSPACE_LOCK(m_serverStatus);

	//	Xe[^XmF
	if(m_serverStatus.GetServerStatusCount() >= MAX_STATUS)
		return;	//	ȏǉs\

	//	Gg擾
	CServerStatusEntry entry = m_serverStatus.GetServerStatusEntry(statusName);

	//	Ggݒ
	entry.SetStatus(status);
	if(!statusInfo.IsEmpty())
		entry.SetStatusInfo(statusInfo);
	if(!statusType.IsEmpty())
		entry.SetStatusType(statusType);
}

/*!
	T[obZ[Wʒm
*/
void CServerStatusManager::NotifyServerMessage(CString messageID, CString message, int messageType, int autoOffTimeSec)
{
	//	[NXy[XbN
	WORKSPACE_LOCK(m_serverStatus);

	//	Xe[^XmF
	if(m_serverStatus.GetServerNotifyCount() >= MAX_NOTIFY)
		return;	//	ȏǉs\

	//	Gg擾
	CServerNotifyEntry entry = m_serverStatus.GetServerNotifyEntry(messageID);

	//	Ggݒ
	entry.SetMessageID(messageID);
	entry.SetMessage(message);
	entry.SetMessageType(messageType);
	entry.SetAutoOffTimeSec(autoOffTimeSec);
	entry.SetTime(CDateUtility::GetTimeString(CTime::GetCurrentTime()));
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	擾
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Xe[^X擾
*/
void CServerStatusManager::DuplicateStatus(CWorkspace &status)
{
	status.Duplicate(m_statusRoot);
}
