#include "StdAfx.h"
#include ".\workspaceaccess.h"

CWorkspaceAccess::CWorkspaceAccess(void)
{
	m_path = "";
	m_root = NULL;
}

CWorkspaceAccess::CWorkspaceAccess(IWorkspaceAccessPtr access)
{
	CIStringWrap	path;
	access->GetAccessPath(&path);
	
	Init(access->GetIWorkspacePtr(), path);
}

CWorkspaceAccess::CWorkspaceAccess(IWorkspacePtr root, CString path)
{
	Init(root, path);
}


CWorkspaceAccess::~CWorkspaceAccess(void)
{
}

/////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CWorkspaceAccess::Init(IWorkspacePtr root, CString path)
{
	//	m[hpX֕ϊ
	if(path.GetLength() >= 2)
	{
		if(path.Right(2) != "::")
			path += "::";
	}
	else
		path += "::";

	m_path = path;
	m_root = root;
}


/*********************************************************
	Ȃ
**********************************************************/
//!	Sf[^NA
void CWorkspaceAccess::Clear(void)
{
	ASSERT(m_root != NULL);

	m_root->Clear(m_path);
}


/*!
	
*/
void CWorkspaceAccess::Copy(CWorkspaceAccess &src)
{
	ASSERT(m_root != NULL);

	m_root->Copy(m_path, src.m_path, src.m_root);
}


/*!
	ANZXNX擾
*/
CWorkspaceAccess CWorkspaceAccess::GetAccess(CString subPath)
{
	ASSERT(m_root != NULL);

	return CWorkspaceAccess(m_root,m_path + subPath);
}


/*!
	[g擾
*/
IWorkspacePtr CWorkspaceAccess::GetRoot()
{
	return(m_root);
}

/*!
	O擾
*/
CString CWorkspaceAccess::GetNodeName()
{
	//	̂Q
	CString	path = m_path;
	if(path.Right(2) == "::")
		path = path.Left(path.GetLength() - 2);

	int index = path.ReverseFind(_T(':'));
	if(index == -1)
		return(path);
	return(path.Mid(index + 1));
}

/*!
	pX擾
*/
CString CWorkspaceAccess::GetPath()
{
	return(m_path);
}



/*********************************************************
	f[^擾ݒ菈
**********************************************************/
/*!
	f[^̐ݒ()
*/
void CWorkspaceAccess::SetKeyStr(CString key, CString data,int noCase)
{
	ASSERT(m_root != NULL);

	m_root->SetKeyData(m_path + key,data);
}


/*!
	f[^̐ݒ(int)
*/
void CWorkspaceAccess::SetKeyInt(CString key, int data,int noCase)
{
	ASSERT(m_root != NULL);

	TCHAR	buf[80] = _T("");
	_itot_s(data, buf, 80, 10);
	m_root->SetKeyData(m_path + key, buf);
}


/*!
	f[^̐ݒ(int64)
*/
void CWorkspaceAccess::SetKeyInt64(CString key, __int64 data,int noCase)
{
	ASSERT(m_root != NULL);

	TCHAR	buf[80] = _T("");
	_i64tot_s(data, buf, 80, 10);
	m_root->SetKeyData(m_path + key, buf);
}


/*!
	f[^̐ݒ(DWORD)
*/
void CWorkspaceAccess::SetKeyDWORD(CString key, DWORD data,int noCase)
{
	ASSERT(m_root != NULL);

	TCHAR	buf[80] = _T("");
	_ui64tot_s(data, buf, 80, 10);
	m_root->SetKeyData(m_path + key, buf);
}



/*!
	f[^̎擾()
*/
CString CWorkspaceAccess::GetKeyStr(CString key, CString defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	CIStringWrap	ret;
	m_root->GetKeyData(&ret, m_path + key, defaultData, noCase);

	return(ret.GetString());
}


/*!
	f[^̎擾(int)
*/
int CWorkspaceAccess::GetKeyInt(CString key, int defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	CIStringWrap	ret;
	m_root->GetKeyData(&ret, m_path + key, _T(""), noCase);

	if(ret.IsEmpty())
		return(defaultData);
	else
		return(_ttoi(ret.GetString()));
}


/*!
	f[^̎擾(int64)
*/
__int64 CWorkspaceAccess::GetKeyInt64(CString key, __int64 defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	CIStringWrap	ret;
	m_root->GetKeyData(&ret, m_path + key, _T(""), noCase);

	if(ret.IsEmpty())
		return(defaultData);
	else
		return(_ttoi64(ret.GetString()));
}


/*!
	f[^̎擾(DWORD)
*/
DWORD CWorkspaceAccess::GetKeyDWORD(CString key, DWORD defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	CIStringWrap	ret;
	m_root->GetKeyData(&ret, m_path + key, _T(""), noCase);

	if(ret.IsEmpty())
		return(defaultData);
	else
		return((DWORD)_ttoi64(ret.GetString()));
}

/*********************************************************
	KeyɊւ鏈
**********************************************************/
/*!
	L[擾
*/
int CWorkspaceAccess::GetKeyCount()
{
	ASSERT(m_root != NULL);

	return(m_root->GetKeyCount(m_path));
}


/*!
	SẴL[𕶎ƂĎ擾
*/
int CWorkspaceAccess::GetAllKey(CStringArray &list)
{
	ASSERT(m_root != NULL);

	CIStringArrayWrap	iList(list);
	return(m_root->GetAllKeyPair(m_path, &iList, NULL));
}

/*!
	SẴf[^𕶎ƂĎ擾
*/
int CWorkspaceAccess::GetAllData(CStringArray &list)
{
	ASSERT(m_root != NULL);

	CIStringArrayWrap	iList(list);
	return(m_root->GetAllKeyPair(m_path, NULL, &iList));
}



/*!
	f[^̍폜
*/
void CWorkspaceAccess::DeleteKey(CString key)
{
	ASSERT(m_root != NULL);

	m_root->DeleteKey(m_path + key);
}


/******************************************************
	Tum[hɊւ鏈
*******************************************************/
/*!
	m[h폜
*/
void CWorkspaceAccess::DeleteNode(CString name)
{
	ASSERT(m_root != NULL);

	m_root->DeleteNode(m_path + name);
}


/*!
	Tum[h𓾂
*/
int CWorkspaceAccess::GetSubNodeCount()
{
	ASSERT(m_root != NULL);

	return(m_root->GetSubNodeCount(m_path));
}


/*!
	SẴTum[h𕶎ƂĎ擾
*/
int CWorkspaceAccess::GetAllSubNode(CStringArray &list)
{
	ASSERT(m_root != NULL);

	CIStringArrayWrap	iList(list);
	return(m_root->GetAllSubNode(m_path, &iList));
}


