#pragma once

//!	UTF8^
typedef unsigned char utf8_char;


/*!
	04WebServerpNX

	UTF8Ƃ
*/
class CSvrStringBase
{
public:
	//////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	LPCSTR
	operator LPCSTR() const
	{
		return GetConstString();
	}

	//!	LPSTR
	operator LPSTR()
	{
		return GetString();
	}

	//////////////////////////////////////////////////////////////////////////////////////////
	//	Rs[
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	CWorkspaceString
	void operator=(const CSvrStringBase &other)
	{
		Copy(other.GetConstString(), other.GetLength());
	}

	//!	LPCSTR
	void operator=(LPCSTR other)
	{
		Copy(other, strlen(other));
	}


	//////////////////////////////////////////////////////////////////////////////////////////
	//	r
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	CWorkspaceString
	int operator==(const CSvrStringBase &other)
	{
		if(_strcmp((char*)GetString(), (char*)((LPCSTR)other)) == 0)
			return(TRUE);
		return(FALSE);
	}

	//!	CString
	int operator==(const CString &_other)
	{
		CString &other = const_cast<CString&>(_other);
		if(_mbscmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)) == 0)
			return(TRUE);
		return(FALSE);
	}

	//!	LPCSTR
	int operator==(LPCSTR other)
	{
		if(_mbscmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)) == 0)
			return(TRUE);
		return(FALSE);
	}

	//!	LPCSTR
	int operator==(LPSTR other)
	{
		if(_mbscmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)) == 0)
			return(TRUE);
		return(FALSE);
	}

	//!	ʂɔr
	int Compare(LPCSTR &other)
	{
		return(_mbscmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)));
	}

	//!	r
	int CompareNoCase(LPCSTR &other)
	{
		return(_mbsicmp((unsigned char*)GetString(), (unsigned char*)((LPCSTR)other)));
	}



protected:
	///////////////////////////////////////////////////////////////////////////////
	//	p
	///////////////////////////////////////////////////////////////////////////////
	//!	constO
	LPCSTR GetConstString() const
	{
		return const_cast<CSvrStringBase *>(this)->GetString();
	}

	///////////////////////////////////////////////////////////////////////////////
	//	I[o[Chp
	///////////////////////////////////////////////////////////////////////////////
	//!	|C^擾
	virtual utf8_char *GetString() = 0;

	//!	̒擾
	virtual int GetLength() const = 0;

	//!	̒ύX
	virtual void SetLength() = 0;
};
