#pragma once
#include "ServerToolWrap.h"
#include "Settings.h"
#include "SyncObject.h"
#include "ICGIManager.h"
#include "SimpleManagerInterfaceImplement.h"

/*!
	CGIǗNX
*/
class CCGIManager : protected ICGIManager
{
public:
	CCGIManager(void);
	virtual ~CCGIManager(void);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	EI
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	ICGIManager
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	vCGIR}h邩擾
	virtual int TargetIsCGI(LPCSTR targetPath);

	//!	vCGIR}h擾
	virtual int GetCGICommand(LPCSTR targetPath, IWorkspaceAccessPtr command)
	{
		return _GetCGICommand(targetPath, CWorkspaceAccess(command));
	}

	//!	CGIʐݒ擾
	virtual void GetCGIManagerSetting(IWorkspaceAccessRefPtr setting)
	{
		m_setting.FillIWorkspaceAccessRef(setting);
	}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	vCGIR}h擾
	virtual int _GetCGICommand(CString targetPath, CCGICommand command);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	c[
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	v邩擾
	int IsMatch(CString targetPath, CCGICommand command);

	//!	st@Co
	int DetectWindowsExecutable(CString targetPath);

	//!	wb_`FbN
	int CheckHeader(CString targetPath, CString headerFilter);

	//!	ŏ̈s[h
	CString GetFirstLine(CString targetPath);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter					m_init;

	//!	T[oc[
	CIServerToolWrap					m_serverTool;

	//!	C^tF[X
	CSimpleManagerInterfaceImplement	m_managerInterface;

	//!	CGIݒ
	CCGIManagerSetting					m_setting;

	//!	R}hXg
	CCGICommandList						m_cgiCommandList;
};
