/*!
	COverlappedSocket o͂ɎgBIO

	QlFbss_file.c, bss_sock.c
*/
#include "StdAfx.h"
#include "openssl/bio.h"
#include "openssl/err.h"
#include "OverlappedSocket.h"

#define BIO_TYPE_OVR_SOCKET		(30 | 0x400)	//	BIO_TYPE_SOURCE_SINK

#ifndef MS_CALLBACK
	#define MS_CALLBACK
#endif

static int MS_CALLBACK	ovrs_write(BIO *h, const char *buf, int num);
static int MS_CALLBACK	ovrs_read(BIO *h, char *buf, int size);
static int MS_CALLBACK	ovrs_puts(BIO *h, const char *str);
static long MS_CALLBACK	ovrs_ctrl(BIO *h, int cmd, long arg1, void *arg2);
static int MS_CALLBACK	ovrs_new(BIO *h);
static int MS_CALLBACK	ovrs_free(BIO *data);

static BIO_METHOD methods_ovrs =
{
	BIO_TYPE_OVR_SOCKET,
	"COverlappedSocket",
	ovrs_write,
	ovrs_read,
	ovrs_puts,
	NULL, // ovr_gets,
	ovrs_ctrl,
	ovrs_new,
	ovrs_free,
	NULL,
};

/*!
	C^tF[X擾
*/
BIO_METHOD *BIO_s_ovrs(void)
{
	return(&methods_ovrs);
}

/*!
	蓖
*/
BIO *BIO_new_ovrs(COverlappedSocket *ovrs)
{
	if(ovrs == NULL)
		return(NULL);

	//	VK
	BIO *ret = BIO_new(BIO_s_ovrs());
	if(ret == NULL)
		return(NULL);

	//	ݒ
	ret->ptr = ovrs;
	ret->init = 1;
	return(ret);
}

/*!
	
*/
static int ovrs_new(BIO *bi)
{
	bi->init=0;
	bi->num=0;
	bi->ptr=NULL;
	bi->flags=0;
	return(1);
}

/*!
	J
*/
static int ovrs_free(BIO *a)
{
	if (a == NULL)
		return(0);
	a->ptr=NULL;
	a->init=0;
	return(1);
}

/*!	
	ǂݍ
*/
static int ovrs_read(BIO *b, char *out, int outl)
{
	if(out != NULL)
	{
		//	|C^擾
		COverlappedSocket *ovrs = (COverlappedSocket*)b->ptr;

		//	s
		return(ovrs->BlockingRecv(out, outl));
	}
	return(0);
}

/*!
	
*/
static int ovrs_write(BIO *b, const char *in, int inl)
{
	//	|C^擾
	COverlappedSocket *ovrs = (COverlappedSocket*)b->ptr;

	//	s
	return(ovrs->BlockingSend(const_cast<char *>(in), inl));
}

/*!
	()
*/
static int ovrs_puts(BIO *bp, const char *str)
{
	return(ovrs_write(bp,str, strlen(str)));
}


/*!
	Rg[
*/
static long ovrs_ctrl(BIO *b, int cmd, long num, void *ptr)
{
	long ret=1;

	switch (cmd)
	{
	case BIO_CTRL_RESET:
		num=0;
	case BIO_C_FILE_SEEK:
		ret=0;
		break;

	case BIO_CTRL_DUP:
	case BIO_CTRL_FLUSH:
		ret=1;
		break;

	default:
		ret=0;
		break;
	}
	return(ret);
}
