#include "StdAfx.h"
#include "OverloadManager.h"

#define	CLASS_NAME	_U8("OverloadManager")

COverloadManager::COverloadManager(void)
{
}

COverloadManager::~COverloadManager(void)
{
}

/*!
	
*/
void COverloadManager::Start(CIServerToolWrap serverTool, int maxConnect, int overloadModeKeepTime)
{
	m_serverTool = serverTool;
	m_maxConnect = maxConnect;
	m_overloadModeKeepTime = overloadModeKeepTime;
	m_overload = 0;

	//	Gg𐶐Ă
	m_serverTool.SetServerStatusInt(_U8("ConnectionCount"),			0, _U16("݂̐ڑ"));
	m_serverTool.SetServerStatusInt(_U8("ThreadCount"),				0, _U16("݂̃Xbh"));
	m_serverTool.SetServerStatusInt(_U8("QueueingConnectionCount"),	0, _U16("݂̏҂ڑ"));
	m_serverTool.SetServerStatusInt(_U8("OverloadMode"),			0, _U16("I[o[[h"));
}


/*!
	T[oׂݒ
*/
void COverloadManager::UpdateServerload(int threadCount, int queueCount)
{
	CRITICAL_SECTION_SCOPE();

	//	݂̐ڑ
	int curConnectionCount = threadCount + queueCount;

	//	I[o[[hH
	if(curConnectionCount >= m_maxConnect)
	{
		//	I[o[[h
		if(!m_overload)
		{
			m_serverTool.WriteSystemLog(CLASS_NAME, SYSTEM_LOG_WARNING, _U16("I[o[[h[hֈڍs܂"));
			m_serverTool.NotifyServerMessage(_U8("OverloadMode"), _U16("I[o[[h[hŎsł"), SYSTEM_MESSAGE_WARNING);
		}

		m_overloadModeStartTime = GetTickCount();
		m_overload = TRUE;
	}
	else
	{
		//	I[o[[hH
		if(m_overload && IsOver(m_overloadModeStartTime, GetTickCount(), m_overloadModeKeepTime))
		{
			m_serverTool.NotifyServerMessage(_U8("OverloadMode"), _U16("I[o[[h[h畜A܂"), SYSTEM_MESSAGE_INFO, 3600);
			m_overload = FALSE;
		}
	}

	//	XV
	m_serverTool.SetServerStatusInt(_U8("ConnectionCount"),			curConnectionCount);
	m_serverTool.SetServerStatusInt(_U8("ThreadCount"),				threadCount);
	m_serverTool.SetServerStatusInt(_U8("QueueingConnectionCount"),	queueCount);
	m_serverTool.SetServerStatusInt(_U8("OverloadMode"),				m_overload);
}

/*!
	w莞ԉ߂H
*/
int COverloadManager::IsOver(DWORD old, DWORD cur, DWORD span)
{
	//	48߂H
	if(old > cur)
		return(TRUE);

	//	o
	if(old + span < cur)
		return(TRUE);

	return(FALSE);
}

