/*!
	IStringHelper.h

	IString/IStringArray C^tF[XEbpNX̒`
*/
#pragma once
#include "types/StringTypes.h"
#include "UTF8String.h"
#include "UTF8StringArray.h"


////////////////////////////////////////////////////////////////////////////////////////////////////////
//	C^tF[XEbp
////////////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	񃉃bpNX
*/
class CIStringWrap : public IString
{
public:
	/////////////////////////////////////////////////////////////////
	//	RXgN^
	/////////////////////////////////////////////////////////////////
	/*!
		RXgN^
	*/
	CIStringWrap() : m_str(m_buffer)
	{
	}

	/*!
		RXgN^
	*/
	CIStringWrap(CUTF8String &str) : m_str(str)
	{
	}

	/*!
		RXgN^
	*/
	CIStringWrap(LPCU8STR str) : m_str(m_buffer)
	{
		m_buffer = str;
	}

	/////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////
	/*!
		ݒ
	*/
	virtual void SetString(LPCU8STR str, int length)
	{
		m_str.SetString(str, length);
	}

	/*!
		擾
	*/
	virtual LPCU8STR GetString() const
	{
		return m_str.GetString();
	}

	/*!
		擾
	*/
	virtual int GetLength() const
	{
		return m_str.GetLength();
	}

	/*!
		H
	*/
	int IsEmpty()
	{
		return m_str.IsEmpty();
	}

	/*!
		擾
	*/
	operator CUTF8String()
	{
		return m_str;
	}

	/*!
		ݒ
	*/
	void Attach(CUTF8String &str)
	{
		m_str = str;
	}

protected:
	/////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////
	//!	Q
	CUTF8String	&m_str;

	//!	obt@
	CUTF8String	m_buffer;
};


/*!
	z񃉃bpNX
*/
class CIStringArrayWrap : public IStringArray
{
public:
	CIStringArrayWrap(CUTF8StringArray &arr) :
	  m_array(arr)
	{
	};

	//!	
	virtual void Clear()
	{
		m_array.RemoveAll();
	};

	//!	TCYݒ
	virtual void SetSize(int size)
	{
		m_array.SetSize(size);
	};

	//!	TCY擾
	virtual int GetSize()
	{
		return m_array.GetCount();
	};

	//!	ێĂ镶擾
	virtual void AddString(LPCU8STR str)
	{
		m_array.Add(CUTF8String(str));
	};

	//!	ێĂ镶擾
	virtual LPCU8STR GetString(int index)
	{
		return m_array[index];
	};

	//!	ێĂ镶擾
	virtual void SetString(int index, LPCU8STR str)
	{
		m_array[index] = str;
	};

	/////////////////////////////////////////////////////////////////////
	//	⏕
	/////////////////////////////////////////////////////////////////////
	//!	CUTF8StringArray擾
	CUTF8StringArray &GetStringArray() { return m_array; };

protected:
	//!	ێ̔z
	CUTF8StringArray	&m_array;
};
