/*!
	T[oc[C^tF[X
*/

#pragma once
#include "InterfaceWrapperMacro.h"
#include "IManagerInterface.h"
#include "Workspace.h"

#define	MANAGER_SETTING		_T("ManagerSetting")
#define	FILTER_SETTING		_T("FilterSetting")
#define	RESPONSE_SETTING	_T("ResponseSetting")
#define	SERVER_STATUS		_T("ServerStatus")
#define	SERVER_INFO			_T("ServerInfo")

//!	C^[tF[X錾
class IPathManager;
class IMimeTypeManager;
class ILogManager;
class IServerTextManager;
class ICGIManager;

typedef IServerTextManager* IServerTextManagerPtr;
typedef ILogManager*		ILogManagerPtr;
typedef IMimeTypeManager*	IMimeTypeManagerPtr;
typedef ICGIManager*		ICGIManagerPtr;

//!	T[oXe[^XR[h
enum
{
	SERVER_STATUS_NORMAL		= 10,
	SERVER_STATUS_NORMAL_LOG	= 0,
	SERVER_STATUS_WARNING		= -10,
	SERVER_STATUS_ERROR			= -20,
	SERVER_STATUS_FATAL_ERROR	= -30,
};


/*!
	T[opc[
*/
class IServerTool
{
public:
	//!	fXgN^
	virtual ~IServerTool() {};

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	Xe[^XEO
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oȌ
	virtual void WriteSystemLog(LPCSTR callerName, int statusCode, LPCSTR statusInfo, int autoOffTime = -1) = 0;

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusInt(LPCSTR statusName, int status, LPCSTR statusInfo = "") = 0;

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusStr(LPCSTR statusName, LPCSTR status, LPCSTR statusInfo = "") = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	[NXy[Xւ̃ANZX擾
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	[NXy[Xւ̃ANZX擾
	virtual int GetServerWorkspaceAccess(IWorkspaceAccessRefPtr accessRef, LPCSTR type, LPCSTR section) = 0;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[XǗ
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[Xo^
	virtual int RegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface = NULL) = 0;

	//!	C^[tF[Xo^
	virtual int UnRegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface = NULL) = 0;

	//!	C^tF[X擾
	virtual void *GetManagerInterface(LPCSTR interfaceName, int ifVersion) = 0;
};
//!	|C^^
typedef IServerTool* IServerToolPtr;



/*!
	T[op
*/
class IServerControl
{
public:
	//!	fXgN^
	virtual ~IServerControl() {};

	//!	T[o̊Jn
	virtual void StartServer() = 0;

	//!	T[o̒~
	virtual void StopServer() = 0;
};
//!	|C^^
typedef IServerControl* IServerControlPtr;
