#pragma once
#include "ServerToolWrap.h"
#include "IMimeTypeManager.h"
#include "Settings.h"
#include "SyncObject.h"
#include "SortArray.h"

class CMimeTypeManager : public IManagerInterface, protected IMimeTypeManager
{
public:
	CMimeTypeManager(void);
	virtual ~CMimeTypeManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();


protected:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	IManagerInterface
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual void *GetInterface(int ifVersion)
	{
		if(ifVersion != CIMimeTypeManagerWrap::GetInterfaceVersion())
			return(NULL);
		return(GetIMimeTypeManager());
	};

	//!	I[o[[hʒm
	virtual void NotifyOverload() {};


	///////////////////////////////////////////////////////////////////////////////////////////
	//	IMimeTypeManager
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	t@CMimeType擾
	virtual void GetMimeTypeByName(IStringPtr mimeType, LPCSTR lpName)
	{
		mimeType->SetString(GetMimeTypeByName(lpName));
	}

	//!	t@CACRpX擾
	virtual void GetIconPathByName(IStringPtr iconPath, LPCSTR lpName)
	{
		iconPath->SetString(GetIconPathByName(lpName));
	}

	///////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	IMimeTypeManager擾
	virtual IMimeTypeManagerPtr GetIMimeTypeManager() { return this; };

	//!	t@CMimeType擾
	CString GetMimeTypeByName(CString name);

	//!	t@CACRpX擾
	CString GetIconPathByName(CString name);

	///////////////////////////////////////////////////////////////////////////////////////////
	//	c[֐
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	MimeType[h
	void LoadMimeType();

	//!	Icon[h
	void LoadIcon();

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection					m_scopeLock;

	//!	tO
	CInterlockCounter					m_init;

	//!	IServerTool
	CIServerToolWrap							m_serverTool;

	//!	Mime^Cvݒ
	CMimeTypeManagerSetting				m_mimeTypeSetting;


	//!	MmeTypeƃf[^
	CMapStringToString					m_mimeTypeMap;

	//!	Iconƃf[^
	CKeyDataArray						m_iconArray;
};

