#include "StdAfx.h"
#include "ResponseManager.h"
#include "IResponse.h"
#include "FileResponse.h"
#include "DirectoryIndexResponse.h"

CResponseManager::CResponseManager(void)
{
}

CResponseManager::~CResponseManager(void)
{
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	EI
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CResponseManager::Start(CIServerToolWrap serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	m_serverTool = serverTool;

	//	fBNgX|X
	m_responseFactorys.Add(CIResponseFactoryWrapper::CreateWrapper(new CDirectoryIndexResponseFactory));

	//	t@CX|X
	m_responseFactorys.Add(CIResponseFactoryWrapper::CreateWrapper(new CFileResponseFactory));

	//	
	for(int i=0;i<m_responseFactorys.GetSize();i++)
		m_responseFactorys[i]->ResponseFactoryStart(m_serverTool.GetIServerTool());

	//	C^[tF[Xo^
	m_serverTool.RegisterManagerInterface(RESPONSE_MANAGER_INTERFACE_NAME, this);
}

/*!
	~
*/
void CResponseManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	~
	for(int i=0;i<m_responseFactorys.GetSize();i++)
		m_responseFactorys[i]->ResponseFactoryStop();

	m_responseFactorys.RemoveAll();

	//	C^[tF[Xo^
	m_serverTool.UnRegisterManagerInterface(RESPONSE_MANAGER_INTERFACE_NAME, this);
}


/*!
	X|X
*/
IResponsePtr CResponseManager::GetResponse(CContext context)
{
	SCOPE_LOCK();

	//	
	for(int i=0;i<m_responseFactorys.GetSize();i++)
	{
		if(m_responseFactorys[i]->ResponseFactoryIsYourRequest(context.GetIWorkspaceAccess()))
			return m_responseFactorys[i]->ResponseFactoryGetResponse();
	}

	return NULL;	//	NULLԂ
}

