#include "StdAfx.h"
#include "SSLListener.h"
#include "ServerStartErrorException.h"
#include "TextTools.h"
#include "SSLClientConnection.h"

#define	CLASS_NAME	"SSLListener"


CSSLListener::CSSLListener(void)
{
	m_init = 0;
}

CSSLListener::~CSSLListener(void)
{
	Stop();
}


/*!
	Jn
*/
void CSSLListener::Start(IServerToolPtr serverTool, IClientConnectionQueuePtr queue)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	Rs[
	m_serverTool = serverTool;
	m_queue = queue;
	m_setting = m_serverTool.GetManagerSetting(m_setting.GetSettingName());


	//	ݒ擾
	m_timeoutTime = m_setting.GetConnectionTimeoutTime();

	//	SSL
	m_sslContext.Start(m_serverTool.GetIServerTool());

	//	Xi
	InitListenerBase(m_serverTool.GetIServerTool(), m_setting.GetListenErrorRetryTime());

	//	|[gǉ
	AddPortsFromSetting(m_setting.GetPort());

	//	|[gmF
	if(GetPortCount() == 0)
		throw CServerStartErrorException(CLASS_NAME, "҂󂯃|[gЂƂw肳Ă܂");

	//	XbhN
	StartListenerBase();
}

/*!
	~
*/
void CSSLListener::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	Xi~
	StopListenerBase();

	//	SSL~
	m_sslContext.Stop();
}

/*!
	~
*/
void CSSLListener::ShutdownListen()
{
	//	`FbN
	if(!m_init)
		return;

	//	Xi~
	StopListenerBase();
}

/////////////////////////////////////////////////////////////////////////////////////
//	I[o[[h
/////////////////////////////////////////////////////////////////////////////////////
/*!
	NX擾
*/
LPCTSTR CSSLListener::GetListenerClassName()
{
	return CLASS_NAME;
}

/*!
	ڑǉ
*/
void CSSLListener::OnNewConnection(SOCKET newSock)
{
	try
	{
		m_queue->AddNewConnection(new CSSLClientConnection(newSock, m_sslContext.GetCTX(), m_timeoutTime));
	}
	catch(CMemoryException *e)
	{
		e->Delete();

		m_serverTool.WriteSystemLog(GetListenerClassName(), SERVER_STATUS_ERROR, "s܂AꎞIɐڑۂ܂");

		//	ŝ߁AT[oꎞ~
		ForceDisableNewConnection(30 * 1000);
	}
}
