#include "StdAfx.h"
#include "Server.h"
#include "Dir.h"
#include "ServerStartErrorException.h"

#define	CLASS_NAME	"Server"

CServer::CServer(void)
{
}

CServer::~CServer(void)
{
	StopServer();
}



/////////////////////////////////////////////////////////////////////////////////////////////////
//	IServerControl
/////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	T[o̊Jn
*/
void CServer::StartServer()
{
	//	sH
	if(m_serverRunning)
		return;
	m_serverRunning = TRUE;

	//	G[
	try
	{
		//	ԍXV
		WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL_LOG,	"T[o̎sJn܂");

		/*
			Ǘ@\
		*/
		//	C^tF[X}l[W
		m_interfaceManager.Start(GetIServerTool());

		//	ݒ}l[W
		m_settingManager.Start(GetIServerTool());

		//	}l[W
		m_serverInfoManager.Start(GetIServerTool());

		//	Xe[^X}l[W
		m_statusManager.Start(GetIServerTool());


		/*
			⏕@\
		*/
		//	ANZXO}l[WN
		m_logManager.Start(GetIServerTool());

		//	pX}l[W
		m_pathManager.Start(GetIServerTool());

		//	T[oeLXg}l[WN
		m_serverTextManager.Start(GetIServerTool());

		//	MimeType}l[W
		m_mineTypeManager.Start(GetIServerTool());

		//	CGI}l[W
		m_cgiManager.Start(GetIServerTool());


		/*
			W[
		*/
		//	tB^}l[W
		m_filterManager.Start(GetIServerTool());

		//	X|X}l[WN
		m_responseManager.Start(GetIServerTool());


		/*
			ʐM@\
		*/
		//	ڑ}l[WJn
		m_connectionManager.Start(GetIServerTool());

		//	Xi
		m_listenerManager.Start(GetIServerTool(), m_connectionManager.GetIClientConnectionQueue());


		//	ԍXV
		WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL_LOG,	"T[ȍ܂");
		WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL,		"T[o͎sł");
		SetServerStatusInt("ServerRunning", 1, "T[os");
	}
	catch(CServerStartErrorException err)
	{
		//	G[Zbg
		WriteSystemLog(err.m_caller, SERVER_STATUS_FATAL_ERROR, err.m_errorInfo);

		//	~
		StopServer();
	}
}

/*!
	T[o̒~
*/
void CServer::StopServer()
{
	//	sH
	if(!m_serverRunning)
		return;
	m_serverRunning = FALSE;

	//	ԍXV
	WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL_LOG, "T[o̒~Jn܂");

	/*
		ʐM@\~
	*/
	//	ʐM~
	m_listenerManager.ShutdownListen();

	//	ڑ}l[W~
	m_connectionManager.Stop();

	//	Xi~
	m_listenerManager.Stop();


	/*
		W[~
	*/
	//	X|X}l[W~
	m_responseManager.Stop();

	//	tB^}l[W~
	m_filterManager.Stop();


	/*
		⏕@\~
	*/
	//	CGI}l[W~
	m_cgiManager.Stop();

	//	MimeType}l[W~
	m_mineTypeManager.Stop();

	//	T[oeLXg}l[W~
	m_serverTextManager.Stop();

	//	pX}l[W~
	m_pathManager.Stop();

	//	ANZXO}l[W~
	m_logManager.Stop();


	/*
		Ǘ@\~
	*/
	//	}l[W~
	m_serverInfoManager.Stop();

	//	ݒ}l[W~
	m_settingManager.Stop();

	//	Xe[^X}l[W~
	m_statusManager.Stop();

	//	C^tF[X}l[W~
	m_interfaceManager.Stop();

	//	ԍXV
	WriteSystemLog(CLASS_NAME, SERVER_STATUS_NORMAL_LOG, "T[o̎s~܂");
	SetServerStatusInt("ServerRunning", 0);
}

/////////////////////////////////////////////////////////////////////////////////////////////////
//	IServerTool
/////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	[NXy[Xւ̃ANZX擾
*/
int CServer::GetServerWorkspaceAccess(IWorkspaceAccessRefPtr accessRef, LPCSTR type, LPCSTR section)
{
	CString	csType(type);

	//	ۂ
	accessRef->SetWorkspaceAccess(NULL, "");

	//	^Cv
	if(csType == MANAGER_SETTING)
	{
		m_settingManager.GetManagerSetting(section).FillIWorkspaceAccessRef(accessRef);
		return(0);
	}
	else if(csType == FILTER_SETTING)
	{
		m_settingManager.GetFilterSetting(section).FillIWorkspaceAccessRef(accessRef);
		return(0);
	}
	else if(csType == RESPONSE_SETTING)
	{
		m_settingManager.GetFilterSetting(section).FillIWorkspaceAccessRef(accessRef);
		return(0);
	}
	else if(csType == SERVER_STATUS)
	{
		m_statusManager.GetStatus().FillIWorkspaceAccessRef(accessRef);
		return(0);
	}
	else
		return(-1);
}


/*!
	T[oXe[^X̕ύX
*/
void CServer::WriteSystemLog(LPCSTR callerName, int statusCode, LPCSTR statusInfo, int autoOffTime)
{
	m_statusManager.WriteSystemLog(callerName, statusCode, statusInfo, autoOffTime);
}

/*!
	T[oXe[^X̕ύX
*/
void CServer::SetServerStatusInt(LPCSTR statusName, int status, LPCSTR statusInfo)
{
	m_statusManager.SetServerStatusInt(statusName, status, statusInfo);
}

/*!
	T[oXe[^X̕ύX
*/
void CServer::SetServerStatusStr(LPCSTR statusName, LPCSTR status, LPCSTR statusInfo)
{
	m_statusManager.SetServerStatusStr(statusName, status, statusInfo);
}


/*!
	C^tF[Xo^
*/
int CServer::RegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface)
{
	return(m_interfaceManager.RegisterInterface(interfaceName, ifRegister, oldInterface));
}

/*!
	C^[tF[Xo^
*/
int CServer::UnRegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface)
{
	return(m_interfaceManager.UnRegisterInterface(interfaceName, ifUnRegister, oldInterface));
}

/*!
	C^tF[X擾
*/
void *CServer::GetManagerInterface(LPCSTR interfaceName, int ifVersion)
{
	return(m_interfaceManager.GetInterface(interfaceName, ifVersion));
}
