/*
	CPathTools
	fBNg֌W̏s
	Cve[V t@C

	Version		: 0.0 (Release1)
	Version		: 0.0 (Release1)
			: t@ČpX̏Ȃ


	쐬		: 2000/12/07
	C		: ----/--/--
	藚	: 
*/

#include "stdafx.h"
#include "Dir.h"

#include <direct.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/*********************************************************************/
/*	CDirIndexer	*/
/*********************************************************************/
//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
CDirIndexer::CDirIndexer()
{
	m_allFileSize = 0;
}

CDirIndexer::~CDirIndexer()
{
}

//////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////
/*!
	e	: t@Č
			: path : pX(C:\*.jpgEEE)AsubDirectory : 1:TufBNgL
	Al		: -1FG[A0F
*/
int CDirIndexer::FindFile(CString path, int subDirectory)
{
	int				done=1;
	CFileFind		find;
	CString			fileName =  CPathTools::PathToName(path);

	m_allFileSize = 0;

	if(find.FindFile(path))
	{
		while(done)
		{
			done=find.FindNextFile();

			if(find.IsDots())
				continue;

			//	ċN
			if(find.IsDirectory())
			{
				if(subDirectory)
				{
					__int64 push = m_allFileSize;
					FindFile(find.GetFilePath() + _T("\\") + fileName,subDirectory);
					m_allFileSize += push;
				}
				continue;
			}
			
			//	xo邩EEE
			CString	add = find.GetFilePath();
			m_fileList.Add(add);
			m_allFileSize += find.GetLength();
		}
	}
	find.Close();
	
	return(0);
}


/*!
	e	: fBNǧ
			: path : pX(C:\*.jpgEEE)
	Al		: -1FG[A0F
*/
int CDirIndexer::FindDir(CString path,int subDirectory)
{
	int				done=1;
	CFileFind		find;
	CString			fileName =  CPathTools::PathToName(path);

	m_allFileSize = 0;

	if(find.FindFile(path))
	{
		while(done)
		{
			done=find.FindNextFile();

			if(find.IsDots())
				continue;

			//	ċN
			if(find.IsDirectory())
			{
				if(subDirectory)
					FindDir(find.GetFilePath() + _T("\\") + fileName);

				//	xo邩EEE
				CString	add = find.GetFilePath();
				m_fileList.Add(add);
			}			
		}
	}
	find.Close();
	
	return(0);
}

//////////////////////////////////////////////////////////////////////
// ʂւ̃ANZX
//////////////////////////////////////////////////////////////////////
/*!
	t@CXg擾
*/
void CDirIndexer::GetFileList(CStringArray &list)
{
	list.Copy(m_fileList);
}

/*!
	e	: t@CԂ
			: Ȃ
	Al		: t@C
*/
int CDirIndexer::GetFileCount()
{
	return((int)m_fileList.GetSize());
}


/*
	e	: t@C̃pXԂ
			: CfbNX
	Al		: t@CpX
*/
CString CDirIndexer::GetFilePath(int index)
{
	return(m_fileList.GetAt(index));
}

/*!
	t@CTCYԂ
*/
__int64 CDirIndexer::GetAllFleSize()
{
	return m_allFileSize;
}

/*********************************************************************/
/*	CDirIndexer	*/
/*********************************************************************/
//////////////////////////////////////////////////////////////////////
// fBNg
//////////////////////////////////////////////////////////////////////
/*!
	֐		: CPathTools::MakeDirectory(CString path)
	e	: fBNg̐
			: pX
	Al		: -1FG[A0Fłɑ݁A1Fɐ
*/
int CFileDirTools::MakeDirectory(CString path)
{
	CFileFind	find;

	while(1)
	{
		if(CPathTools::CheckBackSlash(path) || CPathTools::CheckLastChar(path,_T(' ')))
		{
			path=path.Left(path.GetLength()-1);
		}
		else
		{
			break;
		}
	}

	path=path+_T("\\");
	if(!find.FindFile(path + _T("*.*")))
	{
		find.Close();
		if(_tmkdir(path)==-1)
			return(-1);
		return(1);
	}
	find.Close();

	return(0);
}


/*!
	֐		: CPathTools::MakeAllDirectory(CString path)
	e	: pXɑ݂fBNgSĐ
			: pX
	Al		: -1FG[A0Fɐ
*/
int CFileDirTools::MakeAllDirectory(CString path)
{
	CString	mpath;
	int	i,ret=0;

	path = CPathTools::AddBackSlash(path);

	while(1)
	{
		i=path.Find(_T("\\"));
		if(i==-1)
			break;
		mpath = mpath + path.Left(i+1);
		path = path.Right(path.GetLength() - i - 1);

		//	lbg[NhCu΍
		ret = MakeDirectory(mpath);
	}
	return(ret);
}


///////////////////////////////////////////////////////////////////////
//	t@C
///////////////////////////////////////////////////////////////////////
/*!
	CDirectoryUtility::FILE_TYPE_FILE		t@C
	CDirectoryUtility::FILE_TYPE_DIRECTORY	tH_
	CDirectoryUtility::FILE_TYPE_NOTFOUND	Ȃ
*/
int CFileDirTools::FileExist(CString path)
{
	//	fBNgCfbNX狭擾
	CFileFind	find;

	//	fBNg
	if(CPathTools::CheckBackSlash(path))
	{
		if(find.FindFile(path + "*.*"))
			return(FILE_TYPE_DIRECTORY);
		TRACE("%d : %s\n", GetLastError(), path + "*.*");
		return(FILE_TYPE_NOTFOUND);
	}

	//	t@C
	if(find.FindFile(path))
	{
		find.FindNextFile();
		if(find.IsDirectory())
			return(FILE_TYPE_DIRECTORY);

		//	VXefoCXH
		if(find.GetFilePath().Left(4) == "\\\\.\\")
			return(FILE_TYPE_NOTFOUND);

		CString	srcPath = CPathTools::PathToName(path);
		CString	destPath = find.GetFileName();
		if(srcPath.CompareNoCase(destPath) == 0)
			return(FILE_TYPE_FILE);
	}

	//	fBNg2
	if(find.FindFile(path + _T("\\*.*")))
	{
		return(FILE_TYPE_DIRECTORY);
	}

	//	Ȃ
	return(FILE_TYPE_NOTFOUND);
}

/*!
	t@C̓fBNg̑擾
*/
DWORD CFileDirTools::GetFileAttribute(CString path)
{
	return(GetFileAttributes(CPathTools::RemoveBackSlash(path)));
}



/*********************************************************************/
/*	CPathTools	*/
/*********************************************************************/
///////////////////////////////////////////////////////////////////////
//	pXϊ
///////////////////////////////////////////////////////////////////////
/*!
	֐		: CPathTools::PathToName(CString path)
	e	: pXt@C擾
			: pX
	Al		: t@C
*/
CString CPathTools::PathToDrive(CString path)
{
	if(path.Mid(1,1) != _T(":"))
		return(_T(""));

	return(path.Left(1) + _T(":")); //	(X:)
}

/*!
	֐		: CPathTools::PathToName(CString path)
	e	: pXt@C擾
			: pX
	Al		: t@C
*/
CString CPathTools::PathToName(CString path)
{
	int	index;

	index = path.ReverseFind(_T('\\'));
	if(index==-1)
		return(path);

	return(path.Right(path.GetLength() - index - 1));
}

/*!
	֐		: CPathTools::PathToNameNoExt(CString path)
	e	: pXt@C(gqȂ)擾
			: pX
	Al		: t@C(gqȂ)
*/
CString CPathTools::PathToNameNoExt(CString path)
{
	CString	name = PathToName(path);
	int index = name.Find(".");
	if(index == -1)
		return(name);
	else
		return(name.Left(index));
}

/*!
	֐		: CPathTools::PathToDir(CString path)
	e	: pXt@C폜
			: pX
	Al		: pX
*/
CString CPathTools::PathToDir(CString path)
{
	int	index;

	index = path.ReverseFind(_T('\\'));
	if(index==-1)
		return(_T(""));

	path = path.Left(index);
	path = AddBackSlash(path);

	return(path);
}

/*!
	֐		: CPathTools::PathToDir(CString path)
	e		: pXgq擾
				: pX
	Al		: pX
*/
CString CPathTools::PathToExt(CString path)
{
	int	index;

	index = path.ReverseFind(_T('.'));
	if(index==-1)
		return(path);

	return(path.Right(path.GetLength() - index - 1));
}


/*!
	\it@C or tH_ or hCuj擾
*/
CString CPathTools::PathToViewName(CString path)
{
	//	t@C擾
	CString name = PathToName(path);
	if(!name.IsEmpty())
		return(name);
	
	//	obNXbV폜
	path = RemoveBackSlash(path);

	//	hCuH
	if(CheckLastChar(path, _T(':')))
		return(path + _T("\\"));

	//	fBNg
	return(PathToName(path));
}

/*!
	ЂƂ̃fBNgpX擾
*/
CString CPathTools::GetUpDir(CString path)
{
	path = RemoveBackSlash(path);
	int index = path.ReverseFind(_T('\\'));
	if(index == -1)
		return(path);

	return(AddBackSlash(path.Mid(0,index)));
}


/*!
	gȂu
*/
CString CPathTools::SafeName(CString name, CString replace)
{
	name.Replace(_T("/"),replace);
	name.Replace(_T("\\"),replace);
	name.Replace(_T(":"),replace);
	name.Replace(_T("?"),replace);
	name.Replace(_T("*"),replace);
	name.Replace(_T("\""),replace);
	name.Replace(_T(">"),replace);
	name.Replace(_T("<"),replace);

	return(name);
}

///////////////////////////////////////////////////////////////////////
//	pX̔r
///////////////////////////////////////////////////////////////////////
/*!
	pXɊ܂܂Ă邩ׂ

	\param parentPath	̃pX̃TufBNgׂ
	\param childPath	ׂpX
	\return				TRUE:TufBNg
*/
int CPathTools::IsInPath(CString parentPath, CString childPath)
{
	if(parentPath.CompareNoCase(childPath.Left(parentPath.GetLength())) == 0)
		return(TRUE);

	return(FALSE);
}

///////////////////////////////////////////////////////////////////////
//	/\̉H
///////////////////////////////////////////////////////////////////////
/*!
	XbVɒǉ
*/
CString CPathTools::AddSlash(CString path)
{
	if(CheckSlash(path))
		return(path);

	return(path + _T("/"));
}

/*!
	obNXbVɒǉ
*/
CString CPathTools::AddBackSlash(CString path)
{
	if(CheckSlash(path) || CheckBackSlash(path))
		return(path);

	return(path + _T("\\"));
}

/*!
	XbV납폜
*/
CString CPathTools::RemoveSlash(CString path)
{
	if(CheckSlash(path))
		path = path.Left(path.GetLength()-1);

	return(path);
}

/*!
	obNXbV납폜
*/
CString CPathTools::RemoveBackSlash(CString path)
{
	if(CheckBackSlash(path))
		path = path.Left(path.GetLength()-1);

	return(path);
}

/*!
	Ō̕`FbN
*/
int CPathTools::CheckLastChar(CString path,unsigned char c)
{
	unsigned char	*ptr = (unsigned char*)path.GetBuffer(path.GetLength() + 10);

	//	󕶎
	if(*ptr == 0)
		return(0);

	while(1)
	{
		//	VOoCg
		if(*ptr <= 0x80 || (*ptr >= 0xA0 && *ptr <= 0xDF))
		{
			//	I?
			if(*(ptr+1) == 0)
			{
				if(*ptr == c)
					return(1);
				else
					return(0);
			}
			ptr++;
		}
		else
		{
			//	I?
			if(*(ptr+1) == 0 || *(ptr+2) == 0)
				return(0);
			ptr+=2;
		}
	}
}

/*!
	ŌɃXbV邩
*/
int CPathTools::CheckSlash(CString path)
{
	return(CheckLastChar(path,_T('/')));
}

/*!
	ŌɃobNXbV邩
*/
int CPathTools::CheckBackSlash(CString path)
{
	return(CheckLastChar(path,_T('\\')));
}

///////////////////////////////////////////////////////////////////////
//	W[pX
///////////////////////////////////////////////////////////////////////
/*!
	W[pX擾
*/
CString CPathTools::GetAppPath()
{
	TCHAR	s[MAX_PATH+1];
	DWORD len = GetModuleFileName(NULL, s, MAX_PATH);

	while (s[len--]!=_T('\\') && len!=0 )
		;
	s[len+2] = _T('\0');        // }[NŏI点

	return(s);
}

/*!
	W[pX擾
*/
CString CPathTools::GetAppPathName()
{
	TCHAR	s[MAX_PATH+1];
	GetModuleFileName(NULL, s, MAX_PATH);

	return(s);
}



/////////////////////////////////////////////////////////////////////////
//	epX擾
/////////////////////////////////////////////////////////////////////////
/*!
	pXϐũpX擾

	%WINDOWS%		c:\Windows
	%SYSTEM32%		c:\Windows\System32
	%PROGRAMFILES%	c:\Program Files
*/
CString CPathTools::GetPathSwapString(CString path)
{
	//	TCY擾
	int len = ExpandEnvironmentStrings(path, NULL, 0) + 1;

	//	ϊ
	CString	ret;
	ExpandEnvironmentStrings(path, ret.GetBuffer(len + 1), len);
	ret.ReleaseBuffer();

	return(ret);
}

/*!
	Windows pX擾
*/
CString CPathTools::GetWindowsPath()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_WINDOWS, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}

/*!
	System32 pX擾
*/
CString CPathTools::GetSystem32Path()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_SYSTEM, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}

/*!
	Program Files pX擾
*/
CString CPathTools::GetProgramFilesPath()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_PROGRAM_FILES, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}


/*!
	All Users/Application Data pX擾
*/
CString CPathTools::GetCommonAppDataPath()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_COMMON_APPDATA, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}


/*********************************************************************/
/*	CFileTimeAccess	*/
/*********************************************************************/
//////////////////////////////////////////////////////////////////////
// CFileTimeAccess
//////////////////////////////////////////////////////////////////////
//	擾
int CFileTimeAccess::GetFileTime(CString path)
{
	//	J
	HANDLE hFile;
	SECURITY_ATTRIBUTES Sec;
	Sec.nLength = sizeof(SECURITY_ATTRIBUTES);
	Sec.lpSecurityDescriptor = NULL;
	Sec.bInheritHandle = FALSE;
	if((hFile = CreateFile(path, GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, &Sec, OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, NULL)) == INVALID_HANDLE_VALUE)
		return(-1);

	//	擾
	if(::GetFileTime(hFile, &m_cTime, &m_aTime, &m_mTime)==0)
	{
		CloseHandle(hFile);
		return(-1);
	}

	CloseHandle(hFile);
	return(0);
}

//	ݒ
int CFileTimeAccess::SetFileTime(CString path)
{
	DWORD Attr;

	// GENERIC_WRITEw肷邽߂ReadOnly
	if((Attr = GetFileAttributes(path)) != 0xFFFFFFFF)
		SetFileAttributes(path, Attr & ~FILE_ATTRIBUTE_READONLY);

	//	J
	HANDLE hFile;
	SECURITY_ATTRIBUTES Sec;
	Sec.nLength = sizeof(SECURITY_ATTRIBUTES);
	Sec.lpSecurityDescriptor = NULL;
	Sec.bInheritHandle = FALSE;
	if((hFile = CreateFile(path, GENERIC_WRITE | GENERIC_READ, FILE_SHARE_READ|FILE_SHARE_WRITE, &Sec, OPEN_EXISTING, FILE_FLAG_BACKUP_SEMANTICS, NULL)) == INVALID_HANDLE_VALUE)
		return(-1);

	//	sSH
	if(m_cTime == 0 || m_aTime == 0 || m_mTime == 0)
	{
		CFileTime	cTime,aTime,mTime;
		if(::GetFileTime(hFile, &cTime, &aTime, &mTime)==0)
		{
			CloseHandle(hFile);
			return(-1);
		}

		//	C
		if(m_cTime == 0)
			m_cTime = cTime;
		if(m_aTime == 0)
			m_aTime = aTime;
		if(m_mTime == 0)
			m_mTime = mTime;
	}

	//	ݒ
	::SetFileTime(hFile, &m_cTime, &m_aTime, &m_mTime);
	CloseHandle(hFile);

	// Agr[gɖ߂Ă
	if(Attr != 0xFFFFFFFF)
		SetFileAttributes(path, Attr);

	return(0);
}


int CFileTimeAccess::GetFileTime(HANDLE hFile)
{
	//	擾
	if(::GetFileTime(hFile, &m_cTime, &m_aTime, &m_mTime)==0)
	{
		return(-1);
	}
	return(0);
}

int CFileTimeAccess::SetFileTime(HANDLE hFile)
{
	if(::SetFileTime(hFile, &m_cTime, &m_aTime, &m_mTime)==0)
	{
		return(-1);
	}
	return(0);
}

//	ԕϊ
CFileTime CFileTimeAccess::CTimeToCFileTime(CTime time)
{
	if(time == 0)
		return(0);

	SYSTEMTIME timeDest;
	time.GetAsSystemTime(timeDest);
	FILETIME fileTime,fileTimeLocal;
	::SystemTimeToFileTime(&timeDest, &fileTime);
	::LocalFileTimeToFileTime(&fileTime,&fileTimeLocal);

	return(fileTimeLocal);
}	

