#include "StdAfx.h"
#include "PipePair.h"
#include "ThreadSkeleton.h"

////////////////////////////////////////////////////////////////////
//	쐬
////////////////////////////////////////////////////////////////////
/*!
	I[o[bvtOݒ肵pCv쐬
*/
int CPipePair::CreateOvrlappedPipe(CString uniqueCode, int bufSize)
{
	//	Ă
	Close();

	//	ZLeB
	SECURITY_ATTRIBUTES	sa;
	memset(&sa, 0, sizeof(sa));
	sa.lpSecurityDescriptor = NULL;
	sa.bInheritHandle = TRUE;	//	nhp

	// ݃pCv̍쐬̍쐬
	m_hWritePipe = ::CreateNamedPipe("\\\\.\\pipe\\_04WebServer_SUBPROCESS_" + uniqueCode,
				PIPE_ACCESS_OUTBOUND | FILE_FLAG_OVERLAPPED, PIPE_TYPE_BYTE,
				1, bufSize, bufSize, 1000, &sa);
	if(m_hWritePipe == INVALID_HANDLE_VALUE )
		return(-1);

	//	ǂݍ݃pCv̍쐬
	m_hReadPipe = ::CreateFile("\\\\.\\pipe\\_04WebServer_SUBPROCESS_" + uniqueCode,
				GENERIC_READ, 0, &sa, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if(m_hReadPipe == INVALID_HANDLE_VALUE )
	{
		SAFE_CLOSE_HANDLE(m_hWritePipe);
		return(-1);
	}

	//	pCvڑ
	if(!::ConnectNamedPipe(m_hWritePipe, NULL) && GetLastError() != ERROR_PIPE_CONNECTED)
	{
		SAFE_CLOSE_HANDLE(m_hWritePipe);
		SAFE_CLOSE_HANDLE(m_hReadPipe);
		return(-1);
	}

	return(0);
}

///////////////////////////////////////////////////////////////////////
//	ʐM
///////////////////////////////////////////////////////////////////////
/*!
	o
*/
int CPipePair::Write(CBinaryData &buf, HANDLE breakEvent, int timeout)
{
	//	Cxg
	::ResetEvent(m_rwEvent);

	//	I[o[bv\̏
	OVERLAPPED	ovr;
	INIT_OVERLAPPED(ovr, m_rwEvent);

	//	vZX֑M
	DWORD	sended = 0;
	if(!WriteFile(GetWritePipe(), buf.GetPtr(), buf.GetSize(), &sended, &ovr))
	{
		//	G[H
		if(GetLastError() != ERROR_IO_PENDING)
			return(-1);

		//	҂
		if(WaitComplete(GetWritePipe(), &ovr, sended, breakEvent, timeout))
			return(-1);
	}

	return(sended);
}

/*!
	ǂݏo
*/
int CPipePair::Read(CBinaryData &buf, int blockSize, HANDLE breakEvent, int timeout)
{
	//	obt@
	buf.ReSize(blockSize);

	//	Cxg
	::ResetEvent(m_rwEvent);

	//	I[o[bv\̏
	OVERLAPPED	ovr;
	INIT_OVERLAPPED(ovr, m_rwEvent);

	//	vZX֑M
	DWORD	readed = 0;
	if(!ReadFile(GetReadPipe(), buf.GetPtr(), buf.GetSize(), &readed, &ovr))
	{
		//	EOF?
		if(GetLastError() == ERROR_HANDLE_EOF)
			readed = 0;
		else
		{
			//	G[H
			if(GetLastError() != ERROR_IO_PENDING)
				return(-1);

			//	҂
			if(WaitComplete(GetReadPipe(), &ovr, readed, breakEvent, timeout))
				return(-1);
		}
	}

	//	TCYݒ
	buf.ReSize(readed);
	return(readed);
}

/*!
	ǂݏo(j)
*/
int CPipePair::Peek(CBinaryData &buf, int blockSize)
{
	//	obt@
	buf.ReSize(blockSize);

	//	ǂݏoĂ݂
	DWORD	readed = 0;
	if(!PeekNamedPipe(GetReadPipe(), buf.GetPtr(), buf.GetSize(), &readed, NULL, NULL))
		return(-1);

	//	TCYݒ
	buf.ReSize(readed);
	return(readed);
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	⏕֐
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Cxg҂ȂAؒf`FbN

*/
int CPipePair::WaitComplete(HANDLE pipe, LPOVERLAPPED ovr, DWORD &transCount, HANDLE breakEvent, int timeout)
{
	//	I҂
	switch(CThreadSkeleton::WaitForSomeObjects(timeout, m_rwEvent, breakEvent))
	{
	//	
	case 1:
		if(!GetOverlappedResult(pipe, ovr, &transCount, FALSE))
			return(0);
		if(GetLastError() == ERROR_HANDLE_EOF)
		{
			transCount = 0;
			return(0);
		}
		return(-1);

	//	^CAEg or f
	case 0:
	case 2:
	default:
		CancelIo(pipe);
		return(-1);
	}
}
