#pragma once
#include "ModuleInterface.h"
#include "ServerToolWrap.h"
#include "Context.h"
#include "SyncObject.h"

//!	C^tF[X
#define	RESPONSE_MANAGER_INTERFACE_NAME	"IResponseManager"

//!	C^tF[Xo[W
#define	RESPONSE_MANAGER_INTERFACE_VER	1

//!	X|Xt@NgAC
class CResponseFactoryArray : public CArray<CIResponseFactoryWrapper> {};


/*!
	X|XǗ
*/
class IResponseManager
{
public:
	//!	X|X
	virtual IResponsePtr GetResponse(CContext context) = 0;
};
//!	|C^^
typedef IResponseManager* IResponseManagerPtr;


/*!
	X|XǗ
*/
class CResponseManager : public IManagerInterface, public IResponseManager
{
public:
	CResponseManager(void);
	virtual ~CResponseManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

protected:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	IManagerInterface
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual void *GetInterface(int ifVersion)
	{
		if(ifVersion != RESPONSE_MANAGER_INTERFACE_VER)
			return(NULL);
		return(GetIResponseManager());
	};

	//!	I[o[[hʒm
	virtual void NotifyOverload() {};

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	IResponseManager
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|X
	IResponsePtr GetResponse(CContext context);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^[tF[X擾
	IResponseManagerPtr GetIResponseManager() { return this; };

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter		m_init;

	//!	NeBJZNV
	CCriticalSection		m_scopeLock;

	//!	T[oc[
	CIServerToolWrap				m_serverTool;

	//!	t@Ng
	CResponseFactoryArray	m_responseFactorys;
};
