#include "StdAfx.h"
#include "SystemLogManager.h"
#include "ServerStartErrorException.h"
#include "Dir.h"
#include "TextTools.h"
#include "DateUtility.h"

#define	CLASS_NAME			"SystemLogManager"
#define	MAX_OFFLINE_LOG		4096

CSystemLogManager::CSystemLogManager(void)
{
	//	ftHgO
	m_logName = CPathTools::GetAppPath() + "Logs\\SystemLog.txt";
}

CSystemLogManager::~CSystemLogManager(void)
{
	Stop();
	FlashOfflineLog();
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CSystemLogManager::Start(CIServerToolWrap serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	ݒ擾
	m_setting = serverTool.GetManagerSetting(m_setting.GetSettingName());
	m_logName = m_setting.GetSystemLogFilePath();

	//	JnÕOo
	FlashOfflineLog();
}

/*!
	~
*/
void CSystemLogManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;

	//	I
	m_init = FALSE;
}

/*!
	VXeO֏o
*/
void CSystemLogManager::WriteSystemLog(CString callerName, CString statusInfo)
{
	SCOPE_LOCK();

	//	Ŝ
	statusInfo.Replace("\r", "_");
	statusInfo.Replace("\n", "_");

	if(m_init)
	{
		if(!m_offlineLog.IsEmpty())
			FlashOfflineLog();

		WriteSystemLogToFile(CTextTools::GetFormat("[%s] <%s> %s\n", CDateUtility::GetTimeString(CTime::GetCurrentTime()), callerName, statusInfo));
	}
	else
	{
		//	ItCO֒ǉ
		AddOfflineLog(CTextTools::GetFormat("[%s] <%s> %s\n", CDateUtility::GetTimeString(CTime::GetCurrentTime()), callerName, statusInfo));
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	c[
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	ItCO֒ǉ
*/
void CSystemLogManager::AddOfflineLog(CString log)
{
	SCOPE_LOCK();

	if(m_offlineLog.GetSize() < MAX_OFFLINE_LOG)
		m_offlineLog.AddTail(log);
}

/*!
	ItCOׂďo
*/
void CSystemLogManager::FlashOfflineLog()
{
	SCOPE_LOCK();

	//	ItCOfo
	while(!m_offlineLog.IsEmpty())
		WriteSystemLogToFile(m_offlineLog.RemoveHead());
}

/*!
	VXeO֏o
*/
void CSystemLogManager::WriteSystemLogToFile(CString log)
{
	SCOPE_LOCK();

	//	SẴfBNgĂ
	static CString	oldLogName;
	if(oldLogName != m_logName)
	{
		CFileDirTools::MakeAllDirectory(CPathTools::PathToDir(m_logName));
		oldLogName = m_logName; 
	}

	//	t@C
	FILE	*logFile;
	if(!fopen_s(&logFile, m_logName, "at+"))
	{
		fprintf(logFile, "%s", log);
		fclose(logFile);
	}
}

