#include "StdAfx.h"
#include ".\workspacenode.h"

//////////////////////////////////////////////////////////////////////////////////////////
//	Ȃ
//////////////////////////////////////////////////////////////////////////////////////////
CWorkspaceNode::CWorkspaceNode(void)
{
}

CWorkspaceNode::CWorkspaceNode(CString name)
{
	m_nodeName = name;
}

CWorkspaceNode::~CWorkspaceNode(void)
{
}

//	Rs[Iy[^
void CWorkspaceNode::operator=(const CWorkspaceNode &other)
{
	//	f[^̃Rs[
	m_nodeName = other.m_nodeName;
	m_keyData.Copy(other.m_keyData);
	m_subNode.Copy(other.m_subNode);
}

//	SăNA
void CWorkspaceNode::Clear(void)
{
	//	f[^폜
	m_keyData.RemoveAll();
	m_subNode.RemoveAll();
}


//////////////////////////////////////////////////////////////////////////////////////////
//	Keyɑ΂鏈(Public)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	f[^̐ݒ

	̃m[h̃f[^ɑ΂ANZX
*/
void CWorkspaceNode::SetKeyData(CString key, CString data, int noCase)
{
	int	index = FindKeyIndex(key,noCase);
	if(index == -1)
	{
		m_keyData.Add(key,data);
	}
	else
	{
		m_keyData[index].m_data = data;
	}
}

/*!
	f[^̎擾

	̃m[h̃f[^ɑ΂ANZX
*/
CString CWorkspaceNode::GetKeyData(CString key, CString defaultData, int noCase)
{
	int	index = FindKeyIndex(key,noCase);
	if(index == -1)
	{
		return(defaultData);
	}
	else
	{
		return(m_keyData[index].m_data);
	}
}


/*!
	f[^̍폜

	̃m[h̃f[^ɑ΂ANZX
*/
void CWorkspaceNode::DeleteKey(CString key)
{
	int index = FindKeyIndex(key,FALSE);
	if(index != -1)
		m_keyData.RemoveAt(index);
}


/*!
	L[擾
*/
int CWorkspaceNode::GetKeyCount()
{
	return((int)m_keyData.GetSize());
}

/*!
	SẴL[𕶎ƂĎ擾
*/
int CWorkspaceNode::GetAllKey(IStringArrayPtr list)
{
	//	TCY
	int count = (int)m_keyData.GetSize();
	list->SetSize(count);

	//	ݒ
	for(int i=0;i<count;i++)
		list->SetString(i, m_keyData[i].m_key);

	return(count);
}

/*!
	SẴf[^𕶎ƂĎ擾
*/
int CWorkspaceNode::GetAllData(IStringArrayPtr list)
{
	//	TCY
	int count = (int)m_keyData.GetSize();
	list->SetSize(count);

	//	ݒ
	for(int i=0;i<count;i++)
		list->SetString(i, m_keyData[i].m_data);

	return(count);
}



/*!
	L[

	\param	pathCompare	̕v
*/
int CWorkspaceNode::FindKeyData(CString sData, int noCase, int pathCompare)
{
	if(pathCompare)
	{
		//	r
		for(int i=0;i<m_keyData.GetCount();i++)
		{
			if(m_keyData[i].m_data.CompareNoCase(sData.Left(m_keyData[i].m_data.GetLength())) == 0)
				return(i);
		}

		return(-1);
	}
	else
		return(m_keyData.Find(sData, noCase));
}
	

/*!
	L[܂Ƃ߂Đݒ
*/
void CWorkspaceNode::ClearAndSetKeys(CStringArray &keys, CStringArray &datas)
{
	Clear();

	//	TCYύX
	m_keyData.SetSize(keys.GetSize());

	//	ݒ
	for(int i=0;i<keys.GetSize();i++)
	{
		m_keyData[i].m_key = keys[i];
		m_keyData[i].m_data = datas[i];
	}
}

//////////////////////////////////////////////////////////////////////////////////////////
//	Keyɑ΂鏈(Protect)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	Leaf̌
*/
int CWorkspaceNode::FindKeyIndex(CString &key,int noCase)
{
	return(m_keyData.Find(key, noCase));
}

//////////////////////////////////////////////////////////////////////////////////////////
//	Tum[hɑ΂鏈(Public)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	Tum[h
*/
CWorkspaceNode *CWorkspaceNode::GetSubNode(CString path, CString &key)
{
	CString	topPath,subPath;
	if(ParsePath(path,topPath,subPath) == 0)
	{
		//	
		key = subPath;
		return this;
	}
	else
	{
		//	̃Tum[h
		int index = FindSubNodeIndex(topPath);
		if(index == -1)
		{
			//	Aǉ
			index = (int)m_subNode.GetSize();
			m_subNode.Add(CWorkspaceNode(topPath));
		}

		return(m_subNode[index].GetSubNode(subPath,key));	//	ɉ
	}

}

/*!
	Tum[hǉ
*/
void CWorkspaceNode::AddSubNode(CString name)
{
	ASSERT(name.Find("::") == -1);

	//	̃Tum[h
	int index = FindSubNodeIndex(name);
	if(index == -1)
	{
		//	Aǉ
		m_subNode.Add(CWorkspaceNode(name));
	}
}


/*!
	m[h폜

	# ֐łSCOPE_LOCKgp֎~II
	# fbhbN
*/
void CWorkspaceNode::DeleteNode(CString name)
{
	int index = FindSubNodeIndex(name);
	if(index != -1)
		m_subNode.RemoveAt(index);
}


/*!
	Tum[h𓾂
*/
int CWorkspaceNode::GetSubNodeCount()
{
	return((int)m_subNode.GetSize());
}


/*!
	SẴTum[h𕶎ƂĎ擾

	̃Tum[ĥ݂łB
	ʃm[hւ͌ɍs܂
*/
int CWorkspaceNode::GetAllSubNode(IStringArrayPtr list)
{
	//	TCY
	int count = (int)m_subNode.GetSize();
	list->SetSize(count);

	//	ݒ
	for(int i=0;i<count;i++)
		list->SetString(i, m_subNode[i].m_nodeName);

	return(count);
}



//////////////////////////////////////////////////////////////////////////////////////////
//	Tum[hɑ΂鏈(Protected)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	Tum[h
*/
int CWorkspaceNode::FindSubNodeIndex(CString name)
{
	for(int i=0;i<m_subNode.GetSize();i++)
	{
		if(m_subNode[i].m_nodeName == name)
			return(i);
	}
	return -1;
}


//////////////////////////////////////////////////////////////////////////////////////////
//	̑̊֐(Protect)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	pX(u::v؂𕪉)

	\param path		pX
	\param topPath	gbvx̃pX
	\param subPath	c
	\return			0:̃L[A1:܂TuL[
*/
int CWorkspaceNode::ParsePath(CString path, CString & topPath, CString & subPath)
{
	int	index = path.Find(_T("::"));
	if(index == -1)
	{
		topPath.Empty();
		subPath = path;
		return(0);
	}
	else
	{
		if(path == _T("::"))
		{
			topPath.Empty();
			subPath.Empty();
			return(0);
		}

		topPath = path.Mid(0,index);
		subPath = path.Mid(index + 2);
		return(1);
	}
}


/******************************************************
	o͂Ɋւ鏈
*******************************************************/
/*!
	Tum[h쐬
*/
CWorkspaceNode *CWorkspaceNode::AddNewSubNode(CString name)
{
	if(FindSubNodeIndex(name) != -1)
		return(NULL);

	m_subNode.Add(CWorkspaceNode(name));
	return &m_subNode[m_subNode.GetSize()-1];
}


/*!
	Tum[hCfbNXŎ擾
*/
CWorkspaceNode *CWorkspaceNode::GetSubNodeByIndex(int index)
{
	if(index < 0 || index >= m_subNode.GetCount())
		return(NULL);

	return(&m_subNode[index]);
}

/*!
	L[CfbNXŎ擾
*/
CWorkspaceKeyData *CWorkspaceNode::GetKeyByIndex(int index)
{
	if(index < 0 || index >= m_keyData.GetCount())
		return(NULL);

	return(&m_keyData[index]);
}

