#include "StdAfx.h"
#include "alias.h"
#include "dir.h"
#include "connection.h"
#include "StringCompare.h"

CAlias::CAlias()
{
	m_isMove = 0;
	m_isDirectory = 0;
}

CAlias::CAlias(CString url,CString targetHost,CConfigAccess serverSetting)
{
	m_targetHost = targetHost;
	m_serverSetting = serverSetting;
	m_pathSetting = m_serverSetting.GetAccess("Path");
	m_indexSetting = m_serverSetting.GetAccess("Index");
	m_url = url;
	m_isMove = 0;
	m_isDirectory = 0;

	//	̂߁AbN
	LOCK_CONFIG(serverSetting);

	//	pX̎擾
	m_pathInfo = FindPathInfo(m_url,targetHost);
	FindTarget(m_url);
	CheckIndexFile();
	CheckExtraPath();
}

CAlias::~CAlias(void)
{
}

/*!
 *	pX̎擾
 *
 *	@return		pX
 */
CConfigAccess CAlias::GetPathInfo()
{
	return(m_pathInfo);
}

/*!
 *	pXOptions擾
 *
 *	@return		pX
 */
CConfigAccess CAlias::GetPathOptions()
{
	return(m_pathInfo.GetAccess("Options"));
}

/*!
 *	^[Qbg擾
 *
 *	@return		pX
 */
CString CAlias::GetTarget()
{
	return(m_target);
}

/*!
 *	^[Qbg擾
 *
 *	@return		pX
 */
CString CAlias::GetExtraTarget()
{
	return(m_extraTarget);
}

/*!
 *	GNXgpX擾
 *
 *	@return		pX
 */
CString CAlias::GetExtraPath()
{
	return(m_extraPath);
}

/*!
 *	zXg擾
 *
 *	@return		pX
 */
CString CAlias::GetTargetHost()
{
	return(m_targetHost);
}

/*!
 *	ړ擾
 *
 *	@return		URL
 */
CString CAlias::GetMoveTo()
{
	return(m_moveTo);
}

/*!
 *	ړ̕Kv邩擾
 *
 *	@return		1:ړ
 */
int CAlias::IsMove()
{
	return(m_isMove);
}

/*!
 *	fBNgH
 *
 *	@return		1:fBNg
 */
int CAlias::IsDirectory()
{
	return(m_isDirectory);
}

/*!
 *	݂́H
 *
 *	@return		1:
 */
int CAlias::IsExist()
{
	if(m_isMove)
		return(1);

	if(CDir::FileExist(m_target) != CDir::FILE_TYPE_NOTFOUND)
		return(1);

	return(0);
}

/*!
 *	GNXgpX̂H
 *
 *	@return		1:
 */
int	CAlias::IsExtarExist()
{
	return(!m_extraPath.IsEmpty());
}


/*!
 *	Bt@CH
 *
 *	@return		1:
 */
int CAlias::IsHidden()
{
	if(IsExist() == 0)
		return(0);

	int	attr = CDir::GetFileAttribute(m_target);
	if(attr != -1 && (attr & CDir::FILE_ATTR_HIDDEN))
		return(1);

	return(0);
}

/*!
 *	CfbNXt@ĆH
 *
 *	@return		1:
 */
int CAlias::CheckIndexFile()
{
	if(IsDirectory() && !m_isMove)
	{
		CConfigAccess	index = m_serverSetting.GetAccess("Index");
		CStringArray	keyList;
		int i,len = index.GetAllKey(keyList);

		for(i=0;i<len;i++)
		{
			if(CDir::FileExist(m_target + index.GetConfig(keyList[i],"")) == CDir::FILE_TYPE_FILE)
			{
				m_isMove = 1;
				m_moveTo = index.GetConfig(keyList[i],"");
				return(1);
			}
		}
	}

	return(0);
}

/*!
 *	pX̌
 *
 *@v̒ŁAłT[opXԂ
 *	T[opXꍇ́AłzXgԂ
 *
 *	@return		pX
 */
CConfigAccess CAlias::FindPathInfo(CString url,CString targetHost)
{
	//	o[`zXg
	CStringArray	hostList;
	FindVirtualHost(targetHost,hostList);

	//	pX
	CStringArray	hitList;
	FindPath(url,hostList,hitList);

	//	vꍇAłvpX擾
	int len = (int)hitList.GetSize();
	int maxIndex = 0;
	if(len > 1)
	{
		int	maxHit = 0;
		int urlLen = url.GetLength();
		for(int i=0;i<len;i++)
		{
			CConfigAccess	compPath = m_pathSetting.GetAccess(hitList[i]);
			CString			hostName = compPath.GetConfig("VirtualHost","*");
			int				hostNameLen = hostName.GetLength();

			if(maxHit < hostNameLen)
			{
				maxHit = hostNameLen;
				maxIndex = i;
			}
		}
	}

	return m_pathSetting.GetAccess(hitList[maxIndex]);
}


/*!
 *	łvpX
 *
 *	@param allNode	m[h
 *	@param nodeList	m[h
 */
void CAlias::FindPath(CString url,CStringArray &allNode,CStringArray &nodeList)
{
	int len = (int)allNode.GetSize();
	nodeList.RemoveAll();

	//	vpX
	CStringArray	machNode;
	int urlLen = url.GetLength();
	int	maxHit = 0;
	for(int i=0;i<len;i++)
	{
		CConfigAccess	compPath = m_pathSetting.GetAccess(allNode[i]);
		CString			serverPath = compPath.GetConfig("ServerPath","/");
		int				serverPathLen = serverPath.GetLength();

		if(urlLen >= serverPathLen)
		{
			if(serverPath.CompareNoCase(url.Left(serverPathLen)) == 0)
			{
				if(maxHit <= serverPathLen)
				{	
					maxHit = serverPathLen;
					machNode.Add(allNode[i]);
				}
			}
		}
		else if(urlLen + 1 == serverPathLen)
		{
			//	'/'̖AfBNgw
			if(serverPath.CompareNoCase(url + "/") == 0)
			{
				if(maxHit <= serverPathLen)
				{	
					maxHit = serverPathLen;
					machNode.Add(allNode[i]);
				}
			}
		}
	}

	//	Ȃ΃G[
	if(machNode.GetSize() == 0)
		throw CServerFatalException("Ȃ̃ANZXURĹÃT[o̊Ǘł͂܂");

	//	vꍇAvpX̒ŁA̒Zr
	len = (int)machNode.GetSize();
	if(len >1)
	{
		for(int i=0;i<len;i++)
		{
			CConfigAccess	compPath = m_pathSetting.GetAccess(machNode[i]);
			CString			serverPath = compPath.GetConfig("ServerPath","/");
			int				serverPathLen = serverPath.GetLength();

			if(maxHit <= serverPathLen)
				nodeList.Add(machNode[i]);
		}
	}
	else
	{
		nodeList.Add(machNode[0]);
	}
}


/*!
 *	o[`zXg
 *
 *	@param nodeList	m[h
 */
void CAlias::FindVirtualHost(CString targetHost,CStringArray &nodeList)
{
	CStringArray	allNode;
	int len = m_pathSetting.GetAllSubNode(allNode);
	nodeList.RemoveAll();

	//	pXݒ肪
	if(len == 0)
		throw CServerFatalException("pXݒ肪݂܂Aݒ肵ĂI");

	//	܂Ao[`zXg
	if(targetHost.IsEmpty())
		targetHost = "*";
	for(int i=0;i<len;i++)
	{
		CConfigAccess	compPath = m_pathSetting.GetAccess(allNode[i]);
		CString			hostName = compPath.GetConfig("VirtualHost","*");
		int				hostNameLen = hostName.GetLength();

		//	v΁AHitXgɒǉ
		if(hostName == "*" || CStringCompare::WildCompare(hostName,targetHost))
			nodeList.Add(allNode[i]);
	}

	if(nodeList.GetSize() == 0)
		throw CServerFatalException("Ȃ̃ANZXzXg(URL)́ÃT[o̊Ǘł͂܂");
}

/*!
 *	pX̕ϊ
 *
 *	@param	url	URL
 *	@return		pX
 */
void CAlias::FindTarget(CString url)
{
	CString serverPath = m_pathInfo.GetConfig("ServerPath","/");
	int urlLen = url.GetLength();
	int serverPathLen = serverPath.GetLength();

	CString	localPath = m_pathInfo.GetConfig("LocalPath","Z:\\");

	//	]H
	if(m_pathInfo.GetConfig("Forward","") != "")
	{
		if(urlLen > serverPathLen)
		{
			CString sub = url.Mid(serverPath.GetLength());
			m_moveTo = m_pathInfo.GetConfig("Forward","") + sub;
		}
		else
		{
			m_moveTo = m_pathInfo.GetConfig("Forward","");
		}
		m_isMove = 1;
	}
	else
	{
		if(urlLen > serverPathLen)
		{
			CString sub = url.Mid(serverPath.GetLength());
			sub.Replace('/','\\');

			m_target = localPath + sub;

			//	fBNg?
			if(CDir::CheckBackSlash(m_target))
				m_isDirectory = 1;
			else
			{
				//	fBNgŁAړ̕KvH
				if(CDir::FileExist(m_target + "\\") == CDir::FILE_TYPE_DIRECTORY)
				{
					m_isMove = 1;
					m_isDirectory = 1;

					m_moveTo = url + "/";
					m_target += "\\";
				}
			}
		}
		else if(urlLen == serverPathLen)
		{
			m_target = localPath;
			m_isDirectory = 1;
		}
		else
		{
			m_isMove = 1;
			m_isDirectory = 1;

			m_moveTo = serverPath;
			m_target = localPath;
		}
	}
}


/*!
 *	GLXgpX݂̑𒲂ׂ
 *
 *	@return		1:GLXgpXA0:Ȃ
 */
int CAlias::CheckExtraPath()
{
	m_extraPath = "";
	m_extraTarget = "";

	//	
	if(IsExist() || IsMove() || IsDirectory())
		return(0);

	//	x[XpX擾
	CString	localPath = m_pathInfo.GetConfig("LocalPath","Z:\\");
	CString	target = CDir::GetUpDir(GetTarget());

	//	֏Ă
	for(int i=0;i<500;i++)
	{
		//	Ȃ
		if(target.GetLength() <= localPath.GetLength())
			break;

		//	
		if(CDir::FileExist(target) == CDir::FILE_TYPE_FILE)
		{
			m_extraPath = m_target.Mid(target.GetLength());
			m_extraTarget = target;
			return(1);
		}
	}

	return(0);
}
