#include "StdAfx.h"
#include "bandwidthmgr.h"

CBandWidthMgr::CBandWidthMgr(void)
{
	m_curSend = 0;
	m_curRecv = 0;
	m_allSend = 0;
	m_allRecv = 0;
	m_allCount = 0;
}

CBandWidthMgr::~CBandWidthMgr(void)
{
}

void CBandWidthMgr::Load(CConfigAccess setting)
{
	CConfigAccess limit = setting.GetAccess("Limit");

	//	ݒ胍[h
	m_SendMaxServerBandWidth = limit.GetConfig("Send::MaxServerBandWidth",0) * 1024;
	m_SendMaxOneHostBandWidth = limit.GetConfig("Send::MaxOneHostBandWidth",0) * 1024;
	m_SendMaxOneConnectBandWidth = limit.GetConfig("Send::MaxOneConnectBandWidth",0) * 1024;

	m_RecvMaxServerBandWidth = limit.GetConfig("Recv::MaxServerBandWidth",0) * 1024;
	m_RecvMaxOneHostBandWidth = limit.GetConfig("Recv::MaxOneHostBandWidth",0) * 1024;
	m_RecvMaxOneConnectBandWidth = limit.GetConfig("Recv::MaxOneConnectBandWidth",0) * 1024;

	m_MaxOneHostConnect = setting.GetConfig("Basic::MaxOneHostConnect",0);
}


//	ڑ̒ǉ
void CBandWidthMgr::AddConnection(CIPAddress host,CString code,int sendLimit,int recvLimit)
{
	SCOPE_LOCK();

	int index = FindConnection(code);
	if(index != -1)
	{
		m_connections[index].m_hostAddress = host;
		m_connections[index].m_connectionCode = code;
		m_connections[index].m_sendLimit = sendLimit;
		m_connections[index].m_recvLimit = recvLimit;
	}
	else
	{
		m_connections.Add(COneConnection(host,code,sendLimit,recvLimit));
	}
}


//	ڑ̍폜
void CBandWidthMgr::DelConnection(CString code)
{
	SCOPE_LOCK();

	int index = FindConnection(code);
	if(index != -1)
	{
		m_connections.RemoveAt(index);
	}
}


//	ڑ̌
int CBandWidthMgr::FindConnection(CString code)
{
	SCOPE_LOCK();

	for(int i=0;i<m_connections.GetSize();i++)
	{
		if(m_connections[i].m_connectionCode == code)
			return(i);
	}

	return(-1);
}

//	Sڑ̎擾
int CBandWidthMgr::GetAllConnectionCount()
{
	SCOPE_LOCK();

	return((int)m_connections.GetCount());
}

//	̃zXg̐ڑ擾
int CBandWidthMgr::GetHostConnectionCount(CIPAddress host)
{
	SCOPE_LOCK();

	int count = 0;
	for(int i=0;i<m_connections.GetSize();i++)
	{
		if(m_connections[i].m_hostAddress == host)
			count++;
	}

	return(count);
}

//	MK̐ڑ擾
int CBandWidthMgr::GetAllSendConnectionCount()
{
	SCOPE_LOCK();

	int count = 0;
	for(int i=0;i<m_connections.GetSize();i++)
	{
		if(m_connections[i].m_sendLimit)
			count++;
	}
	return(count);
}

//	PzXg瑗MK̐ڑ擾
int CBandWidthMgr::GetHostSendConnectionCount(CIPAddress host)
{
	SCOPE_LOCK();

	int count = 0;
	for(int i=0;i<m_connections.GetSize();i++)
	{
		if(m_connections[i].m_hostAddress == host && m_connections[i].m_sendLimit)
			count++;
	}
	
	return(count);
}

//	MK̐ڑ擾
int CBandWidthMgr::GetAllRecvConnectionCount()
{
	SCOPE_LOCK();

	int count = 0;
	for(int i=0;i<m_connections.GetSize();i++)
	{
		if(m_connections[i].m_recvLimit)
			count++;
	}
	return(count);
}

//	PzXgMK̐ڑ擾
int CBandWidthMgr::GetHostRecvConnectionCount(CIPAddress host)
{
	SCOPE_LOCK();

	int count = 0;
	for(int i=0;i<m_connections.GetSize();i++)
	{
		if(m_connections[i].m_hostAddress == host && m_connections[i].m_recvLimit)
			count++;
	}
	
	return(count);
}


//	݂̍ő呗Mx擾
int CBandWidthMgr::GetCurrentSendLimit(CIPAddress host)
{
	CSortArray<int,int>	list;

	//	T[oS
	int count = GetAllSendConnectionCount();
	if(m_SendMaxServerBandWidth != 0 && count != 0)
		list.Add(m_SendMaxServerBandWidth / count);

	//	PzXg
	count = GetHostSendConnectionCount(host);
	if(m_SendMaxOneHostBandWidth != 0 && count != 0)
		list.Add(m_SendMaxOneHostBandWidth / count);

	//	Pڑ
	if(m_SendMaxOneConnectBandWidth != 0)
		list.Add(m_SendMaxOneConnectBandWidth);

	
	if(list.GetSize())
	{
		//	Ƀ\[g
		list.Sort();

		return(list[0]);
	}
	else
	{
		return(0);	//	
	}
}

//	݂̍őMx擾
int CBandWidthMgr::GetCurrentRecvLimit(CIPAddress host)
{
	CSortArray<int,int>	list;

	//	T[oS
	int count = GetAllRecvConnectionCount();
	if(m_RecvMaxServerBandWidth != 0 && count != 0)
		list.Add(m_RecvMaxServerBandWidth / count);

	//	PzXg
	count = GetHostRecvConnectionCount(host);
	if(m_RecvMaxOneHostBandWidth != 0 && count != 0)
		list.Add(m_RecvMaxOneHostBandWidth / count);

	//	Pڑ
	if(m_RecvMaxOneConnectBandWidth != 0)
		list.Add(m_RecvMaxOneConnectBandWidth);

	
	if(list.GetSize())
	{
		//	Ƀ\[g
		list.Sort();

		return(list[0]);
	}
	else
	{
		return(0);	//	
	}
}

//	]ǉ
void CBandWidthMgr::AddTrans(__int64 send,__int64 recv)
{
	SCOPE_LOCK();

	CTime cur = CTime::GetCurrentTime();
	m_curSend += send;
	m_curRecv += recv;
	m_allSend += send;
	m_allRecv += recv;
	m_allCount++;

	m_trans1h.Add(COneTrans(cur,send,recv));
}

//	ߋPԂ̓]ʎ擾
__int64 CBandWidthMgr::GetSend1h()
{
	SCOPE_LOCK();

	return(m_curSend);
}

//	ߋPԂ̓]ʎ擾
__int64 CBandWidthMgr::GetRecv1h()
{
	SCOPE_LOCK();

	return(m_curRecv);
}

//	ߋPԂ̐ڑ
int CBandWidthMgr::GetCount1h()
{
	SCOPE_LOCK();

	UpdateTransInfo();
	return((int)m_trans1h.GetSize());
}

//	NĂ̓]ʎ擾
__int64 CBandWidthMgr::GetAllSend()
{
	SCOPE_LOCK();

	return(m_allSend);
}

//	NĂ̓]ʎ擾
__int64 CBandWidthMgr::GetAllRecv()
{
	SCOPE_LOCK();

	return(m_allRecv);
}


//	NĂ̐ڑ
int CBandWidthMgr::GetAllCount()
{
	SCOPE_LOCK();

	return(m_allCount);
}

//	]XV
void CBandWidthMgr::UpdateTransInfo()
{
	SCOPE_LOCK();

	CTime cur = CTime::GetCurrentTime();
	for(int i=0;i<m_trans1h.GetSize();i++)
	{
		if(m_trans1h[i].m_time + CTimeSpan(0,1,0,0) < cur)
		{
			m_curSend -= m_trans1h[i].m_send;
			m_curRecv -= m_trans1h[i].m_recv;
			m_trans1h.RemoveAt(i);
		}
		else
			break;
	}
}


//	
CBandWidthReference::CBandWidthReference(CBandWidthMgr *mgr,CIPAddress host,CString code)
{
	m_mgr = mgr;
	m_hostAddress = host;
	m_connectionCode = code;
	m_sendLimit = 0;
	m_recvLimit = 0;

	m_mgr->AddConnection(host,code,m_sendLimit,m_recvLimit);
}

//	폜
CBandWidthReference::~CBandWidthReference()
{
	m_mgr->DelConnection(m_connectionCode);
}

//	M~bg̐ݒ
void CBandWidthReference::SetSendLimit(int enable)
{
	m_sendLimit = enable;
	m_mgr->AddConnection(m_hostAddress,m_connectionCode,m_sendLimit,m_recvLimit);
}

//	M~bg̐ݒ
void CBandWidthReference::SetRecvLimit(int enable)
{
	m_recvLimit = enable;
	m_mgr->AddConnection(m_hostAddress,m_connectionCode,m_sendLimit,m_recvLimit);
}

//	~bg̃`FbN
int CBandWidthReference::IsLimitOver()
{
	if(m_mgr->GetHostConnectionCount(m_hostAddress) > m_mgr->m_MaxOneHostConnect && m_mgr->m_MaxOneHostConnect != 0)
		return(1);
	return(0);
}

//	Mōx̎擾
int CBandWidthReference::GetCurrentSendLimit()
{
	if(m_sendLimit)
		return(m_mgr->GetCurrentSendLimit(m_hostAddress));
	else
		return(0);
}

//	Mōx̎擾
int CBandWidthReference::GetCurrentRecvLimit()
{
	if(m_recvLimit)
		return(m_mgr->GetCurrentRecvLimit(m_hostAddress));
	else
		return(0);
}


//	
CBandWidthLimit::CBandWidthLimit()
{
	m_prevTick = GetTickCount();
	m_curTime = 0;
	m_curTrans = 0;
}


//	x̃EFCgԂ擾
int CBandWidthLimit::GetWaitTick(int limitBytePerSec,int transByte)
{
	//	ϐ
	int	subTick = GetTickCount() - m_prevTick;
	m_transByte = transByte;

	//	Ȃ
	if(limitBytePerSec == 0)
		return(0);

	//	Ăꍇ̎
	int limitedTick = 	transByte * 1000 / limitBytePerSec;

	if(subTick < limitedTick)
		return(limitedTick - subTick);
	else
		return(0);
}


//	݂̑x擾
int CBandWidthLimit::GetCurSpeed()
{
	double curTrans = m_curTrans, curTime = m_curTime;
	double speed = curTrans * 1000.0 / curTime;

	return((int)speed);
}

//	P̓]I
void CBandWidthLimit::OneTracsEnd()
{
	DWORD	curTick = GetTickCount();
	int tick = curTick - m_prevTick;
	m_prevTick = curTick;
	
	m_curTime += tick;
	m_curTrans += m_transByte;
	m_transLog.Add(CTrans(m_transByte,tick));

	//	20񕪈ȏ͍폜
	if(m_transLog.GetSize() > 20)
	{
		m_curTime -= m_transLog[0].m_time;

		m_curTrans -= m_transLog[0].m_size;
		m_transLog.RemoveAt(0);
	}

}
