#pragma once

#include "SortArray.h"
#include "confignode.h"
#include "configaccess.h"
#include "buffer.h"


class CConfig
{
protected:
	CCriticalSection	m_scopeLock;

public:
	CConfig(void);
	CConfig(CConfig &other);
	~CConfig(void);
	void SetConfig(CString path, CString data);								//	f[^̐ݒ
	CString GetConfig(CString path, CString defaultData,int noCase=FALSE);	//	f[^̎擾
	int GetAllKey(CString path,CStringArray &list);							//	SẴL[擾
	int GetAllSubNode(CString path,CStringArray &list);						//	SẴTum[h擾
	CConfigAccess GetAccess(CString path);									//	ANZXNX擾
	CConfigAccess GetCleanAccess(CString path);								//	ANZXNX擾ƃNA
	void Clear(CString path);												//	NA
	void Copy(CString destPath, CString srcPath, CConfig* srcConfig=NULL);	//	Rs[
	CString	ToNodePath(CString path);										//	m[hpXɕύX
	void DeleteNode(CString path);											//	m[h폜
	void DeleteKey(CString path);											//	L[폜
	int GetKeyCount(CString path);											//	SẴL[擾
	int GetSubNodeCount(CString path);										//	SẴTum[h𐔎擾
	CString GetKeySwapString(CString path,CString str,
							 CString noData="",CConfigSwapBase *swap=NULL);	//	L[Œu擾
	void Lock() {m_scopeLock.Lock();};
	void Unlock() {m_scopeLock.Unlock();};
	CCriticalSection *GetCriticalSection();

	void CopyAllKeys(CString path,CSortArray<CConfigNode::CConfigKey,CConfigNode::CConfigKey&> &keyData);	//	SẴL[Rs[


	int SaveToFile(CString path,CString savePath = "");						//	XMLt@C֏o
	int LoadFromFile(CString path);											//	XML胍[h

	CString ToXMLString(CString savePath = "");								//	XML֏o
	int FromXMLString(CString xml);											//	XML񂩂琶
	
	CString	ToString(CString savePath = "");								//	f[^
	int FromString(CString load);											//	f[^
	CString GetNextNode(char **buf);

	void EnableAutoSwap(CConfigSwapBase *swap);

private:
	CConfigSwapBase	*m_swap;
	CConfigNode	m_tree;

	void Copy(CConfigNode *dest, CString srcPath);							//	Rs[
};

//	NeBJZNV
#define	CONFIG_LOCK(x)\
	CSingleLock	__configLock(x.GetCriticalSection());\
	__configLock.Lock();

