#pragma once

#include "ConfigNode.h"

class CConfig;
class CConfigAccess
{
public:
	CConfigAccess();
	CConfigAccess(CConfig *root,CString path="");
	~CConfigAccess(void);

	void SetConfig(CString key, CString data);								//	f[^̐ݒ
	void SetConfig(CString key, int data);									//	f[^̐ݒ
	void SetConfig(CString key, UINT data);									//	f[^̐ݒ
	void SetConfig(CString key, __int64 data);								//	f[^̐ݒ

	CString GetConfig(CString key, CString defaultData,int noCase=FALSE);	//	f[^̎擾
	int GetConfig(CString key, int defaultData,int noCase=FALSE);			//	f[^̎擾
	UINT GetConfig(CString key, UINT defaultData,int noCase=FALSE);			//	f[^̎擾
	__int64 GetConfig(CString key, __int64 defaultData,int noCase=FALSE);	//	f[^̎擾


	int GetAllKey(CStringArray &list);										//	SẴL[擾
	int GetAllSubNode(CStringArray &list);									//	SẴTum[h擾
	CConfigAccess GetAccess(CString subPath);								//	ANZXNX擾
	CConfig * GetRoot();													//	CConfig擾
	void Clear();															//	NA
	void DeleteNode(CString name);											//	m[h폜
	void DeleteKey(CString name);											//	L[폜
	void Copy(CConfigAccess &other);										//	
	int GetKeyCount();														//	SẴL[擾
	int GetSubNodeCount();													//	SẴTum[h𐔎擾
	CString GetKeySwapString(CString str,CString noData="",
							 CConfigSwapBase *swap=NULL);					//	L[Œu擾

	void CopyAllKeys(CSortArray<CConfigNode::CConfigKey,CConfigNode::CConfigKey&> &keyData);	//	SẴL[Rs[

private:
	CString		m_path;
	CConfig		*m_root;

};

//	Config̃bN
class CConfigLock
{
public:
	CConfigLock(CConfigAccess *access);
	virtual ~CConfigLock();

private:
	CConfig		*m_root;
};

//	bN
#define	LOCK_CONFIG(config)\
	CConfigLock	__configLock(&config);
