#pragma once
#include "SortArray.h"
#import <msxml.dll>
#include "buffer.h"

//	us߂̃x[XNX
class CConfigSwapBase
{
public:
	CConfigSwapBase();
	virtual ~CConfigSwapBase();

	virtual CString SwapString(CString key,CString data) = 0;
	CString _SwapString(CString key,CString data);
	void SetNextSwap(CConfigSwapBase *next)	{ m_next = next; };

	CConfigSwapBase	*m_next;
};

class CConfigNode
{
public:
	//	f[^ێNX
	class CConfigKey
	{
	public:
		CString	m_key;
		CString	m_data;

		CConfigKey() {};
		CConfigKey(CString key,CString data) {m_key = key;m_data = data;};
	};

public:
	CConfigNode(void);
	~CConfigNode(void);

	void SetConfig(CString path, CString data);																//	RtBOf[^̐ݒ
	CString GetConfig(CString path, CString defaultData,CConfigSwapBase *swap=NULL,int noCase=FALSE);		//	RtBOf[^擾
	void SaveToXml(MSXML::IXMLDOMDocumentPtr doc,MSXML::IXMLDOMElementPtr element,CString indent="\n\t");	//	XML֕ۑ
	void LoadFromXml(MSXML::IXMLDOMDocumentPtr doc,MSXML::IXMLDOMNodePtr cur);			//	XML烍[h
	void Clear(void);																	//	SăNA
	int GetAllKey(CStringArray &list);													//	SẴL[擾
	int GetAllSubNode(CStringArray &list);												//	SẴTum[h擾
	CConfigNode *GetSubNode(CString path, CString &key);								//	̉z̃m[h擾
	void DeleteNode(CString name);														//	m[h폜
	void DeleteKey(CString name);														//	L[폜
	int GetKeyCount();																	//	SẴL[擾
	int GetSubNodeCount();																//	SẴTum[h𐔎擾
	CString GetKeySwapString(CString str,CString noData,CConfigSwapBase *swap=NULL);	//	L[Œu擾
	void ToString(CBuffer &buf);
	int FromString(char **ptr);

	void CopyAllKeys(CSortArray<CConfigKey,CConfigKey&> &keyData);						//	SẴL[Rs[

	CString	m_name;																		//	m[h

protected:
	int ParsePath(CString path, CString & topPath, CString & subPath);					//	pX̉
	int GetKeyIndex(CString key,int noCase);											//	̃L[
	int GetSubNodeIndex(CString name);													//	Tum[h

	CSortArray<CConfigNode,CConfigNode&>	m_subNode;									//	TuL[
	CSortArray<CConfigKey,CConfigKey&>		m_curData;									//	̃f[^

	void AddStartNode(CBuffer &buf);
	void AddEndNode(CBuffer &buf);
	void AddLeaf(CBuffer &buf,CString &key,CString &data);
	void AddOneText(CBuffer &buf,CString &str);

	CString GetOneText(char **ptr);

public:
	enum
	{
		START_NODE =	'S',
		END_NODE =		'E',
		LEAF =			'L',
		END =			0,
	};
};



//	us߂̃eLXgNX
class CConfigTextSwap : public CConfigSwapBase
{
public:
	void AddSwap(CString oldStr,CString newStr);
	virtual CString SwapString(CString key,CString data);

	CStringArray	oldArray;
	CStringArray	newArray;
};