#pragma once

#include "Buffer.h"
#include "Config.h"
#include "server.h"


class CResponse
{
public:
	CResponse(CServer *server,CConfigAccess context);
	virtual ~CResponse(void);

	virtual void PreCreateResponse() = 0;				//	1:X|X		
	virtual void SetNextData(CBuffer &data) = 0;		//	2:Mf[^̐ݒ(JԂ)
	virtual void CreateResponse() = 0;					//	3:X|X̐
	virtual __int64 GetResponseSize() = 0;				//	4:X|XTCY̎擾
	virtual CConfigAccess GetResponseInfo();			//	5:X|X擾
	virtual int GetNextData(CBuffer &data) = 0;			//	6:X|X̎擾

	void SetResponseCode(int code);
	static CString GetHTTPResponseString(int code);		//	X|X擾

public:
	CConfigAccess	m_context;
	CConfigAccess	m_setting;				//!<	ݒ
	CConfigAccess	m_serverInfo;			//!<	T[o̈
	CConfigAccess	m_requestInfo;			//!<	NGXg
	CConfigAccess	m_requestOptions;		//!<	NGXgIvV
	CConfigAccess	m_responseInfo;			//!<	X|X
	CConfigAccess	m_responseOptions;		//!<	X|XIvV
	CServer			*m_server;

private:
	void SetupDefaultResponse();
};
