#include "StdAfx.h"
#include "ssiparser.h"

CSSIParser::CSSIParser(CConnectionInterrupt interrupt)
: m_interrupt(interrupt)
{
}

CSSIParser::~CSSIParser(void)
{
}

//	ACeɃANZX
CSSIParserItem &CSSIParser::operator[](int index)
{
	return(m_tags[index]);
}

//	^O̎擾
int CSSIParser::GetTagCount()
{
	return((int)m_tags.GetSize());
}

//	t@C̃[h
CString CSSIParser::LoadFile(CString path)
{
	CString	ret;

	FILE *in = fopen(path,"rb");
	if(in != NULL)
	{
		fseek(in,0,SEEK_END);
		int len = ftell(in);
		fseek(in,0,SEEK_SET);

		int readed = (int)fread(ret.GetBuffer(len + 1),1,len,in);
		ret.ReleaseBufferSetLength(readed);
		fclose(in);

		return(ret);
	}
	return("");
}

//	SSI^Ǒ
int CSSIParser::ParseFile(CString path)
{
	m_html = LoadFile(path);
	if(m_html.IsEmpty())
		return(-1);

	int	counter = 0;
	int	currentIndex = 0;
	int prevIndex = 0;
	CSSIParserItem	item;

	while(TRUE)
	{
		int index = m_html.Find("<!--#",currentIndex);
		if(index == -1)
			break;

		int	index2 = m_html.Find("-->",index + 5);
		if(index2 == -1)
			break;

		//	ʒuXV
		prevIndex = currentIndex;
		currentIndex = index2 + 3;

		//	O܂łHTML؂o
		item.m_prevHtml = m_html.Mid(prevIndex,index - prevIndex);

		//	^O̒g؂o
		CString	tag = m_html.Mid(index + 5,index2 - index - 5);

		//	^O
		index = tag.Find(" ");
		if(index == -1)
			continue;

		//	^O
		item.m_tagName = tag.Mid(0,index);
		item.m_tagData = tag.Mid(index + 1);

		item.m_tagName.Trim();
		item.m_tagData.Trim();
		item.m_tagName = item.m_tagName.MakeLower();

		index = item.m_tagData.Find("=");
		if(index != -1)
		{
			item.m_dataKey = item.m_tagData.Left(index);
			item.m_dataData = item.m_tagData.Mid(index + 1);

			item.m_dataKey.Trim("\"");
			item.m_dataData.Trim("\"");
			item.m_dataKey = item.m_dataKey.MakeLower();
		}
		else
		{
			item.m_dataKey = "";
			item.m_dataData = "";
		}

		//	ǉ
		m_tags.Add(item);


		//	荞݃`FbN
		counter ++;
		if(counter > 1000)
		{
			counter = 0;
			if(m_interrupt.IsInterrupt())
				return(-1);
		}
	}

	//	Ōɋ̃^Oǉ
	item.m_tagName = "";
	item.m_tagData = "";
	item.m_dataKey = "";
	item.m_dataData = "";
	item.m_prevHtml = m_html.Mid(currentIndex);
	m_tags.Add(item);

	return(0);
}
