#include "StdAfx.h"
#include "systemservice.h"
#include "04WebServer.h"
#include "Registry04.h"
#include "EventLog.h"

#define	SERVICE_NAME	"04WebServer"


CSystemService::CSystemService(void)
{
	m_wantStop = 0;
}

CSystemService::~CSystemService(void)
{
}


//	T[rXsJn
int CSystemService::RunService()
{
	StartThread();

	//	STACOM̂߂ɃbZ[W[v܂킷
	MSG msg;
	while (m_wantStop == 0)
	{
		if(::PeekMessage(&msg, 0, 0, 0,PM_REMOVE))
		{
			if(msg.message == WM_QUIT)
				break;

			::TranslateMessage(&msg);
			::DispatchMessage(&msg);
		}
		else
			Sleep(50);
	}
	return(0);
}


//	T[rXpXbh
void CSystemService::ThreadMain()
{
	//	T[rXo^
	SERVICE_TABLE_ENTRY	serviceTable[] = {
	{ SERVICE_NAME, _ServiceMain},
	{ NULL,			 NULL		}};

	::StartServiceCtrlDispatcher(serviceTable);

	//	T[rX~܂łɂ͗Ȃ͂
}


//	T[rXC
void WINAPI CSystemService::ServiceMain()
{
	//	܂́AT[rXnhݒ肷
	m_serviceHandle = ::RegisterServiceCtrlHandlerEx(SERVICE_NAME,_HandlerEx,(PVOID)this);

	//	COM
	CoInitialize(NULL);

	//	T[o[sJn
	if(GET_APP()->StartServer())
		WriteSystemLog(MSG_ERROR,GET_APP()->GetServerErrorInfo(),1);	//	G[񍐁AT[rX͋NȂƁAݒłȂ
	else
		WriteSystemLog(MSG_START);										//	NO

	//	SCMɃT[osJnʒm
	SetServiceStatus(SERVICE_RUNNING);
	
	//	~v܂ŁA[v
	while (m_wantStop == 0)
			Sleep(50);

	//	I
	GET_APP()->StopServer();
	
	//	COMI
	CoUninitialize();

	//	Iʒm
	SetServiceStatus(SERVICE_STOPPED);

	//	IO
	WriteSystemLog(MSG_STOP);
}


//	T[rXRg[nh
DWORD CSystemService::HandlerEx(DWORD dwControl,DWORD dwEventType,PVOID pvEventData,PVOID pvContext)
{
	switch(dwControl)
	{
		//	~v
		case SERVICE_CONTROL_STOP:
		case SERVICE_CONTROL_SHUTDOWN:
			m_wantStop = 1;
			SetServiceStatus(SERVICE_STOP_PENDING,0,0);
			return(NO_ERROR);
	};

	return(ERROR_CALL_NOT_IMPLEMENTED);
}


//	T[rXXe[^XXV
void CSystemService::SetServiceStatus(DWORD dwCurrentStat,DWORD error,DWORD dwCheckPoint,DWORD dwWaitHint)
{
	SERVICE_STATUS	status;
	
	status.dwServiceType				= SERVICE_WIN32_OWN_PROCESS;
	status.dwCurrentState				= dwCurrentStat;
	status.dwControlsAccepted			= SERVICE_ACCEPT_SHUTDOWN | SERVICE_ACCEPT_STOP;
	status.dwWaitHint					= dwWaitHint;
	status.dwCheckPoint					= dwCheckPoint;

	if(error)
	{
		status.dwWin32ExitCode				= ERROR_SERVICE_SPECIFIC_ERROR ;
		status.dwServiceSpecificExitCode	= error;
	}
	else
	{
		status.dwWin32ExitCode				= NO_ERROR;
		status.dwServiceSpecificExitCode	= 0;
	}


	::SetServiceStatus(m_serviceHandle,&status);
}


//////////////////////////////////////////////////////////////////////////////////////////////////
//	֐|C^p
//////////////////////////////////////////////////////////////////////////////////////////////////
//	T[rX{(Ăяô)
void WINAPI CSystemService::_ServiceMain(DWORD dwArgc,PSTR *pszArgv)
{
	GET_APP()->m_serviceContext.ServiceMain();
}

//	T[rXRg[nh(Ăяô)
DWORD WINAPI CSystemService::_HandlerEx(DWORD dwControl,DWORD dwEventType,PVOID pvEventData,PVOID pvContext)
{
	return(((CSystemService*)pvContext)->HandlerEx(dwControl,dwEventType,pvEventData,pvContext));
}


//////////////////////////////////////////////////////////////////////////////////////////////////
//	T[rX[eBeB
//////////////////////////////////////////////////////////////////////////////////////////////////
//	T[rX̒ǉ
int CSystemService::AddToService()
{
	SC_HANDLE	scm = ::OpenSCManager(NULL,SERVICES_ACTIVE_DATABASE,GENERIC_WRITE);
	if(scm == NULL)
		return(-1);

	CString	appPath;
	::GetModuleFileName(NULL,appPath.GetBuffer(_MAX_PATH+1),_MAX_PATH);
	appPath.ReleaseBuffer();

	//	Xy[Xr
	if(appPath.Find(" "))
		appPath =  "\"" + appPath + "\"";
	appPath += "/Service";

	SC_HANDLE	add =	::CreateService(
										scm,
										SERVICE_NAME,
										"04WebServer Service",
										0,							//	T[rX̒ǉ̂
										SERVICE_WIN32_OWN_PROCESS,	//	1̃T[rXvZX
										SERVICE_AUTO_START	,		//	s
										SERVICE_ERROR_NORMAL,		//	G[L^
										appPath,					//	pX
										NULL,						//	VXe̍ŌɃ[h
										NULL,
										NULL,						//	ˑ֌WȂ
										NULL,						//	[U[Ȃ
										NULL);						//	V


	CloseServiceHandle(add);
	CloseServiceHandle(scm);

	return(0);
}

//	T[rX̍폜
int CSystemService::DelFromService()
{
	//	܂͒~

	SC_HANDLE	scm = ::OpenSCManager(NULL,SERVICES_ACTIVE_DATABASE,SC_MANAGER_CONNECT);
	if(scm == NULL)
		return(-1);

	SC_HANDLE	service = ::OpenService(scm,SERVICE_NAME,DELETE | SERVICE_STOP);
	if(service == NULL)
	{
		CloseServiceHandle(scm);
		return(0);	//	ۂ
	}

	//	~
	SERVICE_STATUS stat;
	QueryServiceStatus(service,&stat);
	if(stat.dwCurrentState != SERVICE_STOPPED)
	{
		ControlService(service,SERVICE_CONTROL_STOP,&stat);
	}

	//	폜
	if(!::DeleteService(service))
	{
		CloseServiceHandle(service);
		CloseServiceHandle(scm);
		return(-1);
	}

	CloseServiceHandle(service);
	CloseServiceHandle(scm);

	return(0);
}

//	CxgO
void CSystemService::WriteSystemLog(int event,CString info,int isError)
{
	CRegistry04	reg;
	reg.Open(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\Eventlog\\Application\\"SERVICE_NAME"\\");
	reg.SetValue("EventMessageFile",GET_APP()->GetAppPath(0));
	reg.SetValue("TypesSupported",(DWORD)EVENTLOG_INFORMATION_TYPE | EVENTLOG_ERROR_TYPE);
	reg.Close();


	HANDLE	eventSorce = ::RegisterEventSource(NULL,SERVICE_NAME);
	if(eventSorce == NULL)
		return;

	LPCSTR	string;
	int		stringCount = 0;

	if(!info.IsEmpty())
	{
		string = info.GetBuffer(0);
		stringCount = 1;
	}

	if(isError == 0)
		::ReportEvent(eventSorce,EVENTLOG_INFORMATION_TYPE,0,event,NULL,stringCount,0,&string,NULL);
	else
		::ReportEvent(eventSorce,EVENTLOG_ERROR_TYPE      ,0,event,NULL,stringCount,0,&string,NULL);

	::CloseHandle(eventSorce);
}

