// 04WebServer.cpp : AvP[ṼNX`܂B
//

#include "stdafx.h"
#include "04WebServer.h"
#include "04WebServerDlg.h"
#include <initguid.h>
#include "04WebServer_i.c"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMy04WebServerApp


class CMy04WebServerModule :
	public CAtlMfcModule
{
public:
	DECLARE_LIBID(LIBID_My04WebServerLib);
	DECLARE_REGISTRY_APPID_RESOURCEID(IDR_04WEBSERVER_APP, "{53BED338-262D-477B-A927-53861BC1E214}");};

CMy04WebServerModule _AtlModule;

BEGIN_MESSAGE_MAP(CMy04WebServerApp, CWinApp)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()


// CMy04WebServerApp RXgNV

CMy04WebServerApp::CMy04WebServerApp()
{
	m_comRegisterd = 0;
	m_server = NULL;
	m_mutex = NULL;
	m_serviceMode = 0;
	m_serverStatus = "T[o͒~łB";
	m_exitCode = 0;
}


// B CMy04WebServerApp IuWFNgłB

CMy04WebServerApp theApp;


// CMy04WebServerApp 

BOOL CMy04WebServerApp::InitInstance()
{
	SetServerSecurityDescripter();

	//	COM
	CoInitialize(NULL);
	CoInitializeSecurity(NULL, -1, NULL, NULL, RPC_C_AUTHN_LEVEL_PKT, RPC_C_IMP_LEVEL_IMPERSONATE, NULL, EOAC_NONE, NULL);

	//	낢돉
	InitCommonControls();
	CWinApp::InitInstance();
	AfxEnableControlContainer();


	// R}hC
	CString				cmdString = GetCommandOption();
	CCommandLineInfo	cmdInfo;
	ParseCommandLine(cmdInfo);

	if(cmdString.IsEmpty())
	{
		//	wȂȂ̂ŁARg[[`
		CString path = GetAppPath() + "ServerController.exe";
		::ShellExecute(0, _T("open"), path.GetBuffer(0), 0, 0, SW_SHOWNORMAL);
	}
	else if(DoRegister(cmdString))
	{
		//	WXgo^Ȃ̂ŁAI
		return FALSE;
	}
	
	//	dN`FbN
	if(CheckOther())
	{
		AfxMessageBox("T[o͂łɋNłAdNł܂B",MB_ICONSTOP);
		return FALSE;
	}


	//	IvVɂĔ
	if(cmdString.CompareNoCase("/Service") == 0)
	{
		//	T[rXN

		//	COMo^
		if(RegisteCOMClassObject())
			return FALSE;

		m_serviceMode = 1;
		m_serviceContext.RunService();
		return FALSE;
	}
	else if(cmdString.CompareNoCase("/Debug") == 0)
	{
		//	fobO[h

		//	COMo^
		if(RegisteCOMClassObject())
			AfxMessageBox("COM̓o^Ɏs܂ACOMIuWFNgT[rXo^̂悤łB");

		//	fobOsH
		CMy04WebServerDlg dlg;
		m_pMainWnd = &dlg;
		dlg.DoModal();

		return FALSE;
	}
	else
	{
		//	AvP[V[h

		//	COMo^
		if(RegisteCOMClassObject())
			return FALSE;

		return TRUE;
	}
}

//	e탌WXg
int CMy04WebServerApp::DoRegister(CString command)
{
	if(command.CompareNoCase("/UnInstall") == 0)
	{
		//	Rg[~
		KillAllController();

		// Sč폜
		RegisterApp(FALSE);
		RegisterService(FALSE);
		return TRUE;
	}
	else if(command.CompareNoCase("/InstallApp") == 0)
	{
		// AvP[V[hœo^
		RegisterApp(TRUE);
		return TRUE;
	}
	else if (command.CompareNoCase("/InstallService") == 0)
	{
		// AvP[V[hœo^
		RegisterService(TRUE);
		return TRUE;
	}
	else if(command.CompareNoCase("/UnInstallApp") == 0)
	{
		//	Rg[~
		KillAllController();

		// AvP[V[h폜
		RegisterApp(FALSE);
		return TRUE;
	}
	else if (command.CompareNoCase("/UnInstallService") == 0)
	{
		//	Rg[~
		KillAllController();

		// T[rX[h폜
		RegisterService(FALSE);
		return TRUE;
	}
	else if (command.CompareNoCase("/IsRunning") == 0)
	{
		// so
		m_exitCode = CheckOther();
		return TRUE;
	}
	return FALSE;
}



//	W[pX擾
CString CMy04WebServerApp::GetAppPath(int directoryPath)
{
	char	s[MAX_PATH+1];
	DWORD len = GetModuleFileName(NULL, s, MAX_PATH);

	if(directoryPath)
	{
		while ( s[len--]!='\\' && len!=0 )
			;
		s[len+2] = '\0';        // }[NŏI点
	}

	return(s);
}

//	I
int CMy04WebServerApp::ExitInstance()
{
	//	Ô߁A~
	StopServer();

	//	COM폜
	RemoveCOMClassObject();

	//	dNtO
	if(m_mutex)
		::CloseHandle(m_mutex);

	CoUninitialize();

	CWinApp::ExitInstance();
	return m_exitCode;
}

//	T[oN܂
int CMy04WebServerApp::StartServer()
{
	SCOPE_LOCK();

	//	Ƃ肠A~
	StopServer();

	try
	{
		if(m_server == NULL)
			m_server = new CServer();

		m_serverStatus = "T[o͐ɍ쓮łB";
	}
	catch(CServerException e)
	{
		StopServer();
		m_serverStatus = e.m_info;
		return(-1);
	}

	return(0);
}

//	~
int CMy04WebServerApp::StopServer()
{
	SCOPE_LOCK();

	if(m_server != NULL)
		delete m_server;
	m_server = NULL;

	m_serverStatus = "T[o͒~łB";

	return(0);
}

//	G[擾
CString CMy04WebServerApp::GetServerErrorInfo()
{
	SCOPE_LOCK();

	return(m_serverStatus);
}

//	T[os擾
int CMy04WebServerApp::ServerRunning()
{
	SCOPE_LOCK();

	if(m_server)
		return(TRUE);
	else
		return(FALSE);
}

//	T[o[擾
CString CMy04WebServerApp::GetServerInfoXML()
{
	SCOPE_LOCK();

	if(m_server)
	{
		CConfig	copy(m_server->m_infoRoot);
		return(copy.ToXMLString());
	}
	else
		return("");
}

//	T[o[ݒ擾
CString CMy04WebServerApp::GetServerSettingXML()
{
	SCOPE_LOCK();

	if(m_server)
	{
		CConfig	copy(m_server->m_settingRoot);
		return(copy.ToXMLString());
	}
	else
		return("");
}

//	T[o[ݒ擾
CString CMy04WebServerApp::GetServerContextXML()
{
	SCOPE_LOCK();

	if(m_server)
	{
		CConfig	copy(m_server->m_context);
		return(copy.ToXMLString());
	}
	else
		return("");
}

//	T[o[擾
CString CMy04WebServerApp::GetServerInfoString()
{
	SCOPE_LOCK();

	if(m_server)
	{
		CConfig	copy(m_server->m_infoRoot);
		return(copy.ToString());
	}
	else
		return("");
}

//	T[o[ݒ擾
CString CMy04WebServerApp::GetServerSettingString()
{
	SCOPE_LOCK();

	if(m_server)
	{
		CConfig	copy(m_server->m_settingRoot);
		return(copy.ToString());
	}
	else
		return("");
}

//	T[o[ݒ擾
CString CMy04WebServerApp::GetServerContextString()
{
	SCOPE_LOCK();

	if(m_server)
	{
		CConfig	copy(m_server->m_context);
		return(copy.ToString());
	}
	else
		return("");
}

//	T[o[Xe[^Xݒ
void CMy04WebServerApp::SetServerStatus(CString stat)
{
	SCOPE_LOCK();

	m_serverStatus = stat;
}

//	ڑ̎擾
int CMy04WebServerApp::GetConnectCount()
{
	SCOPE_LOCK();

	if(m_server)
	{
		return(m_server->GetConnectCount());
	}
	else
		return(0);
}

//	T[rX[h
int CMy04WebServerApp::IsService()
{
	return(m_serviceMode);
}

//	dÑ`FbN
int CMy04WebServerApp::CheckOther()
{
	m_mutex = ::CreateMutex( /*&sa*/NULL, FALSE, "04WebServer" );
	if( ::GetLastError() == ERROR_ALREADY_EXISTS )
	{
		::CloseHandle(m_mutex);
		m_mutex = NULL;
		return TRUE;
	}
	return FALSE;
}

//	T[ogpZLeBLqq擾
void CMy04WebServerApp::SetServerSecurityDescripter()
{

	//	DACL폜
	TOKEN_DEFAULT_DACL	dacl;
	dacl.DefaultDacl = NULL;

	HANDLE	token=NULL;
	::OpenProcessToken(GetCurrentProcess(),TOKEN_ADJUST_DEFAULT,&token);
	::SetTokenInformation(token,TokenDefaultDacl,&dacl,sizeof(TOKEN_DEFAULT_DACL ));
	::CloseHandle(token);
}

//	CoClasso^
int CMy04WebServerApp::RegisteCOMClassObject()
{
	//	COMIuWFNgo^
	if (FAILED(_AtlModule.RegisterClassObjects(CLSCTX_LOCAL_SERVER, REGCLS_MULTIPLEUSE)))
		return -1;
	m_comRegisterd = 1;

	return 0;
}

//	CoClass폜
void CMy04WebServerApp::RemoveCOMClassObject()
{
	if(m_comRegisterd)
		_AtlModule.RevokeClassObjects();
	m_comRegisterd = 0;
}

//	AvP[VƂēo^
void CMy04WebServerApp::RegisterApp(int reg)
{
	_ATL_REGMAP_ENTRY aMapEntries [] = \
	{ \
		{ OLESTR("APPID"), _AtlModule.GetAppId() }, \
		{ NULL, NULL } \
	}; \

	if(reg)
	{
		ATL::_pAtlModule->UpdateRegistryFromResource(IDR_04WEBSERVER_APP, TRUE, aMapEntries);
		_AtlModule.RegisterServer(TRUE);
	}
	else
	{
		ATL::_pAtlModule->UpdateRegistryFromResource(IDR_04WEBSERVER_APP, TRUE, aMapEntries);
		_AtlModule.UnregisterServer(TRUE);
	}
}

//	T[rXƂēo^
void CMy04WebServerApp::RegisterService(int reg)
{
	_ATL_REGMAP_ENTRY aMapEntries [] = \
	{ \
		{ OLESTR("APPID"), _AtlModule.GetAppId() }, \
		{ NULL, NULL } \
	}; \

	if(reg)
	{
		ATL::_pAtlModule->UpdateRegistryFromResource(IDR_04WEBSERVER_SERVICE, TRUE, aMapEntries);
		_AtlModule.RegisterServer(TRUE);
		if(CSystemService::AddToService())
		{
			AfxMessageBox("T[rX̒ǉɎs܂B",MB_ICONSTOP);
			m_exitCode = 0x100;
		}
	}
	else
	{
		ATL::_pAtlModule->UpdateRegistryFromResource(IDR_04WEBSERVER_SERVICE, TRUE, aMapEntries);
		_AtlModule.UnregisterServer(TRUE);
		if(CSystemService::DelFromService())
		{
			AfxMessageBox("T[rX̍폜Ɏs܂B",MB_ICONSTOP);
			m_exitCode = 0x100;
		}
	}
}

//	fobOO
void CMy04WebServerApp::WriteDebugLog(LPCTSTR lpszFormat, ...)
{
	//	WJ
	va_list argList;
	CString	str;
	va_start(argList, lpszFormat);
	str.FormatV(lpszFormat,argList);
	va_end(argList);

	FILE *text = fopen(GetAppPath() + "Debuglog.txt","at");

	fprintf(text,"%s\n",str);
	fclose(text);
}

//	R}hIvV擾
CString CMy04WebServerApp::GetCommandOption()
{
	CString	line = GetCommandLine();
	if(line.IsEmpty())
		line = m_lpCmdLine;

	int index = line.Find("/");
	if(index == -1)
	{
		index = line.Find("-");
		if(index == -1)
			return("");
	}

	return(line.Mid(index));
}

//	SẴRg[I
void CMy04WebServerApp::KillAllController()
{
	::PostMessage(HWND_BROADCAST,::RegisterWindowMessage(_T("04WebServer All Quit")),0,0);
}
