/*!
	2006/07/28 IPA#02091617 fix m_swap->swap
*/

#include "StdAfx.h"
#include "config.h"
#import <msxml.dll>
#include "configxml.h"

#define	APP_TYPE	"04WebServer"

//	NeBJZNV(^CAEgt)
#define	SCOPE_LOCK_CCONFIG()\
	CSingleLock	__scopeLock(&m_scopeLock);\
	__scopeLock.Lock();



CConfig::CConfig(void)
{
	m_tree.m_name = APP_TYPE;
	m_swap = NULL;
}

CConfig::CConfig(CConfig &other)
{
	//	SwapȊORs[
	m_tree = other.m_tree;
	m_swap = NULL;
}

CConfig::~CConfig(void)
{
	if(m_swap)
		delete m_swap;
	m_swap = NULL;
}


/*!
 *	ANZXNX̎擾
 *
 *	@param path	pX
 *	@return		CConfigAccess *
 */
CConfigAccess CConfig::GetAccess(CString path)
{
	return CConfigAccess(this,path);
}

/*!
 *	ANZXNX̎擾ƃNA
 *
 *	@param path	pX
 *	@return		CConfigAccess *
 */
CConfigAccess CConfig::GetCleanAccess(CString path)
{
	CConfigAccess ret = CConfigAccess(this,path);
	ret.Clear();
	return ret;
}

/*!
 *	f[^̐ݒ
 *
 *	@param path	pX
 *	@param data	ݒ肷f[^
 */
void CConfig::SetConfig(CString path, CString data)
{
	SCOPE_LOCK_CCONFIG();

	CString key;
	CConfigNode * node = m_tree.GetSubNode(path,key);

	node->SetConfig(key,data);
}


/*!
 *	f[^̎擾
 *
 *	@param path			pX
 *	@param noCase		啶̋
 *	@param defaultData	ftHg
 */
CString CConfig::GetConfig(CString path, CString defaultData,int noCase)
{
	SCOPE_LOCK_CCONFIG();

	CString key;
	CConfigNode * node = m_tree.GetSubNode(path,key);

	return(node->GetConfig(key,defaultData,m_swap,noCase));
}


/*!
 *	SẴL[擾
 *
 *	@param path	pX
 *	@param list	L[Xg
 *	@return		L[
 */
int CConfig::GetAllKey(CString path,CStringArray &list)
{
	SCOPE_LOCK_CCONFIG();

	path = ToNodePath(path);

	CString key;
	CConfigNode * node = m_tree.GetSubNode(path,key);

	return(node->GetAllKey(list));
}


/*!
 *	SẴTum[h擾
 *
 *	@param path	pX
 *	@param list	L[Xg
 *	@return		L[
 */
int CConfig::GetAllSubNode(CString path,CStringArray &list)
{
	SCOPE_LOCK_CCONFIG();

	path = ToNodePath(path);

	CString key;
	CConfigNode * node = m_tree.GetSubNode(path,key);

	return(node->GetAllSubNode(list));
}

/*!
 *	SẴL[擾
 *
 *	@param path	pX
 *	@return		L[
 */
int CConfig::GetKeyCount(CString path)
{
	SCOPE_LOCK_CCONFIG();

	path = ToNodePath(path);

	CString key;
	CConfigNode * node = m_tree.GetSubNode(path,key);

	return(node->GetKeyCount());
}


/*!
 *	SẴTum[h擾
 *
 *	@param path	pX
 *	@return		L[
 */
int CConfig::GetSubNodeCount(CString path)
{
	SCOPE_LOCK_CCONFIG();

	path = ToNodePath(path);

	CString key;
	CConfigNode * node = m_tree.GetSubNode(path,key);

	return(node->GetSubNodeCount());
}


/*!
 *	NA
 *
 *	@param path	pX
 */
void CConfig::Clear(CString path)
{
	SCOPE_LOCK_CCONFIG();

	path = ToNodePath(path);

	CString key;
	CConfigNode * node = m_tree.GetSubNode(path,key);

	node->Clear();
}

/*!
 *	m[h̍폜
 *
 *	@param path	pX
 */
void CConfig::DeleteNode(CString path)
{
	SCOPE_LOCK_CCONFIG();
	path = ToNodePath(path);
	path = path.Mid(0,path.GetLength()-2);

	if(path.IsEmpty())
	{
		m_tree.Clear();
	}
	else
	{
		CString key;
		CConfigNode * node = m_tree.GetSubNode(path,key);
		node->DeleteNode(key);
	}
}

/*!
 *	L[̍폜
 *
 *	@param path	pX
 */
void CConfig::DeleteKey(CString path)
{
	SCOPE_LOCK_CCONFIG();

	CString key;
	CConfigNode * node = m_tree.GetSubNode(path,key);
	node->DeleteKey(key);
}

/*!
 *	Rs[
 *
 *	@param destPath		Rs[pX
 *	@param srcPath		Rs[pX
 *	@param srcConfig	Rs[iȗj
 */
void CConfig::Copy(CString destPath, CString srcPath, CConfig* srcConfig)
{
	SCOPE_LOCK_CCONFIG();

	destPath = ToNodePath(destPath);
	srcPath = ToNodePath(srcPath);

	if(srcConfig==NULL)
		srcConfig = this;

	CString key;
	CConfigNode * dNode = m_tree.GetSubNode(destPath,key);
	srcConfig->Copy(dNode,srcPath);
}

/*!
 *	Rs[
 *
 *	@param dest			Rs[
 *	@param srcPath		Rs[pX
 */
void CConfig::Copy(CConfigNode *dest, CString srcPath)
{
	SCOPE_LOCK_CCONFIG();

	CString key;
	CConfigNode * sNode = m_tree.GetSubNode(srcPath,key);

	//	OȊORs[
	CString	name = dest->m_name;
	*dest = *sNode;
	dest->m_name = name;
}

/*!
 *	SẴL[Rs[
 *
 *	@param path			Rs[pX
 *	@param keyData		Rs[
 */
void CConfig::CopyAllKeys(CString path,CSortArray<CConfigNode::CConfigKey,CConfigNode::CConfigKey&> &keyData)
{
	SCOPE_LOCK_CCONFIG();

	CString key;
	CConfigNode * sNode = m_tree.GetSubNode(path,key);

	sNode->CopyAllKeys(keyData);
}

/*!
 *	XMLt@C֏o
 *
 *	@param path		t@CpX
 *	@param savePath	pX
 *	@return		0FA-1FG[
 */
int CConfig::SaveToFile(CString path,CString savePath)
{
	SCOPE_LOCK_CCONFIG();

	try
	{
		//	MSXML CX^X̐
		MSXML::IXMLDOMDocumentPtr pXMLDom(CLSID_DOMDocument);

		//	ProcessingInstruction ̒ǉ
		MSXML::IXMLDOMProcessingInstructionPtr pi;
		pi = pXMLDom->createProcessingInstruction("xml", "version='1.0'");
		pXMLDom->appendChild(pi);
		pi.Release();

		//	Rg̒ǉ
		MSXML::IXMLDOMCommentPtr pc;
		pc = pXMLDom->createComment(APP_TYPE" CConfig class.");
		pXMLDom->appendChild(pc);
		pc.Release();

		// [gǉ.
		MSXML::IXMLDOMElementPtr pe;
		pe = pXMLDom->createElement("CConfigClass");

		//	Agr[g
		MSXML::IXMLDOMAttributePtr pa;
		pa = pXMLDom->createAttribute("type");
		pa->value = APP_TYPE;
		pe->setAttributeNode(pa);
		pa.Release();

		//	f[^̕ۑ
		CString key;
		CConfigNode * node = m_tree.GetSubNode(savePath,key);
		node->SaveToXml(pXMLDom,pe);
		pe->appendChild(pXMLDom->createTextNode("\n"));

		pXMLDom->appendChild(pe);
		pe.Release();


		//	ۑ
		pXMLDom->save(_bstr_t(path));
		pXMLDom.Release();

		return(0);
	}
	catch(const _com_error& err)
	{
		TRACE("Error in [CConfig::SaveToFile]\nCOM Error %s\n",err.ErrorMessage());
		return(-1);
	}
}

//	XML֏o
CString CConfig::ToXMLString(CString savePath)
{
	SCOPE_LOCK_CCONFIG();

	try
	{
		//	MSXML CX^X̐
		MSXML::IXMLDOMDocumentPtr pXMLDom(CLSID_DOMDocument);

		//	ProcessingInstruction ̒ǉ
		MSXML::IXMLDOMProcessingInstructionPtr pi;
		pi = pXMLDom->createProcessingInstruction("xml", "version='1.0'");
		pXMLDom->appendChild(pi);
		pi.Release();

		//	Rg̒ǉ
		MSXML::IXMLDOMCommentPtr pc;
		pc = pXMLDom->createComment(APP_TYPE" CConfig class.");
		pXMLDom->appendChild(pc);
		pc.Release();

		// [gǉ.
		MSXML::IXMLDOMElementPtr pe;
		pe = pXMLDom->createElement("CConfigClass");

		//	Agr[g
		MSXML::IXMLDOMAttributePtr pa;
		pa = pXMLDom->createAttribute("type");
		pa->value = APP_TYPE;
		pe->setAttributeNode(pa);
		pa.Release();

		//	f[^̕ۑ
		CString key;
		CConfigNode * node = m_tree.GetSubNode(savePath,key);
		node->SaveToXml(pXMLDom,pe);
		pe->appendChild(pXMLDom->createTextNode("\n"));

		pXMLDom->appendChild(pe);
		pe.Release();


		//	ۑ
		CString ret = pXMLDom->xml;
		pXMLDom.Release();

		return(ret);
	}
	catch(const _com_error& err)
	{
		TRACE("Error in [CConfig::SaveToFile]\nCOM Error %s\n",err.ErrorMessage());
		return("");
	}
}


//	XML񂩂琶
int CConfig::FromXMLString(CString xml)
{
	SCOPE_LOCK_CCONFIG();

	//	NA
	m_tree.Clear();

	try
	{
		//	MSXML CX^X̐
		MSXML::IXMLDOMDocumentPtr pXMLDom(CLSID_DOMDocument);

		//	[h
		pXMLDom->loadXML(_bstr_t(xml));
		
		//	CConfigClass
		MSXML::IXMLDOMNodeListPtr rootList;
		rootList = pXMLDom->getElementsByTagName("CConfigClass");
		for(int i=0;i<rootList->length;i++)
		{
			MSXML::IXMLDOMNodePtr node = rootList->item[i];
			if(CConfigXml::GetAttrv(pXMLDom,node,"type") == APP_TYPE)
			{
				//	m[hXg擾
				MSXML::IXMLDOMNodeListPtr	nodeList = node->childNodes;

				if(nodeList->length)
				{
					//	[h
					if(nodeList->item[0]->nodeName == _bstr_t("Node"))
					{
						m_tree.LoadFromXml(pXMLDom,nodeList->item[0]);
						node.Release();
						break;
					}
				}
			}
			node.Release();
		}


		rootList.Release();
		pXMLDom.Release();

		return(0);
	}
	catch(const _com_error& err)
	{
		TRACE("Error in [CConfig::LoadFromFile]\nCOM Error %s\n",err.ErrorMessage());
		return(-1);
	}
}


/*!
 *	XMLt@C烍[h
 *
 *	@param path	pX
 *	@return		0FA-1FG[
 */
int CConfig::LoadFromFile(CString path)
{
	SCOPE_LOCK_CCONFIG();

	//	NA
	m_tree.Clear();

	try
	{
		//	MSXML CX^X̐
		MSXML::IXMLDOMDocumentPtr pXMLDom(CLSID_DOMDocument);

		//	[h
		pXMLDom->load(_bstr_t(path));
		
		//	CConfigClass
		MSXML::IXMLDOMNodeListPtr rootList;
		rootList = pXMLDom->getElementsByTagName("CConfigClass");
		for(int i=0;i<rootList->length;i++)
		{
			MSXML::IXMLDOMNodePtr node = rootList->item[i];
			if(CConfigXml::GetAttrv(pXMLDom,node,"type") == APP_TYPE)
			{
				//	m[hXg擾
				MSXML::IXMLDOMNodeListPtr	nodeList = node->childNodes;

				if(nodeList->length)
				{
					//	[h
					if(nodeList->item[0]->nodeName == _bstr_t("Node"))
					{
						m_tree.LoadFromXml(pXMLDom,nodeList->item[0]);
						node.Release();
						break;
					}
				}
			}
			node.Release();
		}


		rootList.Release();
		pXMLDom.Release();

		return(0);
	}
	catch(const _com_error& err)
	{
		TRACE("Error in [CConfig::LoadFromFile]\nCOM Error %s\n",err.ErrorMessage());
		return(-1);
	}
}


/*!
 *	m[hpXɕύX
 *
 *	@param path	pX
 *	@return		pX
 */
CString CConfig::ToNodePath(CString path)
{
	if(path.GetLength() >= 2)
	{
		if(path.Right(2) != "::")
			path += "::";
	}
	else
		path += "::";

	return path;
}


/*!
 *	L[Œu擾
 *
 *	@param path		pX
 *	@param str		
 *	@param noData	YȂȕu
 *	@return			
 */
CString CConfig::GetKeySwapString(CString path,CString str,CString noData,CConfigSwapBase *swap)
{
	SCOPE_LOCK_CCONFIG();

	CString key;
	CConfigNode * node = m_tree.GetSubNode(path,key);

	if(m_swap)
	{
		CConfigSwapBase *push = m_swap->m_next;

		m_swap->m_next = swap;
		CString	ret = node->GetKeySwapString(str,noData,m_swap);
		m_swap->m_next = push;

		return(ret);
	}
	else
	{
		return(node->GetKeySwapString(str,noData,swap));	//	# 2006/07/28 IPA#02091617 fix m_swap->swap
	}
}

/*!
 *	uR[obNݒ
 */
void CConfig::EnableAutoSwap(CConfigSwapBase *swap)
{
	if(m_swap)
		delete m_swap;
	m_swap = swap;
}

//	f[^ɕϊ
CString	CConfig::ToString(CString savePath)
{
	SCOPE_LOCK_CCONFIG();

	CBuffer	rawImage(0);

	//	f[^̕ۑ
	CString key;
	CConfigNode * node = m_tree.GetSubNode(savePath,key);
	node->ToString(rawImage);

	//	I
	rawImage += (char)0;

	return(rawImage);
}

//	f[^
int CConfig::FromString(CString load)
{
	SCOPE_LOCK_CCONFIG();

	m_tree.Clear();

	char *ptr = load.GetBuffer(0);

	CString	node = GetNextNode(&ptr);
	if(node.IsEmpty())
		return(-1);

	return(m_tree.FromString(&ptr));
}

//	m[h擾
CString CConfig::GetNextNode(char **buf)
{
	char code = **buf;
	(*buf)++;

	if(code == CConfigNode::START_NODE)
	{
		int escape=0;
		for(int i=0;;i++)
		{
			if((*buf)[i] == 0)
				return("");
			
			if((*buf)[i] == '\\')
			{
				if(escape == 0)
					escape = 1;
				else
					escape = 0;	//QA
			}
			else if((*buf)[i] == '0')
			{
				if(escape)
					break;
			}
			else
			{
				escape = 0;
			}
		}

		CString	ret;
		char *str = ret.GetBuffer(i + 1);
		memcpy(str,*buf,i-1);
		(*buf) += (i + 1);
		str[i-1] = 0;
		ret.ReleaseBuffer();
		ret.Replace("\\\\","\\");

		return(ret);
	}
	return("");
}

