/*!
 *	@(#)CConfigNode.cpp		1.00 2003/03/05
 *
 *	Copyright (c) 2003 Yuh
 */

#include "StdAfx.h"
#include "confignode.h"
#include "configxml.h"

CConfigNode::CConfigNode(void)
{
}

CConfigNode::~CConfigNode(void)
{
}



/*!
 *	̃Tum[h擾
 *
 *	@param path	pX
 *	@param key	Ō̃L[
 *	@return		Tum[h
 */
CConfigNode *CConfigNode::GetSubNode(CString path, CString &key)
{
	CString	topPath,subPath;
	if(ParsePath(path,topPath,subPath) == 0)
	{
		//	
		key = subPath;
		return this;
	}
	else
	{
		//	ǉ
		int	index = GetSubNodeIndex(topPath);
		if(index == -1)
		{
			index = (int)m_subNode.GetSize();
			m_subNode.Add(CConfigNode());
			m_subNode[index].m_name = topPath;
		}

		//	ʂ
		return(m_subNode[index].GetSubNode(subPath,key));
	}
}


/*!
 *	f[^̐ݒ
 *
 *	@param key	L[
 *	@param data	ݒ肷f[^
 */
void CConfigNode::SetConfig(CString key, CString data)
{
	int	index = GetKeyIndex(key,FALSE);
	if(index == -1)
	{
		m_curData.Add(CConfigKey(key,data));
	}
	else
	{
		m_curData[index].m_data = data;
	}
}

/*!
 *	f[^̎擾
 *
 *	@param key			L[
 *	@param noCase		啶ʂȂ
 *	@param defaultData	ftHg
 */
CString CConfigNode::GetConfig(CString key, CString defaultData,CConfigSwapBase *swap,int noCase)
{
	if(swap==NULL)
	{
		int	index = GetKeyIndex(key,noCase);
		if(index == -1)
		{
			return(defaultData);
		}
		else
		{
			return(m_curData[index].m_data);
		}
	}
	else
	{
		int	index = GetKeyIndex(key,noCase);
		if(index == -1)
		{
			return(swap->_SwapString(key,defaultData));
		}
		else
		{
			return(swap->_SwapString(key,m_curData[index].m_data));
		}
	}
}


/*!
 *	SẴL[擾
 *
 *	@param list	L[Xg
 *	@return		L[
 */
int CConfigNode::GetAllKey(CStringArray &list)
{
	list.RemoveAll();

	for(int i=0;i<m_curData.GetSize();i++)
		list.Add(m_curData[i].m_key);
	return((int)list.GetSize());
}

/*!
 *	SẴTum[h擾
 *
 *	@param list	m[hXg
 *	@return		m[h
 */
int CConfigNode::GetAllSubNode(CStringArray &list)
{
	list.RemoveAll();

	//	
	for(int i=0;i<m_subNode.GetSize();i++)
		list.Add(m_subNode[i].m_name);
	return((int)list.GetSize());
}

/*!
 *	SẴL[擾
 *
 *	@return		L[
 */
int CConfigNode::GetKeyCount()
{
	return((int)m_curData.GetSize());
}

/*!
 *	SẴTum[h擾
 *
 *	@return		m[h
 */
int CConfigNode::GetSubNodeCount()
{
	return((int)m_subNode.GetSize());
}

/*!
 *	pX̉
 *
 *	@param path		pX
 *	@param topPath	gbvx̃pX
 *	@param subPath	c
 *	@return			0:̃L[A1:܂TuL[
 */
int CConfigNode::ParsePath(CString path, CString & topPath, CString & subPath)
{
	int	index = path.Find("::");
	if(index == -1)
	{
		topPath = "";
		subPath = path;
		return(0);
	}
	else
	{
		if(path == "::")
		{
			topPath = "";
			subPath = "";
			return(0);
		}

		topPath = path.Mid(0,index);
		subPath = path.Mid(index + 2);
		return(1);
	}
}

/*!
 *	̃L[
 *
 *	@param key		L[
 *	@param noCase	TRUE:啶ʂȂ
 *	@return			-1:ȂȂFCfbNX
 */
int CConfigNode::GetKeyIndex(CString key,int noCase)
{
	if(!noCase)
	{
		for(int i=0;i<m_curData.GetSize();i++)
		{
			if(m_curData[i].m_key == key)
				return(i);
		}
	}
	else
	{
		for(int i=0;i<m_curData.GetSize();i++)
		{
			if(m_curData[i].m_key.CompareNoCase(key) == 0)
				return(i);
		}
	}
	return -1;
}

/*!
 *	Tum[h
 *
 *	@param name		O
 *	@return			-1:ȂȂFCfbNX
 */
int CConfigNode::GetSubNodeIndex(CString name)
{
	for(int i=0;i<m_subNode.GetSize();i++)
	{
		if(m_subNode[i].m_name == name)
			return(i);
	}
	return -1;
}

/*!
 *	SăNA
 *
 */
void CConfigNode::Clear(void)
{
	m_subNode.RemoveAll();
	m_curData.RemoveAll();
}

/*!
 *	m[h폜
 *
 */
void CConfigNode::DeleteNode(CString name)
{
	int index = GetSubNodeIndex(name);
	if(index != -1)
		m_subNode.RemoveAt(index);
}

/*!
 *	L[폜
 *
 */
void CConfigNode::DeleteKey(CString name)
{
	int index = GetKeyIndex(name,FALSE);
	if(index != -1)
		m_curData.RemoveAt(index);
}

/*!
 *	SẴL[Rs[
 *
 */
void CConfigNode::CopyAllKeys(CSortArray<CConfigKey,CConfigKey&> &keyData)
{
	keyData.Copy(m_curData);
}

/*!
 *	XMLf[^ɃZ[u
 *
 *	@param element	ۑ
 */
void CConfigNode::SaveToXml(MSXML::IXMLDOMDocumentPtr doc, MSXML::IXMLDOMElementPtr element, CString indent)
{
	// m[hǉ
	element->appendChild(doc->createTextNode(_bstr_t(indent)));
	MSXML::IXMLDOMElementPtr node;
	node = doc->createElement("Node");

	//	Agr[g
	MSXML::IXMLDOMAttributePtr attr;
	attr = doc->createAttribute("name");
	attr->value = _bstr_t(m_name);
	node->setAttributeNode(attr);
	attr.Release();

	//	̃f[^ǉ
	CString	leafIndent = indent + "\t";
	for(int i=0;i<m_curData.GetSize();i++)
	{
		node->appendChild(doc->createTextNode(_bstr_t(leafIndent)));
		CConfigXml::AddLeaf(doc,node,m_curData[i].m_key,m_curData[i].m_data);
	}

	//	Tum[h̃f[^ǉ
	for(int i=0;i<m_subNode.GetSize();i++)
	{
		m_subNode[i].SaveToXml(doc,node,indent + "\t");
	}

	node->appendChild(doc->createTextNode(_bstr_t(indent)));
	element->appendChild(node);

	node.Release();
}


/*!
 *	XMLf[^烍[h
 *
 *	@param element	ۑ
 */
void CConfigNode::LoadFromXml(MSXML::IXMLDOMDocumentPtr doc,MSXML::IXMLDOMNodePtr cur)
{
	//	m[hXg擾
	MSXML::IXMLDOMNodeListPtr	nodeList = cur->childNodes;

	for(int i=0;i<nodeList->length;i++)
	{
		MSXML::IXMLDOMNodePtr	node = nodeList->item[i];

		//	Tum[h
		if(node->nodeName == _bstr_t("Node"))
		{
			CString name = CConfigXml::GetAttrv(doc,node,"name");
			m_subNode.Add(CConfigNode());
			m_subNode[m_subNode.GetSize()-1].m_name = name;
			m_subNode[m_subNode.GetSize()-1].LoadFromXml(doc,node);
		}
		else if(node->nodeName == _bstr_t("Leaf"))
		{
			CString key = CConfigXml::GetAttrv(doc,node,"key");
			SetConfig(key,(PCSTR)node->text);
		}

		node.Release();
	}

	nodeList.Release();
}


/*!
 *	L[Œu擾
 *
 *	@param str		
 *	@param noData	YȂȕu
 *	@return			
 */
CString CConfigNode::GetKeySwapString(CString str, CString noData,CConfigSwapBase *swap)
{
	if(swap==NULL)
	{
		//	S
		int	i;
		for(i=0;i<(int)m_curData.GetSize();i++)
		{
			int index = str.Find("%" + m_curData[i].m_key + "%");

			while(index != -1)
			{
				str = str.Mid(0,index) + m_curData[i].m_data + str.Mid(index + 2 + m_curData[i].m_key.GetLength());
				index = str.Find("%" + m_curData[i].m_key + "%");
			}
		}
	}
	else
	{
		//	S
		int	i;
		for(i=0;i<(int)m_curData.GetSize();i++)
		{
			int index = str.Find("%" + m_curData[i].m_key + "%");

			while(index != -1)
			{
				CString data = swap->_SwapString(m_curData[i].m_key,m_curData[i].m_data);
				str = str.Mid(0,index) + data + str.Mid(index + 2 + m_curData[i].m_key.GetLength());
				index = str.Find("%" + m_curData[i].m_key + "%");
			}
		}
	}

	//	YȂu폜
	if(!noData.IsEmpty() && noData.Find("%") == -1)
	{
		CString	tmp;
		while(1)
		{
			int index = str.Find("%");
			if(index == -1)
			{
				tmp += str;
				break;
			}
			
			tmp += str.Mid(0,index);
			str = str.Mid(index+1);

			int index2 = str.Find("%");
			if(index == -1)
			{
				tmp += str;
				break;
			}

			//	%%?
			if(index2==0)
			{
				tmp += "%";
			}
			else
			{
				tmp += noData;

			}

			str = str.Mid(index2+1);
		}
		str = tmp;
	}


	return(str);
}

//	RAW Image
void CConfigNode::ToString(CBuffer &buf)
{
	// m[hǉ
	AddStartNode(buf);	

	//	̃f[^ǉ
	for(int i=0;i<m_curData.GetSize();i++)
		AddLeaf(buf,m_curData[i].m_key,m_curData[i].m_data);

	//	Tum[h̃f[^ǉ
	for(int i=0;i<m_subNode.GetSize();i++)
		m_subNode[i].ToString(buf);
	
	//	I
	AddEndNode(buf);
}


//	m[hǉ
void CConfigNode::AddStartNode(CBuffer &buf)
{
	buf += (char)START_NODE;
	AddOneText(buf,m_name);
}

//	m[hI
void CConfigNode::AddEndNode(CBuffer &buf)
{
	buf += (char)END_NODE;
}

//	Leafǉ
void CConfigNode::AddLeaf(CBuffer &buf,CString &key,CString &data)
{
	buf += (char)LEAF;
	AddOneText(buf,key);
	AddOneText(buf,data);
}

//	Textǉ
void CConfigNode::AddOneText(CBuffer &buf,CString &str)
{
	long len = str.GetLength();

	str.Replace("\\","\\\\");
	buf += str;
	buf += "\\0";
}

//	C[W烍[h
int CConfigNode::FromString(char **ptr)
{
	while(1)
	{
		char code = **ptr;
		(*ptr)++;

		if(code == START_NODE)
		{
			CString name = GetOneText(ptr);
			m_subNode.Add(CConfigNode());
			m_subNode[m_subNode.GetSize()-1].m_name = name;
			m_subNode[m_subNode.GetSize()-1].FromString(ptr);
		}
		else if(code == LEAF)
		{
			CString key = GetOneText(ptr);
			SetConfig(key,GetOneText(ptr));
		}
		else if(code == END_NODE)
		{
			return(0);
		}
		else
		{
			return(-1);
		}
	}
}

//	eLXgǂݍ
CString CConfigNode::GetOneText(char **buf)
{
	int escape=0;
	for(int i=0;;i++)
	{
		if((*buf)[i] == 0)
			return("");
		
		if((*buf)[i] == '\\')
		{
			if(escape == 0)
				escape = 1;
			else
				escape = 0;	//QA
		}
		else if((*buf)[i] == '0')
		{
			if(escape)
				break;
		}
		else
		{
			escape = 0;
		}
	}

	CString	ret;
	char *str = ret.GetBuffer(i + 1);
	memcpy(str,*buf,i-1);
	(*buf) += (i + 1);
	str[i-1] = 0;
	ret.ReleaseBuffer();
	ret.Replace("\\\\","\\");

	return(ret);

}


CConfigSwapBase::CConfigSwapBase()
{
	m_next = NULL;
}

CConfigSwapBase::~CConfigSwapBase()
{
}

CString CConfigSwapBase::_SwapString(CString key,CString data)
{
	if(m_next)
	{
		data = m_next->SwapString(key,data);
	}

	return(SwapString(key,data));
}

void CConfigTextSwap::AddSwap(CString oldStr,CString newStr)
{
	oldArray.Add(oldStr);
	newArray.Add(newStr);
}

CString CConfigTextSwap::SwapString(CString key,CString data)
{
	for(int i=0;i<oldArray.GetSize();i++)
		data.Replace(oldArray[i],newArray[i]);

	return(data);
}

