#pragma once
#include "MySocket.h"
#include "Config.h"
#include "threadskeleton.h"
#include "response.h"
#include "request.h"
#include "alias.h"
#include "bandwidthmgr.h"

class CServer;

class CConnectionException
{
public:
	CConnectionException(CString info,int retry=0) {m_info = info;m_retry = retry;}

	CString	m_info;
	int		m_retry;
};

class CServerFatalException
{
public:
	CServerFatalException(CString info)
	{
		m_info = info;
	}

	CString	m_info;
};

//	X|X̒fȂǁA荞݂mF
class CConnection;
class CConnectionInterrupt
{
public:
	CConnectionInterrupt(CConnection *connection);
	CConnectionInterrupt(CConnectionInterrupt &other);
	
	int IsInterrupt();
	operator int();
	CString GetInterruptInfo();

private:
	CConnection		*m_connection;
	CString			m_interruptInfo;
};

class CConnection : public CThreadSkeleton, public CTimeOut
{
	friend class CConnectionInterrupt;

public:
	CConnection(CServer *server,CMySocket *socket);
	virtual ~CConnection(void);
	CConfigAccess GetDate(int detail=0);			//!<	t擾
	virtual void Break();

protected:
	//	I[o[[h
	void ThreadMain();
	virtual void OnTimeOut();

	int SSLTask();
	CConfigAccess NewContext();
	void DeleteContext(CConfigAccess context);
	int OneRequest(CConfigAccess context);
	CString RecvHeader();
	void SendFatalError(CString info);
	CString MakeHeaderString(CConfigAccess responseInfo);

	void WriteLog(CConfigAccess &context);
	void UpdateTransSize(CConfigAccess &context);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ANZX`FbN
	void CheckAccess(CConfigAccess &context,CRequest &request,CAlias &alias,CBandWidthReference &bandRef);

	//!	[U[`FbN
	void CheckUser(CConfigAccess &context,CRequest &request,CAlias &alias);

	//!	zXg`FbN
	int CheckKickHost(CConfigAccess &context,CRequest &request,CAlias &alias);

	//!	ړ̊mF
	void CheckMove(CConfigAccess &context,CRequest &request,CAlias &alias);

	//!	WebDAV
	void WebDAV(CConfigAccess &context,CRequest &request,CAlias &alias);

	//!	IndexmF
	void CheckIndex(CConfigAccess &context,CRequest &request,CAlias &alias);

	//!	CGI
	void CGI(CConfigAccess &context,CRequest &request,CAlias &alias);

	//!	SSI
	void SSI(CConfigAccess &context,CRequest &request,CAlias &alias);

	void SendResponse(CConfigAccess &context,CRequest &request,CAlias &alias,CBandWidthReference &bandRef,CResponse *response);
	void RecvData(CConfigAccess &context,CRequest &request,CAlias &alias,CBandWidthReference &bandRef,CResponse *response);
	void SendData(CConfigAccess &context,CRequest &request,CAlias &alias,CBandWidthReference &bandRef,CResponse *response,__int64 length);

	int CheckUser(CString userName,CString passwd,CAlias alias);
	void Delay(int tick);
	

	int						m_maxKeepAliveTime;	//!<	KeepAlive
	int						m_keepAlive;		//!<	KeepAlive
	CConfig					m_date;				//!<	tp̈

	__int64					m_sendSize;
	__int64					m_recvSize;
	__int64					m_recvDataSize;;

	CServer					*m_server;
	CMySocket				*m_socket;			//!<	\Pbg
	CConnectionInterrupt	m_interrupt;
};

