/*!
	## 2005/08/24 D:resourcetype
*/

#include "StdAfx.h"
#include "davpropfindresponse.h"
#include "connection.h"
#include "JISUtility.h"
#include "UrlUtility.h"
#include "Dir.h"

CDAVPropfindResponse::CDAVPropfindResponse(CServer *server,CConfigAccess context,CRequest request,CAlias alias)
: CNormalResponse(server,context,request,alias)
{
	//	͖Ƃ
	if(alias.IsExist()==0)
		throw new CSystemResponse(server,context,"w肳ꂽfBNg݂͑܂",404);
}

CDAVPropfindResponse::~CDAVPropfindResponse(void)
{
}

void CDAVPropfindResponse::SetNextData(CBuffer &data)
{
	/*
	## 2005/8/24
	FILE *test = fopen("test.txt","at");
	if(test)
	{
		fwrite(data.GetPtr(),data.GetSize(),1,test);
		fclose(test);
	}
	*/
}

/*
	X|X
*/
void CDAVPropfindResponse::CreateResponse()
{
	//	X|XR[h
	SetResponseCode(207);	//Multi status

	//	^Cv
	m_responseOptions.SetConfig("Content-Type","text/xml; charset=\"utf-8\"");
	m_responseOptions.SetConfig("DAV","1");

	try
	{
		//	MSXML CX^X̐
		MSXML::IXMLDOMDocumentPtr pXMLDom(CLSID_DOMDocument);

		//	ProcessingInstruction ̒ǉ
		MSXML::IXMLDOMProcessingInstructionPtr pi;
		pi = pXMLDom->createProcessingInstruction("xml", "version=\"1.0\"");

		pXMLDom->appendChild(pi);
		pi.Release();

		// [gǉ.
		MSXML::IXMLDOMElementPtr pe;
		pe = pXMLDom->createElement("D:multistatus");
		pXMLDom->appendChild(pe);

		//	Agr[g
		MSXML::IXMLDOMAttributePtr pa;
		pa = pXMLDom->createAttribute("xmlns:D");
		pa->value = "DAV:";
		pe->setAttributeNode(pa);
		pa.Release();

		FindAll(pXMLDom,pe);

		//	UTF8ɕϊ
		CBuffer	unicode;
		_bstr_t	bstr(pXMLDom->xml);
		unicode.ReSize(bstr.length() * sizeof(wchar_t));
		unicode.BlockCopy(0,(char *)((wchar_t*)bstr),bstr.length() * sizeof(wchar_t));
		unicode += (char)0;
		unicode += (char)0;
		m_body = CJISUtility::UnicodeToUTF8(unicode);

	}
	catch(const _com_error& err)
	{
		CString str;
		str.Format("XML̑Ɏs܂AVXeG[ł [ComError %s]",err.ErrorMessage());
		throw CServerFatalException(str);
	}
}

void CDAVPropfindResponse::FindAll(MSXML::IXMLDOMDocumentPtr doc,MSXML::IXMLDOMElementPtr res)
{
	CString url = m_request.m_uriObject;
	CString	depth = m_request.m_options.GetConfig("Depth","1",TRUE);
	int		showHidden = m_alias.GetPathOptions().GetConfig("EnableHiddenFile",0);

	int				done=1;
	CFileFind		find;
	
	if(m_alias.IsDirectory())
	{
		//	"/"H
		url = CDir::AddSlash(url);

		//	hCuw肵ꍇAɓ삵Ȃ
		CString target = m_alias.GetTarget();
		target = target.Left(target.GetLength() - 1);
		if(target.Find("\\") == -1)
		{
			AddVolumeInfo(doc,res,m_alias.GetTarget(),url);
		}

		if(find.FindFile(m_alias.GetTarget() + "*.*"))
		{
			while(done)
			{
				done=find.FindNextFile();

				if(find.GetFileName() == ".")
				{
					AddInfo(doc,res,find,url);
				}
				else if(depth != "0")
				{
					if(find.IsDots())
						continue;

					if(find.IsHidden() && showHidden == 0)
						continue;

					if(find.IsDirectory())
					{
						AddInfo(doc,res,find,url + find.GetFileName() + "/");
						if(depth == "infinity")
							FindFiles(doc,res,url + find.GetFileName() + "/",m_alias.GetTarget() + find.GetFileName());
					}
					else
					{
						AddInfo(doc,res,find,url + find.GetFileName());
					}
				}
			}
		}
		find.Close();
	}
	else
	{
		if(find.FindFile(m_alias.GetTarget()))
		{
			while(done)
			{
				done=find.FindNextFile();

				if(find.IsDots())
					continue;

				if(find.IsHidden() && showHidden == 0)
					continue;

				AddInfo(doc,res,find,url + find.GetFileName());
				break;
			}
		}
		find.Close();
	}

	m_responseOptions.SetConfig("Content-Location",url);

}

//	w̌
void CDAVPropfindResponse::FindFiles(MSXML::IXMLDOMDocumentPtr doc,MSXML::IXMLDOMElementPtr res,CString url,CString path)
{
	int				showHidden = m_alias.GetPathOptions().GetConfig("EnableHiddenFile",0);

	int				done=1;
	CFileFind		find;


	if(find.FindFile(path + "*.*"))
	{
		while(done)
		{
			done=find.FindNextFile();

			if(find.IsDots())
				continue;

			if(find.IsHidden() && showHidden == 0)
				continue;

			if(find.IsDirectory())
			{
				AddInfo(doc,res,find,url + find.GetFileName() + "/");
				FindFiles(doc,res,url + find.GetFileName() + "/",m_alias.GetTarget() + find.GetFileName());
				continue;
			}

			AddInfo(doc,res,find,url + find.GetFileName());
		}
	}
	find.Close();
}


void CDAVPropfindResponse::AddInfo(MSXML::IXMLDOMDocumentPtr doc,MSXML::IXMLDOMElementPtr res,CFileFind &find,CString url)
{
	CString str;

	res->appendChild(doc->createTextNode(_bstr_t("\r\n")));

	// D:responseǉ.
	MSXML::IXMLDOMElementPtr response;
	response = doc->createElement("D:response");
	res->appendChild(response);

	//	hrefǉ
	MSXML::IXMLDOMElementPtr href;
	href = doc->createElement("D:href");
	href->text = _bstr_t(EncodeUrl(url));
	response->appendChild(href);

	//	D:propstatǉ
	MSXML::IXMLDOMElementPtr propstat;
	propstat = doc->createElement("D:propstat");
	response->appendChild(propstat);

	//	D:status
	AddAttr(doc,propstat,"D:status","HTTP/1.1 "+GetHTTPResponseString(200));

	//	D:propǉ
	MSXML::IXMLDOMElementPtr prop;
	prop = doc->createElement("D:prop");
	propstat->appendChild(prop);

	//	D:creationdate
	CTime	time;
	find.GetCreationTime(time);
	AddAttr(doc,prop,"D:creationdate",time.FormatGmt("%Y-%m-%dT%H:%M:%SZ"));

	//	D:displayname
	AddAttr(doc,prop,"D:displayname",find.GetFileName());

	//	D:getcontentlength
	str.Format("%I64d",find.GetLength());
	AddAttr(doc,prop,"D:getcontentlength",str);

	//	D:getcontenttype
	AddAttr(doc,prop,"D:getcontenttype",m_server->GetCMimeTypeMgr().GetMimeTypeByName(find.GetFileName()));

	//	D:getetag(Not support)
	AddAttr(doc,prop,"D:getetag","");

	//	D:getlastmodified
	find.GetLastWriteTime(time);
	AddAttr(doc,prop,"D:getlastmodified",time.FormatGmt("%a, %d %b %Y %H:%M:%S GMT"));

	// ## 2005/08/24
	//	D:resourcetype
	if(find.IsDirectory())
	{
		MSXML::IXMLDOMElementPtr resourcetype;
		resourcetype = doc->createElement("D:resourcetype");
		prop->appendChild(resourcetype);
		AddAttr(doc,resourcetype,"D:collection","");
	}
	else
	{
		AddAttr(doc,prop,"D:resourcetype","");
	}

	//	D:iscollection
	if(find.IsDirectory())
		AddAttr(doc,prop,"D:iscollection","1");
	else
		AddAttr(doc,prop,"D:iscollection","0");

	//	D:ishidden
	AddAttr(doc,prop,"D:ishidden","0");

}

void CDAVPropfindResponse::AddVolumeInfo(MSXML::IXMLDOMDocumentPtr doc,MSXML::IXMLDOMElementPtr res,CString volume,CString url)
{
	CString str;

	// D:responseǉ.
	MSXML::IXMLDOMElementPtr response;
	response = doc->createElement("D:response");
	res->appendChild(response);

	//	hrefǉ
	MSXML::IXMLDOMElementPtr href;
	href = doc->createElement("D:href");
	href->text = _bstr_t(url);
	response->appendChild(href);

	//	D:propstatǉ
	MSXML::IXMLDOMElementPtr propstat;
	propstat = doc->createElement("D:propstat");
	response->appendChild(propstat);

	//	D:status
	AddAttr(doc,propstat,"D:status","HTTP/1.1 "+GetHTTPResponseString(200));

	//	D:propǉ
	MSXML::IXMLDOMElementPtr prop;
	prop = doc->createElement("D:prop");
	propstat->appendChild(prop);

	//	D:creationdate
	AddAttr(doc,prop,"D:creationdate","");

	//	D:displayname
	AddAttr(doc,prop,"D:displayname","");

	//	D:getcontentlength
	AddAttr(doc,prop,"D:getcontentlength","");

	//	D:getcontenttype
	AddAttr(doc,prop,"D:getcontenttype","");

	//	D:getetag(Not support)
	AddAttr(doc,prop,"D:getetag","");

	//	D:getlastmodified
	AddAttr(doc,prop,"D:getlastmodified","");

	//	D:resourcetype(Not support)
	AddAttr(doc,prop,"D:resourcetype","1");

	//	D:iscollection
	AddAttr(doc,prop,"D:iscollection","1");

	//	D:ishidden
	AddAttr(doc,prop,"D:ishidden","0");
}


void CDAVPropfindResponse::AddAttr(MSXML::IXMLDOMDocumentPtr doc,MSXML::IXMLDOMElementPtr res,CString attr,CString text)
{
	MSXML::IXMLDOMElementPtr attrleaf;
	attrleaf = doc->createElement(_bstr_t(attr));
	attrleaf->text = _bstr_t(text);
	res->appendChild(attrleaf);
}


/*!
	X|XTCY̎擾
*/
__int64 CDAVPropfindResponse::GetResponseSize()
{
	return(m_body.GetLength());
}

/*!
	X|X̎擾
*/
int CDAVPropfindResponse::GetNextData(CBuffer &data)
{
	int len = m_body.GetLength();

	data = m_body;
	m_body = "";

	return(len);
}

/*!
	URLGR[h
*/
CString CDAVPropfindResponse::EncodeUrl(CString url)
{
	CString ret = CUrlUtility::EncodeUrl8Bit(CJISUtility::SjisToUTF8(url));

	ret.Replace("&","%26");

	return(ret);
}
