#include "StdAfx.h"
#include "fileputresponse.h"
#include "connection.h"
#include "dir.h"

CFilePutResponse::CFilePutResponse(CServer *server,CConfigAccess context,CRequest request,CAlias alias)
: CNormalResponse(server,context,request,alias)
{
	m_writeFile = 0;
}

CFilePutResponse::~CFilePutResponse(void)
{
	try
	{
		m_file.Close();
	}
	catch(CFileException *err)
	{
		err->Delete();
	}
}

/*
	
*/
void CFilePutResponse::PreCreateResponse()
{
	//	X|XR[h
	SetResponseCode(201);	//	OK

	if(m_request.m_method == "MKCOL")
	{
		CDir::MakeAllDirectory(m_alias.GetTarget());
	}
	else if(m_request.m_method == "PUT")
	{
		try
		{
			if(!m_file.Open(m_alias.GetTarget(),	CFile::modeCreate | CFile::modeWrite | CFile::shareExclusive))
				throw CServerFatalException("t@C̃I[vɎs܂AT[o[̃t@ĆAgp̂߃bNĂ\܂");

			m_writeFile = 1;
		}
		catch(CFileException *err)
		{
			TRACE("File error : %s\n",err->m_strFileName);
			err->Delete();
			throw CServerFatalException("t@C̑Ɏs܂AVXeG[ł");
		}
	}
}

/*
	f[^M
*/
void CFilePutResponse::SetNextData(CBuffer &data)
{
	if(m_writeFile)
	{
		try
		{
			m_file.Write(data.GetPtr(),data.GetSize());
		}
		catch(CFileException *err)
		{
			TRACE("File error : %s\n",err->m_strFileName);
			err->Delete();
			throw CServerFatalException("t@C̑Ɏs܂AVXeG[ł");
		}
	}
}

/*
	X|X
*/
void CFilePutResponse::CreateResponse()
{
}


/*!
	X|XTCY̎擾
*/
__int64 CFilePutResponse::GetResponseSize()
{
	return(0);
}

/*!
	X|X̎擾
*/
int CFilePutResponse::GetNextData(CBuffer &data)
{
	data.ReSize(0);
	return(0);
}

