// 04WebServer.cpp : AvP[ṼNX`܂B
//

#include "stdafx.h"
#include "04WebServer.h"
#include "04WebServerDlg.h"
#include <initguid.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMy04WebServerApp

BEGIN_MESSAGE_MAP(CMy04WebServerApp, CWinApp)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()


// CMy04WebServerApp RXgNV

CMy04WebServerApp::CMy04WebServerApp()
{
	m_server = NULL;
	m_serviceMode = 0;
	m_serverStatus = "T[o͒~łB";
	m_exitCode = 0;
}


// B CMy04WebServerApp IuWFNgłB

CMy04WebServerApp theApp;


// CMy04WebServerApp 

BOOL CMy04WebServerApp::InitInstance()
{
	SetServerSecurityDescripter();

	//	COM
	CoInitialize(NULL);

	//	낢돉
	InitCommonControls();
	CWinApp::InitInstance();
	AfxEnableControlContainer();

	// R}hC
	CString				cmdString = GetCommandOption();
	CCommandLineInfo	cmdInfo;
	ParseCommandLine(cmdInfo);

	if(cmdString.IsEmpty())
	{
		//	wȂȂ̂ŁARg[[`
		CString path = GetAppPath() + "ServerController.exe";
		::ShellExecute(0, _T("open"), path.GetBuffer(0), 0, 0, SW_SHOWNORMAL);

		return FALSE;
	}
	else if(DoRegister(cmdString))
	{
		//	WXgo^Ȃ̂ŁAI
		return FALSE;
	}

	//	dN`FbN
	if(m_pipeServer.CheckOther())
	{
		AfxMessageBox("T[o͂łɋNłAdNł܂B",MB_ICONSTOP);
		return FALSE;
	}

	//	Rg[ƒʐMJn
	if(m_pipeServer.Start())
	{
		AfxMessageBox("Rg[Ƃ̒ʐMJnɎs܂B",MB_ICONSTOP);
		return FALSE;
	}

	//	IvVɂĔ
	if(cmdString.CompareNoCase("/Service") == 0)
	{
		//	T[rXN

		m_serviceMode = 1;
		m_serviceContext.RunService();
		return FALSE;
	}
	else if(cmdString.CompareNoCase("/Debug") == 0)
	{
		//	fobO[h

		//	fobOsH
		CMy04WebServerDlg dlg;
		m_pMainWnd = &dlg;
		dlg.DoModal();

		return FALSE;
	}
	else if(cmdString.CompareNoCase("/Application") == 0)
	{
		//	AvP[V[h
		m_pMainWnd = &m_msgWindow;
		m_msgWindow.CreateMsgWindow();

		return TRUE;
	}
	else
	{
		//	IvVG[
		AfxMessageBox("sȋNIvVłB",MB_ICONSTOP);
		return FALSE;
	}
}

//	e탌WXg
int CMy04WebServerApp::DoRegister(CString command)
{
	if(command.CompareNoCase("/UnInstall") == 0)
	{
		//	Rg[~
		KillAllController();

		// Sč폜
		RegisterService(FALSE);
		return TRUE;
	}
	else if (command.CompareNoCase("/InstallService") == 0)
	{
		// AvP[V[hœo^
		RegisterService(TRUE);
		return TRUE;
	}
	else if (command.CompareNoCase("/UnInstallService") == 0)
	{
		//	Rg[~
		KillAllController();

		// T[rX[h폜
		RegisterService(FALSE);
		return TRUE;
	}
	else if (command.CompareNoCase("/IsRunning") == 0)
	{
		// so
		m_exitCode = m_pipeServer.CheckOther();
		return TRUE;
	}
	return FALSE;
}



//	W[pX擾
CString CMy04WebServerApp::GetAppPath(int directoryPath)
{
	if(!directoryPath)
		return CPathTools::GetAppPathName();
	else
		return CPathTools::GetAppPath();
}

//	I
int CMy04WebServerApp::ExitInstance()
{
	//	Ô߁A~
	StopServer();

	CoUninitialize();

	CWinApp::ExitInstance();
	return m_exitCode;
}

//	T[oN܂
int CMy04WebServerApp::StartServer()
{
	SCOPE_LOCK();

	//	Ƃ肠A~
	StopServer();

	try
	{
		if(m_server == NULL)
			m_server = new CServer();

		m_serverStatus = "T[o͐ɍ쓮łB";
	}
	catch(CServerException e)
	{
		StopServer();
		m_serverStatus = e.m_info;
		return(-1);
	}

	return(0);
}

//	~
int CMy04WebServerApp::StopServer()
{
	SCOPE_LOCK();

	if(m_server != NULL)
		delete m_server;
	m_server = NULL;

	m_serverStatus = "T[o͒~łB";

	return(0);
}

//	G[擾
CString CMy04WebServerApp::GetServerErrorInfo()
{
	SCOPE_LOCK();

	return(m_serverStatus);
}

//	T[os擾
int CMy04WebServerApp::ServerRunning()
{
	SCOPE_LOCK();

	if(m_server)
		return(TRUE);
	else
		return(FALSE);
}

//	T[o[擾
CString CMy04WebServerApp::GetServerInfoXML()
{
	SCOPE_LOCK();

	if(m_server)
	{
		return(m_server->m_infoRoot.ToXMLString());
	}
	else
		return("");
}

//	T[o[ݒ擾
CString CMy04WebServerApp::GetServerSettingXML()
{
	SCOPE_LOCK();

	if(m_server)
	{
		return(m_server->m_settingRoot.ToXMLString());
	}
	else
		return("");
}

//	T[o[ݒ擾
CString CMy04WebServerApp::GetServerContextXML()
{
	SCOPE_LOCK();

	if(m_server)
	{
		return(m_server->m_context.ToXMLString());
	}
	else
		return("");
}

//	T[o[擾
CString CMy04WebServerApp::GetServerInfoString()
{
	SCOPE_LOCK();

	if(m_server)
	{
		return(m_server->m_infoRoot.ToXMLString());
	}
	else
		return("");
}

//	T[o[ݒ擾
CString CMy04WebServerApp::GetServerSettingString()
{
	SCOPE_LOCK();

	if(m_server)
	{
		return(m_server->m_settingRoot.ToXMLString());
	}
	else
		return("");
}

//	T[o[ݒ擾
CString CMy04WebServerApp::GetServerContextString()
{
	SCOPE_LOCK();

	if(m_server)
	{
		return(m_server->m_context.ToXMLString());
	}
	else
		return("");
}

//	T[o[Xe[^Xݒ
void CMy04WebServerApp::SetServerStatus(CString stat)
{
	SCOPE_LOCK();

	m_serverStatus = stat;
}

//	ڑ̎擾
int CMy04WebServerApp::GetConnectCount()
{
	SCOPE_LOCK();

	if(m_server)
	{
		return(m_server->GetConnectCount());
	}
	else
		return(0);
}

//	T[rX[h
int CMy04WebServerApp::IsService()
{
	return(m_serviceMode);
}





/*!
	T[o擾
*/
int CMy04WebServerApp::GetServerInfo(CWorkspaceAccess info)
{
	SCOPE_LOCK();

	if(m_server)
	{
		info.Copy(m_server->m_infoRoot.GetAccess(""));
		return(0);
	}
	else
		return(-1);
}

/*!
	T[oݒ擾
*/
int CMy04WebServerApp::GetServerSetting(CWorkspaceAccess setting)
{
	SCOPE_LOCK();

	if(m_server)
	{
		setting.Copy(m_server->m_settingRoot.GetAccess(""));
		return(0);
	}
	else
		return(-1);
}

/*!
	ڑ擾
*/
int CMy04WebServerApp::GetServerContext(CWorkspaceAccess context)
{
	SCOPE_LOCK();

	if(m_server)
	{
		context.Copy(m_server->m_context.GetAccess(""));
		return(0);
	}
	else
		return(-1);
}




//	fobOO
void CMy04WebServerApp::WriteDebugLog(LPCTSTR lpszFormat, ...)
{
	//	WJ
	va_list argList;
	CString	str;
	va_start(argList, lpszFormat);
	str.FormatV(lpszFormat,argList);
	va_end(argList);

	FILE *text;
	if(!fopen_s(&text, GetAppPath() + "Debuglog.txt","at"))
	{
		fprintf(text,"%s\n",str);
		fclose(text);
	}
}

//	R}hIvV擾
CString CMy04WebServerApp::GetCommandOption()
{
	CString	line = GetCommandLine();
	if(line.IsEmpty())
		line = m_lpCmdLine;

	int index = line.Find("/");
	if(index == -1)
	{
		index = line.Find("-");
		if(index == -1)
			return("");
	}

	return(line.Mid(index));
}

//	SẴRg[I
void CMy04WebServerApp::KillAllController()
{
	::PostMessage(HWND_BROADCAST,::RegisterWindowMessage(_T("04WebServer All Quit")),0,0);
}


/*!
	_v
*/
void CMy04WebServerApp::DumpContext()
{
	if(m_server != NULL)
	{
		m_server->m_context.SaveToXMLFile(GET_APP()->GetAppPath() + "ContextDump.xml");
		m_server->m_infoRoot.SaveToXMLFile(GET_APP()->GetAppPath() + "InfoDump.xml");
	}
}


//	T[ogpZLeBLqq擾
void CMy04WebServerApp::SetServerSecurityDescripter()
{

	//	DACL폜
	TOKEN_DEFAULT_DACL	dacl;
	dacl.DefaultDacl = NULL;

	HANDLE	token=NULL;
	::OpenProcessToken(GetCurrentProcess(),TOKEN_ADJUST_DEFAULT,&token);
	::SetTokenInformation(token,TokenDefaultDacl,&dacl,sizeof(TOKEN_DEFAULT_DACL ));
	::CloseHandle(token);
}

//	T[rXƂēo^
void CMy04WebServerApp::RegisterService(int reg)
{
	if(reg)
	{
		if(CSystemService::AddToService())
		{
			AfxMessageBox("T[rX̒ǉɎs܂B",MB_ICONSTOP);
			m_exitCode = 0x100;
		}
	}
	else
	{
		if(CSystemService::DelFromService())
		{
			AfxMessageBox("T[rX̍폜Ɏs܂B",MB_ICONSTOP);
			m_exitCode = 0x100;
		}
	}
}

