#pragma once
#include "Workspace.h"
#include "MySocket.h"
#include "SortArray.h"



class CBandWidthReference;
class CBandWidthMgr
{
friend class CBandWidthReference;

protected:
	CCriticalSection	m_scopeLock;

public:
	CBandWidthMgr(void);
	virtual ~CBandWidthMgr(void);

	void Load(CWorkspaceAccess setting);
	void AddTrans(__int64 send,__int64 recv);
	__int64 GetSend1h();
	__int64 GetRecv1h();
	__int64 GetAllSend();
	__int64 GetAllRecv();
	int GetCount1h();
	int GetAllCount();

private:
	void AddConnection(CIPAddress host,CString code,int sendLimit,int recvLimit);
	void DelConnection(CString code);
	int FindConnection(CString code);

	int GetAllConnectionCount();
	int GetHostConnectionCount(CIPAddress host);
	int GetAllSendConnectionCount();
	int GetHostSendConnectionCount(CIPAddress host);
	int GetAllRecvConnectionCount();
	int GetHostRecvConnectionCount(CIPAddress host);

	int GetCurrentSendLimit(CIPAddress host);
	int GetCurrentRecvLimit(CIPAddress host);

	int m_SendMaxServerBandWidth;
	int m_SendMaxOneHostBandWidth;
	int m_SendMaxOneConnectBandWidth;

	int m_RecvMaxServerBandWidth;
	int m_RecvMaxOneHostBandWidth;
	int m_RecvMaxOneConnectBandWidth;

	int m_MaxOneHostConnect;

	void UpdateTransInfo();

private:
	class COneConnection
	{
	public:
		COneConnection() {};
		COneConnection(CIPAddress host,CString code,int sendLimit,int recvLimit)
		{
			m_hostAddress = host;
			m_connectionCode = code;
			m_sendLimit = sendLimit;
			m_recvLimit = recvLimit;
		};

		CIPAddress	m_hostAddress;
		CString		m_connectionCode;
		int			m_sendLimit;
		int			m_recvLimit;
	};

	CSortArray<COneConnection,COneConnection&>	m_connections;


	class COneTrans
	{
	public:
		COneTrans() {};
		COneTrans(CTime time,__int64 send,__int64 recv)
		{
			m_time = time;
			m_send = send;
			m_recv = recv;
		};
		CTime	m_time;
		__int64	m_send;
		__int64	m_recv;
	};

	CSortArray<COneTrans,COneTrans&>	m_trans1h;
	__int64		m_curSend;
	__int64		m_curRecv;
	__int64		m_allSend;
	__int64		m_allRecv;
	int			m_allCount;
};

class CBandWidthReference
{
public:
	CBandWidthReference(CBandWidthMgr *mgr,CIPAddress host,CString code);
	virtual ~CBandWidthReference();

	void SetSendLimit(int enable);
	void SetRecvLimit(int enable);
	int IsLimitOver();

	int GetCurrentSendLimit();
	int GetCurrentRecvLimit();

private:
	CBandWidthMgr	*m_mgr;
	CIPAddress	m_hostAddress;
	CString		m_connectionCode;
	int			m_sendLimit;
	int			m_recvLimit;
};


class CBandWidthLimit
{
public:
	CBandWidthLimit();
	int GetWaitTick(int limitBytePerSec,int transByte);

	int GetCurSpeed();
	void OneTracsEnd();

private:
	class CTrans
	{
	public:
		CTrans() {};
		CTrans(int size,int time)
		{
			m_size = size;
			m_time = time;
		};

		int	m_size;
		int	m_time;
	};
	CSortArray<CTrans,CTrans &>	m_transLog;	//	ʐM

	DWORD	m_prevTick;
	int		m_curTrans;
	int		m_curTime;
	int		m_transByte;
};

