#include "StdAfx.h"
#include "fastlistener.h"
#include "SSLSocket.h"
#include <Mswsock.h>

CFastListener::CFastListener(void)
{
	m_sslEnable = 0;
}

CFastListener::~CFastListener(void)
{
	Close();
}



//	
void CFastListener::Init(CWorkspaceAccess setting)
{
	//	T[oݒ
	CWorkspaceAccess basic = setting.GetAccess("Basic");
	CWorkspaceAccess enhance = setting.GetAccess("Enhance");

	//	ϐ
	m_maxListenQueue = enhance.GetConfig("MaxListenQueue",50);
	int ListenThread = enhance.GetConfig("ListenThreadCount",3);
	int ListenThreadSSL = 0;

	//	|[g҂󂯊Jn
	if(m_listenSocket.Listen(setting.GetConfig("Basic::Port",80)))
		throw CFastListenerException("|[g҂Ɏs܂A|[gԍmFĂ");


	//	SSLLH
	if(setting.GetConfig("Basic::EnableSSL",0))
	{
		m_sslEnable = 1;
		ListenThreadSSL = enhance.GetConfig("ListenThreadCountSSL",3);

		//	SSLCu
		if(m_sslContext.Init(setting))
			throw CFastListenerException("SSLɎs܂AÍL[ApX[hAؖ̂ꂩُł");

		//	|[g҂󂯊Jn
		if(m_listenSocketSSL.Listen(setting.GetConfig("SSL::Port",443)))
			throw CFastListenerException("SSL̃|[g҂Ɏs܂ASSL̃|[gԍmFĂ");
	}

	//	XbhN
	m_maxListenThread = ListenThread + ListenThreadSSL;

	//	HTTP
	for(int i=0;i<ListenThread;i++)
	{
		CFastListenerThread *newThread = new CFastListenerThread;
		m_threadArray.Add(newThread);

		if(newThread->Start(&m_listenSocket,this))
			throw CFastListenerException("XiXbh̋NɎs܂");
	}

	//	HTTPS
	for(int i=ListenThread;i<m_maxListenThread;i++)
	{
		CFastListenerThread *newThread = new CFastListenerThread;
		m_threadArray.Add(newThread);

		if(newThread->Start(&m_listenSocketSSL,this,TRUE))
			throw CFastListenerException("XiXbh̋NɎs܂");
	}
}

//	~
void CFastListener::Close()
{
	//	܂A
	m_listenSocket.Close();
	m_listenSocketSSL.Close();

	//	SĒ~
	for(int i=0;i<m_threadArray.GetSize();i++)
		m_threadArray[i]->Break();

	//	ׂč폜
	for(int i=0;i<m_threadArray.GetSize();i++)
		delete m_threadArray[i];
	m_threadArray.RemoveAll();

	//	Sč폜
	for(int i=0;m_socketList.GetSize()>0;)
	{
		delete m_socketList.GetTail();
		m_socketList.RemoveTail();
	}
}

//	G[̎擾
int CFastListener::IsError()
{
	int err = 0;

	if(m_listenSocket.IsError())
		err = 1;

	if(m_sslEnable)
	{
		if(m_listenSocketSSL.IsError())
			err = 1;
	}

	return(err);
}


//	ANZX̎擾
CMySocket *CFastListener::GetNextAccess()
{
	SCOPE_LOCK();

	if(m_socketList.GetCount() <= 0)
		return(NULL);

	CMySocket *sock = (CMySocket *)m_socketList.GetHead();
	m_socketList.RemoveHead();

	return(sock);
}

//	ANZX̒ǉ
void CFastListener::AddNewSocket(CMySocket *sock)
{
	SCOPE_LOCK();

	if(m_socketList.GetCount() >= m_maxListenQueue)
	{
		//	I[o[
		delete sock;
	}
	else
	{
		m_socketList.AddTail(sock);
	}
}

//	
CFastListenerThread::CFastListenerThread()
{
	DEBUG_SET_THREAD_CLASS_NAME("CFastListenerThread");
}

//	폜
CFastListenerThread::~CFastListenerThread()
{
	Break();
	while(IsRunning())
		Sleep(20);
}


//	XbhN
int CFastListenerThread::Start(CMySocket *listen,CFastListener *manager,int SSL)
{
	m_isSSL = SSL;
	m_listen = listen;
	m_manager = manager;

	return(StartThread());
}


//	Xi[Xbh
void CFastListenerThread::ThreadMain()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CFastListenerThread::ThreadMain");

	//	vCIeBグ
	::SetThreadPriority(::GetCurrentThread(),THREAD_PRIORITY_HIGHEST);

	while(!GetBreak())
	{
		try
		{
			CMySocket *sock;
			
			if(m_isSSL)
				sock = new CSSLSocket(&m_manager->m_sslContext);
			else
				sock = new CMySocket;

			//	ڑ҂
			int ret = m_listen->Accept(*sock,TRUE);

			if(ret == 1)
				m_manager->AddNewSocket(sock);
			else
			{
				delete sock;
				Sleep(100);
			}
		}
		catch(CMemoryException *err)
		{
			err->Delete();
			Sleep(5000);
		}
	}
}
