#pragma once
#include "Workspace.h"
#include "MySocket.h"
#include "ThreadSkeleton.h"
#include "sslcontext.h"

class CFastListenerException
{
public:
	CFastListenerException(CString info,int retry=0) {m_info = info;}

	CString	m_info;
};

class CFastListenerThread;
class CFastListener
{
	friend class CFastListenerThread;
protected:
	CCriticalSection	m_scopeLock;

public:
	CFastListener(void);
	virtual ~CFastListener(void);

	void Init(CWorkspaceAccess setting);
	void Close();
	CMySocket *GetNextAccess();
	void AddNewSocket(CMySocket *sock);
	int IsError();

protected:
	CMySocket											m_listenSocket;			//!<	҂p\Pbg
	CMySocket											m_listenSocketSSL;		//!<	SSL҂p\Pbg
	CSSLContext											m_sslContext;			//!<	SSL̃ReLXg
	CTypedPtrList<CPtrList, CMySocket*>					m_socketList;
	CTypedPtrArray<CPtrArray,CFastListenerThread*>		m_threadArray;
	int													m_maxListenQueue;
	int													m_maxListenThread;
	int													m_sslEnable;
};

class CFastListenerThread :public CThreadSkeleton
{
public:
	CFastListenerThread();
	virtual ~CFastListenerThread();

	int Start(CMySocket *listen,CFastListener *manager,int SSL=FALSE);
	void ThreadMain();

public:
	CMySocket		*m_listen;
	int				m_isSSL;
	CFastListener	*m_manager;
};
