#pragma once
#include "openssl\ssl.h"
#include "Workspace.h"

class CSSLContext
{
	CCriticalSection	m_scopeLock;

public:
	CSSLContext(void);
	virtual ~CSSLContext(void);

	int Init(CWorkspaceAccess setting);
	void Close();
	static int Password_cb(char *buf,int num,int rwflag,void *userdata);
	static void Locking_cb(int mode, int type,const char *file, int line);

	SSL_CTX *GetCTX() {return m_context;};

private:
	SSL_CTX		*m_context;
    SSL_METHOD	*m_method;
	CString		m_password;
	int			m_init;

	static void InitLock();
	static void EndLock();
	CString GetPassword();
	CString GetRandomString(int count);
};
