#include "StdAfx.h"
#include "sslsocket.h"
#include "openssl\err.h"

CSSLSocket::CSSLSocket(CSSLContext *context)
{
	m_context = context;
	m_sslUsing = 0;
}

CSSLSocket::~CSSLSocket(void)
{
	Close();

	SCOPE_LOCK();

	//	SSLf[^J
	if(m_sslUsing)
	{
		m_sslUsing = 0;

		ERR_clear_error();
		SSL_shutdown(m_ssl);
		SSL_free(m_ssl);
	}

	//	̃Xbh̃G[j
	ERR_remove_state(0);
}

//	ؒf
void CSSLSocket::Close()
{
	//	\Pbg
	CMySocket::Close();

	//	ClosesXbh̃G[j
	ERR_remove_state(0);
}

//	nhڑJn
int CSSLSocket::SetHandle(SOCKET sock)
{
	//	CMySocketɊ֘At
	return CMySocket::SetHandle(sock);
}


//	SSLڑ̃lSVG[V
int CSSLSocket::SSLAccept()
{
	SCOPE_LOCK();

	//	\PbgZbgAbv
	m_bio=BIO_new_socket((int)m_socket,BIO_NOCLOSE);
	if(m_bio == NULL)
		return(-1);

	m_ssl=SSL_new(m_context->GetCTX());
	if(m_ssl == NULL)
		return(-1);

	SSL_set_bio(m_ssl,m_bio,m_bio);

	m_sslUsing = 1;

	//	lSVG[V
	if(SSL_accept(m_ssl)<=0)
		return(-1);

	return(0);
}



//	M
int CSSLSocket::_send(SOCKET s,char *buf,int len,int flags)
{
	SCOPE_LOCK();

	//	SSLgpH
	if(!m_sslUsing)
		return(-1);

	int offset=0,mlen = len;

	while(len)
	{
		int r=SSL_write(m_ssl,buf+offset,len);
		switch(SSL_get_error(m_ssl,r))
		{
			case SSL_ERROR_NONE:
				len-=r;
				offset+=r;
				break;

			default:
				return -1;
		}
	}

	return mlen;
}

//	M
int CSSLSocket::_recv(SOCKET s,char *buf,int len,int flags)
{
	SCOPE_LOCK();

	//	SSLgpH
	if(!m_sslUsing)
		return(-1);

	return SSL_read(m_ssl,buf,len);
}

//	M\H
int CSSLSocket::RecvDataPending(int timeOut)
{
	SCOPE_LOCK();

	//	SSLgpH
	if(!m_sslUsing)
		return(0);

	//	SSLobt@Ƀf[^H
	if(SSL_pending(m_ssl))
		return(1);

	return(CMySocket::RecvDataPending(timeOut));
}

