#pragma once
#include "openssl\ssl.h"
#include "mysocket.h"
#include "sslcontext.h"
#include "LockObject.h"

class CSSLSocket :
	public CMySocket
{
protected:
	CCriticalSection	m_scopeLock;

public:
	//	\Pbg^Cv
	virtual int IsSSL() {return 1;};

	CSSLSocket(CSSLContext *context);
	virtual ~CSSLSocket(void);

	//	ڑEؒf
	virtual void Close();
	virtual int SetHandle(SOCKET socket);
	int SSLAccept();

protected:
	virtual int RecvDataPending(int timeOut=0);
	virtual int _send(SOCKET s,char *buf,int len,int flags);
	virtual int _recv(SOCKET s,char *buf,int len,int flags);

	CSSLContext			*m_context;
    SSL					*m_ssl;
	BIO					*m_bio;
	int					m_sslUsing;
};
