#include "StdAfx.h"
#include "server.h"
#include "timeout.h"
#include "04WebServer.h"
#include "connection.h"
#include "dateutility.h"
#include "intervaltimer.h"

/*!
	T[o[sJn
*/
CServer::CServer(void)
	: m_settingRoot("04WebServer")
{
	DEBUG_SET_THREAD_CLASS_NAME("CServer");

	//	ϐ
	m_IDCounter = 0;

	//	ݒ[h
	if(m_settingRoot.LoadFromXMLFile(GET_APP()->GetAppPath() + "04WebServer.xml"))
		throw CServerException("04WebServer.xml̃[hɎs܂");

	//	ݒ̈擾
	m_setting = m_settingRoot.GetAccess("Setting");

	//	Xbh̈擾
	m_threadContext = m_context.GetAccess("Threads");

	//	Xbh̈̃O擾
	m_threadContextLog = m_context.GetAccess("ThreadLogs");

	//	T[o̈擾
	m_serverInfo = m_infoRoot.GetAccess("ServerInfo");

	//	T[o̐ݒ
	InitServerInfo();

	//	^CAEgԂ̐ݒ
	CTimeOutMgr::GetGlobalManager()->SetDefaultTimeOutTime(m_setting.GetConfig("Basic::TimeOut",300)*1000);

	//	ϐ
	m_maxConnect = m_setting.GetConfig("Basic::MaxConnect",50);
	m_statusUpdate = -1;

	//	MimeTypes̃[h
	m_mimeTypes.Load(m_setting);

	//	ш搧L
	m_bandWidthMgr.Load(m_setting);

	//	O
	m_log.Init(this);

	//	҂󂯊Jn
	StartListen();

	//	XbhJn
	if(StartThread())
		throw CServerException("Xbh̊JnɎs܂");
	
	m_log.WriteSystemLog("T[oN܂");
}

CServer::~CServer(void)
{
	EndThread();
}


/*!
 	T[o̐ݒ
*/
void CServer::InitServerInfo(void)
{
	//	T[o[l[
	m_serverInfo.SetConfig("ServerName",SERVER_NAME);

	//	o[W
	m_serverInfo.SetConfig("ServerVersion",SERVER_VER);

	//	VOj`
	CString	sig = m_setting.GetConfig("Basic::ServerSignature","%ServerName%/%ServerVersion%");
	sig = m_serverInfo.GetKeySwapString(sig);
	m_serverInfo.SetConfig("ServerSignature",sig);
	
	//	T[o[[g
	m_serverInfo.SetConfig("ServerRoot",GET_APP()->GetAppPath());

	//	Settingu
	m_settingRoot.AddAutoSwap(new CSettingSwap(m_serverInfo));
}


/*!
 	҂󂯊Jn
*/
int CServer::StartListen(void)
{
	try
	{
		//	XiN
		m_listener.Init(m_setting);
	}
	catch(CFastListenerException err)
	{
		m_log.WriteSystemLog("SystemError : " + err.m_info);
		throw CServerException(err.m_info);
	}

	//	AhXo^
	CIPAddress localhost = CMySocket::GetLocalhost();
	m_serverInfo.SetConfig("ServerAddress",(CString)localhost);
	m_serverInfo.SetConfig("ServerHostName",localhost.GetHostName());

	//	|[go^
	m_serverInfo.SetConfig("ServerPort",m_setting.GetConfig("Basic::Port",80));

	return(0);
}

/*!
	Xbh{
*/
void CServer::ThreadMain()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain");

	CIntervalTimer	timer(1000);

	while(!m_break)
	{
		try
		{
			DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::Task1");
			//	ڑv́H
			CMySocket *sock = m_listener.GetNextAccess();
			if(sock != NULL)
			{
				if(m_connections.GetSize()<m_maxConnect)
				{
					CConnection	*connect = NULL;
					try
					{
						connect = new CConnection(this,sock);
						m_connections.Add(connect);
					}
					catch(CConnectionException e)
					{
						//	G[H
						m_log.WriteSystemLog("SystemError : %s",e.m_info);
						if(connect)
							delete connect;

						TRACE("SystemError : %s",e.m_info);
					}
				}
				else
				{
					//	ڑI[o[
					SendBusy(sock);
					delete sock;
				}
			}
			else
			{
				//	̂ŁA}^[
				Sleep(20);
			}

			DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::Task2");
			//	Iڑ̍폜
			for(int i=(int)m_connections.GetSize()-1;i>=0;i--)
			{
				if(((CConnection *)m_connections[i])->IsRunning() == 0)
				{
					delete (CConnection *)m_connections[i];
					m_connections.RemoveAt(i);
				}
			}

			DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::Task3");
			//	̍XV͂Pb
			if(timer)
			{
				DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::UpdateInfo1");

				//	݂̐ڑ
				m_serverInfo.SetConfig("CurrentConnection",(int)m_connections.GetSize());


				DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::UpdateInfo2");

				//	݂܂ł̐ڑ
				m_serverInfo.SetConfig("AllConnected",m_bandWidthMgr.GetAllCount());

				//	݂܂ł̓]
				m_serverInfo.SetConfig("AllRecvSize",m_bandWidthMgr.GetAllRecv());
				m_serverInfo.SetConfig("AllSendSize",m_bandWidthMgr.GetAllSend());

				//	ߋPԂ̐ڑ
				m_serverInfo.SetConfig("Connected1Hour",m_bandWidthMgr.GetCount1h());

				//	ߋPԂ̓]
				m_serverInfo.SetConfig("RecvSize1Hour",m_bandWidthMgr.GetRecv1h());
				m_serverInfo.SetConfig("SendSize1Hour",m_bandWidthMgr.GetSend1h());

				DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::UpdateInfo3");
				//	Xe[^XXVPH
				if(m_statusUpdate != -1 && m_statusUpdate + CTimeSpan(1,0,0,0) < CTime::GetCurrentTime())
				{
					m_statusUpdate = -1;
					GET_APP()->SetServerStatus("T[o͐ɍ쓮łB");
				}

				DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::CheckSocket");
				//	\Pbg͐킩H
				if(m_listener.IsError())
				{
					//	Đڑ
					m_listener.Close();
					Sleep(10000);
					StartListen();
				}

				DEBUG_SET_THREAD_FUNCTION_NAME("CServer::ThreadMain::LogOut");
				//	O̍XV
				m_log.UpdateLog();
			}
		}
		catch(CMemoryException *e)
		{
			e->Delete();

			//	ŝ߁AT[oꎞ~
			m_listener.Close();
			Sleep(30000);
			StartListen();

			m_log.WriteSystemLog("SystemError : ŝ߁A̐ڑؒf܂");
			SetServerStatus("so܂AT[on[h̋lĂB");
		}

	}

	//	N[Y
	m_listener.Close();

	//	SXbh~
	KillAllConnection();

	//	O̍XV
	m_log.WriteSystemLog("T[o~܂");
	m_log.UpdateLog();
}

/*!
	SĂ̐ڑ̒~
*/
void CServer::KillAllConnection()
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CServer::KillAllConnection");

	//	T[o[~tO
	m_serverInfo.SetConfig("StopServer",1);

	for(int i=(int)m_connections.GetSize()-1;i>=0;i--)
	{
		((CConnection *)m_connections[i])->Break();
	}

	for(int i=(int)m_connections.GetSize()-1;i>=0;i--)
	{
		delete (CConnection *)m_connections[i];
		m_connections.RemoveAt(i);
	}
}


/*!
	503𑗐M
*/
void CServer::SendBusy(CMySocket *socket)
{
	DEBUG_SET_THREAD_FUNCTION_NAME("CServer::SendBusy");

	TIMEOUT_SCOPE();
	SetTimeOut(10000);	//	10Sec

	static char _html[] =	"HTTP/1.0 503 Service Unavailable\r\n"\
							"Server: 04WebServer/0.10\r\n"\
							"Content-Type: text/html\r\n"\
							"Connection: Close\r\n"\
							"\r\n"\
							"<HTML><HEAD><TITLE>503 Service Unavailable</TITLE>"\
							"<meta http-equiv=\"Content-Type\" content=\"text/html;charset=Shift_JIS\"></HEAD>\n"\
							"<BODY><H1>Error : 503 Service Unavailable</H1>"\
							"<PRE>ڑE𒴂܂</PRE>"\
							"<HR><ADDRESS>04WebServer/"SERVER_VER"</ADDRESS>"\
							"</BODY></HTML>";

	m_errorSocket = socket;
	socket->Send(_html,(int)strlen(_html));
	socket->Close();
	m_errorSocket = NULL;

	m_log.WriteSystemLog("SystemError : ڑI[o[߁A503 Service Unavailable𑗐M܂");
	SetServerStatus("T[o͐ɍ쓮łAőڑI[o[ڑ܂BDoSUȂǂ̉\܂B");

	//	^CAEgĂAcSĐؒf
	if(IsTimeOut())
	{
		m_listener.Close();
		Sleep(30000);
		StartListen();

		m_log.WriteSystemLog("SystemError : T[oׂE𒴂߁A̐ڑؒf܂");
	}
}

/*!
	^CAEgnh
*/
void CServer::OnTimeOut()
{
	if(m_errorSocket != NULL)
		m_errorSocket->Close();

	CTimeOut::OnTimeOut();
}


/*!
	ID擾
*/
int CServer::GetNewID()
{
	SCOPE_LOCK();

	return(m_IDCounter++);
}

/*!
	T[oXe[^X̐ݒ
*/
void CServer::SetServerStatus(CString status)
{
	GET_APP()->SetServerStatus(status);
	m_statusUpdate = CTime::GetCurrentTime();
}

//	ڑ̎擾
int CServer::GetConnectCount()
{
	return(m_serverInfo.GetConfig("CurrentConnection",0));
}

/*!
	Setting̒uR[obN
*/
CString CSettingSwap::SwapString(CString key,CString data)
{
	//	DATE?
	if(	data.Find("Date") != -1 || 
		data.Find("Time") != -1 || 
		data.Find("GMT") != -1 || 
		data.Find("Year") != -1 || 
		data.Find("Month") != -1 || 
		data.Find("Day") != -1 || 
		data.Find("DayOfWeek") != -1 || 
		data.Find("MonthString") != -1 || 
		data.Find("DayOfWeekString") != -1 || 
		data.Find("Hour") != -1 || 
		data.Find("Minute") != -1 || 
		data.Find("Second") != -1)
	{
		CWorkspace	m_date;
		CWorkspaceAccess date = m_date.GetAccess("Date");
		date.Clear();

		//	
		CTime	time=CTime::GetCurrentTime();
		date.SetConfig("Date",time.Format("%Y/%m/%d"));
		date.SetConfig("Time",time.Format("%H:%M:%S"));
		date.SetConfig("GMT",CDateUtility::GetGMTString(time));

		date.SetConfig("Year",time.Format("%Y"));
		date.SetConfig("Month",time.Format("%m"));
		date.SetConfig("Day",time.Format("%d"));
		date.SetConfig("DayOfWeek",time.Format("%w"));

		date.SetConfig("MonthString",time.Format("%b"));
		date.SetConfig("DayOfWeekString",time.Format("%a"));

		date.SetConfig("Hour",time.Format("%H"));
		date.SetConfig("Minute",time.Format("%M"));
		date.SetConfig("Second",time.Format("%S"));
		data = date.GetKeySwapString(data,"");
	}

	//	Infoɂuim_serverInfõR[obNm_settinggpցI@fbhbN̉\j
	data = m_serverInfo.GetKeySwapString(data,"");

	return(data);
}

