#pragma once

#include "Workspace.h"
#include "threadskeleton.h"
#include "MySocket.h"
#include "logwriter.h"
#include "mimetypemgr.h"
#include "bandwidthmgr.h"
#include "fastlistener.h"


/*!
	class CServerException

	T[o[G[
*/
class CServerException
{
public:
	CServerException(CString info,int retry=0) {m_info = info;m_retry = retry;}

	CString	m_info;
	int		m_retry;
};

/*!
	class CSettingSwap

	T[oݒ̒u
*/
class CSettingSwap : public IWorkspaceAutoSwap
{
public:
	CSettingSwap(CWorkspaceAccess serverInfo) {m_serverInfo = serverInfo;};
	CString SwapString(CString key,CString data);
	void Delete() { delete this; };

	CWorkspaceAccess	m_serverInfo;	
};


/*!
	class CServer

	T[os܂
*/
class CServer : public CThreadSkeleton, public CTimeOut
{
public:
	CServer(void);
	virtual ~CServer(void);

	int GetNewID();
	CMimeTypeMgr GetCMimeTypeMgr() {SCOPE_LOCK(); return m_mimeTypes;};
	CBandWidthMgr *GetCBandWidthMgr() {return &m_bandWidthMgr;};
	void AddTrans(__int64 send,__int64 recv) {m_bandWidthMgr.AddTrans(send,recv);};
	void SetServerStatus(CString status);
	int GetConnectCount();

private:
	void InitServerInfo(void);				//!<	T[o̐ݒ
	int StartListen(void);					//!<	҂󂯊Jn
	void ThreadMain();						//!<	Xbh{
	void SendBusy(CMySocket *socket);		//!<	503𑗐M
	void KillAllConnection();				//!<	SĂ̐ڑ̒~

	virtual void OnTimeOut();				//!<	^CAEgnh

	int				m_maxConnect;			//!<	őڑ
	CMySocket		*m_errorSocket;			//!<	G[p\Pbg
	CPtrArray		m_connections;			//!<	ڑ
	int				m_IDCounter;			//!<	IDJE^
	CMimeTypeMgr	m_mimeTypes;			//!<	MimeTypẽLbV
	CBandWidthMgr	m_bandWidthMgr;			//!<	ш搧
	CFastListener	m_listener;				//!<	}`XbhXi

public:
	CWorkspace			m_context;				//!<	ReLXg[g
	CWorkspace			m_settingRoot;			//!<	ݒ胋[g
	CWorkspace			m_infoRoot;				//!<	T[o񃋁[g
	CWorkspaceAccess	m_setting;				//!<	ݒ
	CWorkspaceAccess	m_threadContext;		//!<	Xbh̈
	CWorkspaceAccess	m_threadContextLog;		//!<	Xbh̈̃O
	CWorkspaceAccess	m_serverInfo;			//!<	T[o̈
	CTime			m_statusUpdate;			//!<	T[oXe[^XύXꂽ

	CLogWriter		m_log;					//!<	OC^[
};

