#include "StdAfx.h"
#include "ServerControlPipeServer.h"
#include "04WebServer.h"

enum
{
	//!	R}hɓΉ
	CONTROL_ERROR_COMMAND_NOT_SUPPORTED		= 1000,

	//!	T[oJns
	CONTROL_ERROR_START_SERVER				= 2000,

	//!	T[o~Ŏss\
	CONTROL_ERROR_SERVER_IS_STOPPED			= 3000,
};



CServerControlPipeServer::CServerControlPipeServer(void)
{
}

CServerControlPipeServer::~CServerControlPipeServer(void)
{
}

//////////////////////////////////////////////////////////////////////////////////
//	Rg[
//////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
int CServerControlPipeServer::Start()
{
	//	pCv
	if(m_pipeServer.Start(CONTROL_PIPE_NAME,	CONTROL_PIPE_MAX,	this))
		return(-1);
	return(0);
}

/*!
	~
*/
void CServerControlPipeServer::Stop()
{
	m_pipeServer.Stop();
}

/*!
	݃pCv݂邩`FbN
*/
int CServerControlPipeServer::CheckOther()
{
	CString pipeName = CONTROL_PIPE_NAME;
	if(pipeName.Left(2) != "\\\\")
		pipeName = "\\\\.\\pipe\\" + pipeName;

	//	J
	HANDLE hPipe = ::CreateFile (pipeName,	GENERIC_READ | GENERIC_WRITE, 0, NULL,
							OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hPipe == INVALID_HANDLE_VALUE)
		return(FALSE);

	CloseHandle(hPipe);
	return(TRUE);
}


//////////////////////////////////////////////////////////////////////////////////
//	CPipeCommandExecuteBase
//////////////////////////////////////////////////////////////////////////////////
/*!
	NCAg̃R}hs
*/
int CServerControlPipeServer::OnRecvCommand(CBuffer &recvData, CBuffer &sendData)
{
	//	ی (݁ACommand͒PXbhŏ邪AÔ)
	SCOPE_LOCK();

	//	pPbg
	CCommandPacket	recvPacket, sendPacket;
	if(recvPacket.FromBuffer(recvData))
		return(-1);

	TRACE(_T("Command : %s\n"), recvPacket.GetCommand());

	//	R}h̎s
	int	ret = 0;
	if(recvPacket.GetCommand() == _T("StartServer"))
	{
		//	T[oNEċN
		ret = DoStartServer(recvPacket, sendPacket);
	}
	else if(recvPacket.GetCommand() == _T("StopServer"))
	{
		//	T[o~
		ret = DoStopServer(recvPacket, sendPacket);
	}
	else if(recvPacket.GetCommand() == _T("GetServerErrorString"))
	{
		//	T[oG[擾
		ret = DoGetServerErrorString(recvPacket, sendPacket);
	}
	else if(recvPacket.GetCommand() == _T("GetServerRoot"))
	{
		//	T[o[g擾
		ret = DoGetServerRoot(recvPacket, sendPacket);
	}
	else if(recvPacket.GetCommand() == _T("GetConnectionCount"))
	{
		//	ڑ擾
		ret = DoGetConnectCount(recvPacket, sendPacket);
	}
	else if(recvPacket.GetCommand() == _T("IsRunning"))
	{
		//	sԎ擾
		ret = DoIsRunning(recvPacket, sendPacket);
	}
	else if(recvPacket.GetCommand() == _T("IsService"))
	{
		//	N[h擾
		ret = DoIsService(recvPacket, sendPacket);
	}
	else if(recvPacket.GetCommand() == _T("GetServerInfo"))
	{
		//	T[o擾
		ret = DoGetServerInfo(recvPacket, sendPacket);
	}
	else if(recvPacket.GetCommand() == _T("GetServerSetting"))
	{
		//	T[oݒ擾
		ret = DoGetServerSetting(recvPacket, sendPacket);
	}
	else if(recvPacket.GetCommand() == _T("GetServerContext"))
	{
		//	ڑ擾
		ret = DoGetServerContext(recvPacket, sendPacket);
	}
	else
	{
		//	T|[gO
		ret = 0;
		sendPacket.SetErrorPacket(CONTROL_ERROR_COMMAND_NOT_SUPPORTED, _T("Command not Supported"));
	}

	//	ԐM
	if(ret == 0)
	{
		sendPacket.ToBuffer(sendData);
		return(0);
	}
	else
	{
		return(ret);
	}

	return(0);
}


//////////////////////////////////////////////////////////////////////////////////
//	R}hs
//////////////////////////////////////////////////////////////////////////////////
/*!
	T[oNEċN
*/
int CServerControlPipeServer::DoStartServer(CCommandPacket &recvPacket, CCommandPacket &sendPacket)
{
	//	T[oN
	if(GET_APP()->StartServer() == 0)
		sendPacket.SetSuccessPacket();
	else
		sendPacket.SetErrorPacket(CONTROL_ERROR_START_SERVER, GET_APP()->GetServerErrorInfo());

	return(0);
}

/*!
	T[o~
*/
int CServerControlPipeServer::DoStopServer(CCommandPacket &recvPacket, CCommandPacket &sendPacket)
{
	GET_APP()->StopServer();

	//	G[ɂȂ鎖͂Ȃ
	sendPacket.SetSuccessPacket();

	return(0);
}

/*!
	T[oG[擾
*/
int CServerControlPipeServer::DoGetServerErrorString(CCommandPacket &recvPacket, CCommandPacket &sendPacket)
{
	//	
	sendPacket.SetSuccessPacket();
	sendPacket.SetCommandOption(_T("ServerErrorString"), GET_APP()->GetServerErrorInfo());

	return(0);
}

/*!
	T[o[g擾
*/
int CServerControlPipeServer::DoGetServerRoot(CCommandPacket &recvPacket, CCommandPacket &sendPacket)
{
	//	
	sendPacket.SetSuccessPacket();
	sendPacket.SetCommandOption(_T("ServerRoot"), GET_APP()->GetServerRoot());

	return(0);
}

/*!
	ڑ擾
*/
int CServerControlPipeServer::DoGetConnectCount(CCommandPacket &recvPacket, CCommandPacket &sendPacket)
{
	//	
	sendPacket.SetSuccessPacket();
	sendPacket.SetCommandOptionInt(_T("ConnectionCount"), GET_APP()->GetConnectCount());

	return(0);
}

/*!
	sԎ擾
*/
int CServerControlPipeServer::DoIsRunning(CCommandPacket &recvPacket, CCommandPacket &sendPacket)
{
	//	
	sendPacket.SetSuccessPacket();
	sendPacket.SetCommandOptionInt(_T("IsRunning"), GET_APP()->ServerRunning());

	return(0);
}

/*!
	N[h擾
*/
int CServerControlPipeServer::DoIsService(CCommandPacket &recvPacket, CCommandPacket &sendPacket)
{
	//	
	sendPacket.SetSuccessPacket();
	sendPacket.SetCommandOptionInt(_T("IsService"), GET_APP()->IsService());

	return(0);
}

/*!
	T[o擾
*/
int CServerControlPipeServer::DoGetServerInfo(CCommandPacket &recvPacket, CCommandPacket &sendPacket)
{
	if(GET_APP()->GetServerInfo(sendPacket.GetAttachedDataAccess()) == 0)
		sendPacket.SetSuccessPacket();
	else
		sendPacket.SetErrorPacket(CONTROL_ERROR_SERVER_IS_STOPPED, GET_APP()->GetServerErrorInfo());
		
	return(0);
}

/*!
	T[oݒ擾
*/
int CServerControlPipeServer::DoGetServerSetting(CCommandPacket &recvPacket, CCommandPacket &sendPacket)
{
	if(GET_APP()->GetServerSetting(sendPacket.GetAttachedDataAccess()) == 0)
		sendPacket.SetSuccessPacket();
	else
		sendPacket.SetErrorPacket(CONTROL_ERROR_SERVER_IS_STOPPED, GET_APP()->GetServerErrorInfo());
		
	return(0);
}

/*!
	ڑ擾
*/
int CServerControlPipeServer::DoGetServerContext(CCommandPacket &recvPacket, CCommandPacket &sendPacket)
{
	if(GET_APP()->GetServerContext(sendPacket.GetAttachedDataAccess()) == 0)
		sendPacket.SetSuccessPacket();
	else
		sendPacket.SetErrorPacket(CONTROL_ERROR_SERVER_IS_STOPPED, GET_APP()->GetServerErrorInfo());
		
	return(0);
}

