#pragma once


//!	CreateMutexێ֐
class CSyncMutex
{
public:
	CSyncMutex()
	{
		m_mutex = NULL;
	};
	
	virtual ~CSyncMutex()
	{
		Close();
	};

	//	쐬
	int Create(BOOL bInitialOwner)
	{
		Close();

		m_mutex = ::CreateMutex(NULL,bInitialOwner,NULL);
		if(m_mutex == NULL)
			return(-1);
		return(0);
	}

	//	
	void Close()
	{
		SAFE_CLOSE_HANDLE(m_mutex);
	}

	//	nh̎擾
	__inline operator HANDLE() { return m_mutex; };

protected:
	HANDLE	m_mutex;
};

//!	CreateEventێ֐
class CSyncEvent
{
public:
	CSyncEvent()
	{
		m_event = NULL;
	};
	
	virtual ~CSyncEvent()
	{
		Close();
	};

	//	쐬
	int Create(BOOL bManualReset, BOOL bInitialState)
	{
		Close();

		m_event = ::CreateEvent(NULL,bManualReset,bInitialState,NULL);
		if(m_event == NULL)
			return(-1);
		return(0);
	}

	//	
	void Close()
	{
		SAFE_CLOSE_HANDLE(m_event);
	}

	//	nh̎擾
	__inline operator HANDLE() { return m_event; };

protected:
	HANDLE	m_event;
};


//!	CSyncSemaphoreێ֐
class CSyncSemaphore
{
public:
	CSyncSemaphore()
	{
		m_semaphore = NULL;
	};
	
	virtual ~CSyncSemaphore()
	{
		Close();
	};

	//	쐬
	int Create(LONG lInitialCount, LONG lMaximumCount)
	{
		Close();

		m_semaphore = ::CreateSemaphore(NULL,lInitialCount,lMaximumCount,NULL);
		if(m_semaphore == NULL)
			return(-1);
		return(0);
	}

	//	
	void Close()
	{
		SAFE_CLOSE_HANDLE(m_semaphore);
	}

	//	nh̎擾
	__inline operator HANDLE() { return m_semaphore; };

protected:
	HANDLE	m_semaphore;
};

//!	WaitableTimerێ֐
class CSyncTimer
{
public:
	CSyncTimer()
	{
		m_timer = NULL;
	};
	
	virtual ~CSyncTimer()
	{
		Close();
	};

	//	쐬
	int Create(int waitMs)
	{
		Close();

		//	쐬
		m_timer = ::CreateWaitableTimer(NULL,FALSE,NULL);
		if(m_timer == NULL)
			return(-1);

		//	N
		LARGE_INTEGER	largeTime;
		largeTime.QuadPart = -10000 * (__int64)waitMs;
		if(!SetWaitableTimer(m_timer, &largeTime, waitMs, NULL, NULL, FALSE))
			return(-1);

		return(0);
	}

	//	
	void Close()
	{
		SAFE_CLOSE_HANDLE(m_timer);
	}

	//	nh̎擾
	__inline operator HANDLE() { return m_timer; };

protected:
	HANDLE	m_timer;
};


//	InterlockedJE^
class CInterlockCounter
{
protected:
	LONG	m_counter;

public:
	//	
	CInterlockCounter()
	{
		::InterlockedExchange(&m_counter,0);
	};

	//	CNg
	__inline int IncCounter()
	{
		return(::InterlockedIncrement(&m_counter));
	};

	//	fNg
	__inline int DecCounter()
	{
		return(::InterlockedDecrement(&m_counter));
	};

	//	Z
	__inline int AddCounter(int add)
	{
		return(::InterlockedExchangeAdd(&m_counter, add));
	};

	//	擾
	__inline int GetCounter()
	{
		return(::InterlockedExchangeAdd(&m_counter,0));
	};

	//	ݒ
	__inline void SetCounter(int count)
	{
		::InterlockedExchange(&m_counter,count);
	};

	///////////////////////////////////////////////////////////////////
	//	Zq
	///////////////////////////////////////////////////////////////////
	//	擾
	__inline operator int()
	{
		return(::InterlockedExchangeAdd(&m_counter,0));
	};

	//	ݒ
	__inline void operator=(const int &other)
	{
		::InterlockedExchange(&m_counter,other);
	};
/*
	//	CNg
	__inline int operator++()
	{
		return(::InterlockedIncrement(&m_counter));
	};

	//	fNg
	__inline int operator--()
	{
		return(::InterlockedDecrement(&m_counter));
	};
*/
};


//!	IOCP
class CIOCompletePort
{
public:
	//!	
	CIOCompletePort()
	{
		m_hIocp = NULL;
	};

	//!	I
	virtual ~CIOCompletePort()
	{
		Close();
	};
	
	
	//!	쐬
	int Create(int NumberOfConcurrentThreads, HANDLE attach = INVALID_HANDLE_VALUE, int key = 0)
	{
		Close();

		m_hIocp = CreateIoCompletionPort(attach, NULL, key, NumberOfConcurrentThreads);
		if(m_hIocp == NULL)
			return(-1);

		return(0);
	};

	//!	
	void Close()
	{
		SAFE_CLOSE_HANDLE(m_hIocp);
	}

	//!	蓖
	int SetToDeviceHANDLE(HANDLE hDevice, ULONG_PTR dwCompKey)
	{
		HANDLE ret = CreateIoCompletionPort(hDevice, m_hIocp, dwCompKey, 0);
		if(ret != m_hIocp)
			return(-1);

		return(0);
	};
	
	//!	蓖
	static int SetToDeviceHANDLE(HANDLE hIocp, HANDLE hDevice, ULONG_PTR dwCompKey)
	{
		HANDLE ret = CreateIoCompletionPort(hDevice, hIocp, dwCompKey, 0);
		if(ret != hIocp)
			return(-1);

		return(0);
	};

	//	nh̎擾
	__inline operator HANDLE() { return m_hIocp; };

protected:
	///////////////////////////////////////////////////////////////////
	//	o
	///////////////////////////////////////////////////////////////////
	//!	IOCP
	HANDLE	m_hIocp;
};
