#pragma once

#include "LockObject.h"
#include "TimeOut.h"

/*!
	class CThreadSkeleton

	Xbh̃x[Xł
*/
class CThreadSkeleton
{
protected:
	CCriticalSection	m_scopeLock;

public:
	CThreadSkeleton(void);
	virtual ~CThreadSkeleton(void);

public:
	int StartThread();		//!<	Xbh̊Jn
	int IsRunning();		//!<	s擾
	void EndThread();		//!<	Xbh̏IEI
	virtual void Break();	//!<	f
	int GetBreak();			//!<	fv擾

protected:
	virtual void ThreadMain() = 0;	//!<	Xbh̏
	void _ThreadMain();				//!<	Xbh̏

	CLockObject<int>	m_break;	//!<	ftO
	CLockObject<int>	m_run;		//!<	stO

	//!	sNX
	char				*m_className;

	//!	s֐
	char				*m_functionName;

private:
	static UINT WorkThread(LPVOID pParam);
};

//!	NXݒ
#define	DEBUG_SET_THREAD_CLASS_NAME(name)	{ m_className = name; };

//!	֐ݒ
#define	DEBUG_SET_THREAD_FUNCTION_NAME(name)	{ m_functionName = name; };