/*
	\file	CWorkspace.h
	\brief	KwϐǗNX

	2006/04/05	XMLۑ`̕ύX
	2006/11/14	XMLo͕@ύX
*/

#pragma once

#include ".\workspacenode.h"
#include ".\Buffer.h"
#include ".\workspaceaccess.h"




class CWorkspaceLock;
class CWorkspaceAccess;
class CWorkspace
{
	friend class CWorkspaceAccess;
	friend class CWorkspaceLock;
	friend class CWorkspaceStringList;

public:
	CWorkspace(CString className = _T(""));
	virtual ~CWorkspace(void);

	/////////////////////////////////////////////////////////////////////////////////////
	//	ANZX\Ȋ֐
	/////////////////////////////////////////////////////////////////////////////////////
	//!	ANZXNX擾
	CWorkspaceAccess GetAccess(CString path);

	//!	ANZXNX擾AgNA
	CWorkspaceAccess GetCleanAccess(CString path);

	/////////////////////////////////////////////////////////////////////////////////////
	//	o͂Ɋւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	XMLt@C֏o
	int SaveToXMLFile(CString filePath, CString savePath = _T(""));

	//!	XMLt@C胍[h
	int LoadFromXMLFile(CString filePath);


	//!	XML֏o
	CStringA ToXMLStringUTF8(CString savePath = _T(""));

	//!	XML񂩂琶
	int FromXMLStringUTF8(CStringA xml);

	//!	XML֏o
	CStringA ToXMLString(CString savePath = _T(""));

	//!	XML񂩂琶
	int FromXMLString(CStringA xml);

	/////////////////////////////////////////////////////////////////////////////////////
	//	ݒ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	[hI[
	void SetReadOnly(int readOnly);

	//!	u(Âɒus)
	void AddAutoSwap(IWorkspaceAutoSwapPtr autoSwap);

	//!	u
	void DelAutoSwap(IWorkspaceAutoSwapPtr autoSwap);

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	Ȃ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Sf[^NA
	void Clear(CString path);

	//!	Rs[
	void Copy(CString destPath, CString srcPath, CWorkspace* srCWorkspace=NULL);

	/////////////////////////////////////////////////////////////////////////////////////
	//	KeyɊւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	f[^̐ݒ
	void SetKeyData(CString path, CString data,int noCase=FALSE);

	//!	f[^̎擾
	CString GetKeyData(CString path, CString defaultData,int noCase=FALSE);

	//!	f[^̍폜
	void DeleteKey(CString path);

	//!	L[擾
	int GetKeyCount(CString path);

	//!	SẴL[𕶎ƂĎ擾
	int GetAllKey(CString path,CStringArray &list);

	//!	SẴL[Rs[
	void CopyAllKeys(CString path,CKeyDataArray &keyData);

	//!	񒆂̃L[f[^ɒu擾
	CString GetKeySwapString(CString path,CString str,CString noData, IWorkspaceAutoSwapPtr tempSwap = NULL);

	/////////////////////////////////////////////////////////////////////////////////////
	//	KeyɊւ鏈 - WorkspaceStringList
	/////////////////////////////////////////////////////////////////////////////////////
	//!	L[
	int FindKeyData(CString path, CString sData, int noCase = FALSE);

	//!	L[
	int FindKeyDataPath(CString path, CString fPath, int eqPath = FALSE);

	/////////////////////////////////////////////////////////////////////////////////////
	//	Tum[hɊւ鏈
	/////////////////////////////////////////////////////////////////////////////////////
	//!	m[h폜
	void DeleteNode(CString path);

	//!	Tum[h𓾂
	int GetSubNodeCount(CString path);

	//!	SẴTum[h𕶎ƂĎ擾
	int GetAllSubNode(CString path,CStringArray &list);


	
protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	̑̏
	/////////////////////////////////////////////////////////////////////////////////////
	//!	m[hpXɕύX
	CString ToNodePath(CString path);

	//!	Tum[h̃|C^擾
	CWorkspaceNode	*GetSubNode(CString &path,CString &key);

	//!	Rs[
	void _Copy(CWorkspaceNode *dest, CString srcPath);

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Ɨ̈̃[g
	CWorkspaceNode		m_root;

	//!	bNIuWFNg
	CCriticalSection	m_scopeLock;

	//!	NX
	CString				m_className;

	//!	[hI[
	int						m_readOnly;

	//!	u
	CTypedPtrArray<CPtrArray, IWorkspaceAutoSwapPtr>	m_autoSwap;

private:
	//!	Rs[֎~
	CWorkspace(const CWorkspace &other);
	void operator=(const CWorkspace &other);
};


class CWorkspaceLock
{
public:
	CWorkspaceLock(CWorkspaceAccess wa)
	{
		m_ws = wa.GetRoot();
		m_ws->m_scopeLock.Lock();
	};

	virtual ~CWorkspaceLock()
	{
		m_ws->m_scopeLock.Unlock();
	};


	CWorkspace	*m_ws;
};


#define	WORKSPACE_LOCK(x) CWorkspaceLock __lock(x);

